/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerGroup;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.util.GenericNode;
import com.iplanet.services.util.I18n;
import com.iplanet.services.util.XMLException;
import com.iplanet.services.util.XMLParser;
import com.sun.identity.security.ServerInstanceAction;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.util.ConnectionPool;

public class DSConfigMgr {
    private static final String LDAP_CONNECTION_NUM_RETRIES = "com.iplanet.am.ldap.connection.num.retries";
    private static final String LDAP_CONNECTION_RETRY_INTERVAL = "com.iplanet.am.ldap.connection.delay.between.retries";
    private static final String LDAP_CONNECTION_ERROR_CODES = "com.iplanet.am.ldap.connection.ldap.error.codes.retries";
    private static final String CONFIG_FILE_NAME = "serverconfig.xml";
    private static final String RUN_TIME_CONFIG_PATH = "com.iplanet.coreservices.configpath";
    private static int connNumRetry;
    private static int connRetryInterval;
    private static HashSet retryErrorCodes;
    static Debug debugger;
    Hashtable groupHash = null;
    public static final String ROOT = "iPlanetDataAccessLayer";
    public static final String SERVERGROUP = "ServerGroup";
    public static final String SERVER = "Server";
    public static final String USER = "User";
    public static final String SERVER_ID = "serverid";
    public static final String CERTIFICATE = "Certificate";
    public static final String AUTH_USER_ID = "authUser";
    public static final String AUTH_ID = "DirDN";
    public static final String AUTH_PASSWD = "DirPassword";
    public static final String AUTH_TYPE = "type";
    public static final String BASE_DN = "BaseDN";
    public static final String MISC_CONFIG = "MiscConfig";
    public static final String NAME = "name";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String MAX_CONN_POOL = "maxConnPool";
    public static final String MIN_CONN_POOL = "minConnPool";
    public static final String VALUE = "value";
    public static final String VAL_INACTIVE = "inactive";
    public static final String VAL_AUTH_BASIC = "auth";
    public static final String VAL_AUTH_PROXY = "proxy";
    public static final String VAL_AUTH_REBIND = "rebind";
    public static final String VAL_AUTH_ADMIN = "admin";
    public static final String VAL_AUTH_ANONYMOUS = "anonymous";
    public static final String VAL_STYPE_SSL = "SSL";
    public static final String VAL_STYPE_SIMPLE = "SIMPLE";
    public static final int DEF_INIT_CP_LEN = 1;
    public static final int DEF_MAX_CP_LEN = 1;
    static DSConfigMgr thisInstance;
    private static I18n i18n;
    public static final String SCHEMA_BUG_PROPERTY = "com.netscape.ldap.schema.quoting";
    public static final String VAL_STANDARD = "standard";
    public static final String INVALID_SERVER_ID = "InvalidServerID";
    public static final String SERVER_ID_DOES_NOT_EXIST = "ServerIDDoesNotExist";
    public static final String INVALID_USER_ID = "InvalidUserID";
    public static final String DEFAULT = "default";

    DSConfigMgr() {
        i18n = I18n.getInstance((String)"amSDK");
        this.groupHash = new Hashtable();
    }

    public static synchronized DSConfigMgr getDSConfigMgr() throws LDAPServiceException {
        if (thisInstance == null) {
            String string = SystemProperties.get((String)"com.iplanet.services.configpath");
            if (string == null) {
                string = System.getProperty(RUN_TIME_CONFIG_PATH);
            }
            String string2 = string + System.getProperty("file.separator") + CONFIG_FILE_NAME;
            thisInstance = new DSConfigMgr();
            thisInstance.loadServerConfiguration(string2);
        }
        return thisInstance;
    }

    public ServerGroup getServerGroup(String string) {
        return (ServerGroup)this.groupHash.get(string);
    }

    public LDAPConnection getNewProxyConnection(String string) throws LDAPServiceException {
        return this.getNewConnection(string, LDAPUser.Type.AUTH_PROXY);
    }

    public LDAPConnection getNewProxyConnection() throws LDAPServiceException {
        return this.getNewProxyConnection(DEFAULT);
    }

    public LDAPConnection getNewBasicConnection(String string) throws LDAPServiceException {
        return this.getNewConnection(string, LDAPUser.Type.AUTH_BASIC);
    }

    public LDAPConnection getNewAdminConnection() throws LDAPServiceException {
        return this.getNewConnection(DEFAULT, LDAPUser.Type.AUTH_ADMIN);
    }

    public LDAPConnection getNewBasicConnection() throws LDAPServiceException {
        return this.getNewBasicConnection(DEFAULT);
    }

    public LDAPConnection getNewConnection(String string, LDAPUser.Type type) throws LDAPServiceException {
        return this.getNewFailoverConnection(string, type);
    }

    public ConnectionPool getAnonymousConnectionPool() throws LDAPServiceException {
        LDAPConnection lDAPConnection = this.getNewFailoverConnection(DEFAULT, LDAPUser.Type.AUTH_ANONYMOUS);
        try {
            ServerInstance serverInstance = this.getServerInstance(DEFAULT, LDAPUser.Type.AUTH_ANONYMOUS);
            return new ConnectionPool(serverInstance.getMinConnections(), serverInstance.getMaxConnections(), lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            if (debugger.messageEnabled()) {
                debugger.message("Failed to create anon conn pool" + lDAPException);
            }
            throw new LDAPServiceException(DSConfigMgr.getString("dscfg-connectFail"));
        }
    }

    public LDAPConnection getNewFailoverConnection(String string, LDAPUser.Type type) throws LDAPServiceException {
        debugger.message("in DSConfigMgr.getNewFailoverConneciton()");
        String string2 = this.getHostName(string);
        if (string2.length() == 0) {
            throw new LDAPServiceException(DSConfigMgr.getString("dscfg-serverNotFound"));
        }
        if (debugger.messageEnabled()) {
            debugger.message("Hostname =" + string2);
        }
        ServerInstance serverInstance = this.getServerInstance(string, type);
        String string3 = null;
        String string4 = null;
        if (!type.equals(LDAPUser.Type.AUTH_ANONYMOUS)) {
            string3 = serverInstance.getAuthID();
            string4 = (String)AccessController.doPrivileged(new ServerInstanceAction(serverInstance));
        }
        return this.getConnection(string2, 389, serverInstance.getConnectionType(), string3, string4);
    }

    private LDAPConnection getConnection(String string, int n, Server.Type type, String string2, String string3) throws LDAPServiceException {
        LDAPConnection lDAPConnection = null;
        if (type == Server.Type.CONN_SSL) {
            try {
                lDAPConnection = new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory());
            }
            catch (Exception exception) {
                debugger.error("getConnection.JSSSocketFactory", (Throwable)exception);
                throw new LDAPServiceException(DSConfigMgr.getString("dscfg-jssSockFactoryFail"));
            }
        } else {
            lDAPConnection = new LDAPConnection();
        }
        int n2 = 0;
        while (n2 <= connNumRetry) {
            if (debugger.messageEnabled()) {
                debugger.message("DSConfigMgr.getConnection retry: " + n2);
            }
            try {
                if (string2 != null && string3 != null) {
                    lDAPConnection.connect(3, string, n, string2, string3);
                    break;
                }
                lDAPConnection.connect(string, n);
                break;
            }
            catch (LDAPException lDAPException) {
                if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n2 == connNumRetry) {
                    debugger.error("Connection to LDAP server threw exception:", (Throwable)lDAPException);
                    throw new LDAPServiceException(DSConfigMgr.getString("dscfg-connectFail"), lDAPException);
                }
                ++n2;
                try {
                    Thread.currentThread();
                    Thread.sleep(connRetryInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return lDAPConnection;
    }

    public String getHostName(String string) {
        ServerGroup serverGroup = this.getServerGroup(string);
        Collection collection = serverGroup.getServersList();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            stringBuffer.append(server.getServerName());
            stringBuffer.append(':');
            stringBuffer.append(server.getPort());
            stringBuffer.append(' ');
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ServerInstance getServerInstance(String string, LDAPUser.Type type) {
        if (string == null) {
            return null;
        }
        ServerGroup serverGroup = this.getServerGroup(string);
        if (serverGroup != null) {
            return serverGroup.getServerInstance(type);
        }
        return null;
    }

    public ServerInstance getServerInstance(LDAPUser.Type type) {
        return this.getServerInstance(DEFAULT, type);
    }

    private void loadServerConfiguration(String string) throws LDAPServiceException {
        XMLParser xMLParser = new XMLParser(true);
        Object var3_3 = null;
        GenericNode genericNode = null;
        xMLParser.register(SERVERGROUP, "com.iplanet.services.ldap.ServerGroup");
        xMLParser.register(SERVER, "com.iplanet.services.ldap.Server");
        xMLParser.register(USER, "com.iplanet.services.ldap.LDAPUser");
        try {
            genericNode = (GenericNode)xMLParser.parse((InputStream)new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new LDAPServiceException(19, fileNotFoundException.getMessage());
        }
        catch (XMLException xMLException) {
            xMLException.printStackTrace();
        }
    }

    public String toString() {
        return this.groupHash.toString();
    }

    static String getString(String string) {
        return i18n.getString(string);
    }

    static {
        String string;
        block10: {
            String string2;
            block9: {
                connNumRetry = 3;
                connRetryInterval = 1000;
                retryErrorCodes = new HashSet();
                debugger = null;
                debugger = Debug.getInstance((String)"amSDK");
                String string3 = SystemProperties.get((String)LDAP_CONNECTION_NUM_RETRIES);
                if (string3 != null) {
                    try {
                        connNumRetry = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!debugger.warningEnabled()) break block9;
                        debugger.warning("Invalid value for com.iplanet.am.ldap.connection.num.retries");
                    }
                }
            }
            if ((string2 = SystemProperties.get((String)LDAP_CONNECTION_RETRY_INTERVAL)) != null) {
                try {
                    connRetryInterval = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!debugger.warningEnabled()) break block10;
                    debugger.warning("Invalid value for com.iplanet.am.ldap.connection.delay.between.retries");
                }
            }
        }
        if ((string = SystemProperties.get((String)LDAP_CONNECTION_ERROR_CODES)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                retryErrorCodes.add(stringTokenizer.nextToken().trim());
            }
        }
        if (debugger.messageEnabled()) {
            debugger.message("DataLayer: number of retry = " + connNumRetry);
            debugger.message("DataLayer: retry interval = " + connRetryInterval);
            debugger.message("DataLayer: retry error codes = " + retryErrorCodes);
        }
        thisInstance = null;
        i18n = null;
    }
}

