/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.server;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.PLLBundle;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.naming.service.NamingService;
import com.sun.identity.authentication.server.AccountLockoutService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PLLRequestServlet
extends HttpServlet {
    private static final String sccsID = "@(#)PLLRequestServlet.java\t1.12  00/04/06 04/06/00  Sun Microsystems, Inc.";
    private static Hashtable requestHandlers = new Hashtable();
    private static final String PROPERTY_MAX_CONTENT_LENGTH = "com.iplanet.services.comm.server.pllrequest.maxContentLength";
    private static int maxContentLength = 16384;

    public void init() throws ServletException {
        block2: {
            String string = SystemProperties.get((String)PROPERTY_MAX_CONTENT_LENGTH, (String)String.valueOf(maxContentLength));
            try {
                maxContentLength = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (!PLLServer.pllDebug.messageEnabled()) break block2;
                PLLServer.pllDebug.message("Invalid value [" + string + "] for property" + PROPERTY_MAX_CONTENT_LENGTH);
            }
        }
    }

    /*
     * Loose catch block
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        block14: {
            int n = httpServletRequest.getContentLength();
            if (n == -1) {
                throw new ServletException(PLLBundle.getString((String)"unknownLength"));
            }
            if (n > maxContentLength) {
                if (PLLServer.pllDebug.messageEnabled()) {
                    PLLServer.pllDebug.message("content length too large" + n);
                }
                throw new ServletException(PLLBundle.getString((String)"largeContentLength"));
            }
            byte[] byArray = new byte[n];
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            int n2 = 0;
            int n3 = 0;
            while (n2 != n) {
                int n4 = servletInputStream.read(byArray, n3, n - n3);
                if (n4 == -1) {
                    throw new ServletException(PLLBundle.getString((String)"readRequestError"));
                }
                n2 += n4;
                n3 += n4;
            }
            String string2 = new String(byArray, 0, n, "UTF-8");
            if (PLLServer.pllDebug.messageEnabled()) {
                PLLServer.pllDebug.message("\nReceived RequestSet XML :\n" + string2);
            }
            string = this.handleRequest(string2, httpServletRequest, httpServletResponse);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), "UTF-8");
            outputStreamWriter.write(string);
            outputStreamWriter.flush();
            Object var13_12 = null;
            try {
                outputStreamWriter.close();
            }
            catch (Exception exception) {}
            break block14;
            {
                catch (IOException iOException) {
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (PLLServer.pllDebug.messageEnabled()) {
            PLLServer.pllDebug.message("\nSent ResponseSet XML : " + string);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.print("Webtop 2.5 Platform Low Level request servlet");
        servletOutputStream.flush();
    }

    private String handleRequest(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        RequestSet requestSet = RequestSet.parseXML((String)string);
        if (!this.isValid(requestSet)) {
            throw new ServletException(PLLBundle.getString((String)"invalidRequestSet"));
        }
        String string2 = requestSet.getServiceID();
        RequestHandler requestHandler = this.getServiceHandler(string2);
        if (requestHandler == null) {
            throw new ServletException(PLLBundle.getString((String)"noRequestHandler"));
        }
        ResponseSet responseSet = requestHandler.process(requestSet.getRequests(), httpServletRequest, httpServletResponse);
        responseSet.setRequestSetID(requestSet.getRequestSetID());
        return responseSet.toXMLString();
    }

    private boolean isValid(RequestSet requestSet) {
        return requestSet != null && requestSet.getRequestSetVersion() != null && requestSet.getServiceID() != null && requestSet.getRequestSetID() != null && requestSet.getRequests().size() >= 1;
    }

    private RequestHandler getServiceHandler(String string) {
        RequestHandler requestHandler = (RequestHandler)requestHandlers.get(string);
        if (requestHandler == null) {
            try {
                if (string.equals("com.iplanet.am.naming")) {
                    requestHandler = new NamingService();
                } else if (string.equals("iplanet-am-naming-auth-alo-class")) {
                    requestHandler = new AccountLockoutService();
                } else {
                    String string2 = WebtopNaming.getServiceClass((String)string);
                    if (string2 != null) {
                        Class<?> clazz = Class.forName(string2);
                        requestHandler = (RequestHandler)clazz.newInstance();
                    } else if (PLLServer.pllDebug.messageEnabled()) {
                        PLLServer.pllDebug.message("Service handler for :" + string + " not found");
                    }
                }
                if (requestHandler != null) {
                    requestHandlers.put(string, requestHandler);
                }
            }
            catch (Exception exception) {
                PLLServer.pllDebug.message("Cannot get service handler for " + string + " :", (Throwable)exception);
                return null;
            }
        }
        return requestHandler;
    }
}

