/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientTypesManager;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.services.cdm.clientschema.AMClientDataListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DefaultClientTypesManager
implements ClientTypesManager,
AMClientDataListener {
    protected static final String CDM_SERVICE_NAME = "iPlanetAMClientDetection";
    private static final String CDM_DEFAULT_CLIENT_TYPES_ATTR = "iplanet-am-client-detection-default-client-type";
    private static Debug debug = Debug.getInstance((String)"amClientDetection");
    private static SSOToken internalToken = null;
    private static final String DEFAULT = "default";
    private static String defaultClientType = null;
    private static Map internalClientData = new Hashtable();
    private static Map externalClientData = new Hashtable();
    private static Map mergedClientData = null;
    private static Map userAgentMap = new Hashtable();
    private static Map clientTypeMap = new Hashtable();
    private static Set updatedClients = new HashSet();
    private static Map partialMatchMap = new Hashtable();
    private static Map baseProfiles = new TreeMap();
    private static Set fixedProfiles = new HashSet();
    private static final String PARENT_ID = "parentId";
    private static final String CLIENT_TYPE = "clientType";
    private static final String USER_AGENT = "userAgent";
    private static boolean mergingInternal = false;
    private static AMClientCapData intCapInstance = null;
    private static AMClientCapData extCapInstance = null;
    private static boolean isInitialized;

    public void initManager() {
        Map map = userAgentMap;
        synchronized (map) {
            if (!isInitialized) {
                isInitialized = true;
                long l = System.currentTimeMillis();
                mergingInternal = true;
                this.initInternalClientTypesData();
                mergingInternal = false;
                this.initExternalClientTypesData();
                this.mergeInternalWithExternal();
                this.loadAllMaps();
                long l2 = System.currentTimeMillis();
                if (debug.messageEnabled()) {
                    debug.message("Load AllClients Time (ms) = " + (l2 - l));
                }
                intCapInstance.addListener(this);
                extCapInstance.addListener(this);
            }
        }
    }

    private static String getDefaultClientTypeFromService(SSOToken sSOToken) throws SMSException, SSOException {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(CDM_SERVICE_NAME, internalToken);
        ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
        Map map = serviceSchema.getAttributeDefaults();
        String string = (String)((Set)map.get(CDM_DEFAULT_CLIENT_TYPES_ATTR)).toArray()[0];
        return string;
    }

    private static SSOToken getInternalToken() throws SSOException {
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        String string = (String)AccessController.doPrivileged(new AdminDNAction());
        String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
        SSOToken sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        return sSOToken;
    }

    private void initInternalClientTypesData() {
        Object object;
        Map map;
        String string;
        debug.message("-------\ninitInternalClientTypes(): ");
        try {
            intCapInstance = AMClientCapData.getInternalInstance();
        }
        catch (AMClientCapException aMClientCapException) {
            debug.error("Unable to get an instance Of InternalData");
            return;
        }
        Set set = intCapInstance.getClients();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            map = intCapInstance.getProperties(string);
            if (map == null) {
                debug.error("ClientData null in InternalDB: " + string);
                continue;
            }
            internalClientData.put(string, map);
            object = (Set)map.get(PARENT_ID);
            if (object == null || !object.contains(string)) continue;
            TreeMap treeMap = new TreeMap();
            TreeMap treeMap2 = new TreeMap();
            treeMap.put(string, treeMap2);
            baseProfiles.put(string, treeMap);
            if (!debug.messageEnabled()) continue;
            debug.message("BaseProfile: " + string);
        }
        iterator = internalClientData.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            map = (Map)internalClientData.get(string);
            object = this.setParentData(map);
            internalClientData.put(string, object);
        }
    }

    private String getClientType(Map map) {
        Set set = (Set)map.get(CLIENT_TYPE);
        String string = this.getFirstString(set);
        return string;
    }

    protected Map setParentData(Map map) {
        if (map == null) {
            return map;
        }
        Set set = (Set)map.get(PARENT_ID);
        String string = this.getFirstString(set);
        String string2 = this.getClientType(map);
        if (baseProfiles.containsKey(string2) || fixedProfiles.contains(string2) || string2.equalsIgnoreCase(string)) {
            if (debug.messageEnabled()) {
                debug.message("Already merged/baseProfile : " + string2);
            }
            return map;
        }
        if (debug.messageEnabled()) {
            debug.message("Merging Child = " + string2 + " & Parent: " + set);
        }
        Map map2 = null;
        if (string == null || (map2 = (Map)internalClientData.get(string)) == null) {
            debug.error("ParentMap for clientType = " + string2 + ", parentId = " + string + " was null");
            return map;
        }
        if (!fixedProfiles.contains(string)) {
            map2 = this.setParentData(map2);
            internalClientData.put(string, map2);
        }
        if (debug.messageEnabled()) {
            debug.message("Merging client data = " + string2 + " & Parent: " + string);
        }
        map = this.mergeMap(map2, map);
        if (baseProfiles.containsKey(string)) {
            Map map3;
            Set set2 = null;
            if (mergingInternal && (set2 = (Set)map.get(USER_AGENT)) == null && (map3 = (Map)baseProfiles.get(string)).get(string2) == null) {
                map3.put(string2, new TreeMap());
                if (debug.messageEnabled()) {
                    debug.message("Creating Style: " + string2 + " : Parent : " + string);
                }
            }
        } else {
            OrderedSet orderedSet = new OrderedSet();
            orderedSet.add((Object)string);
            Set set3 = (Set)map2.get(PARENT_ID);
            orderedSet.addAll(set3);
            map.put(PARENT_ID, orderedSet);
        }
        fixedProfiles.add(string2);
        return map;
    }

    private void initExternalClientTypesData() {
        debug.message("-------\ninitExternalClientTypes(): ");
        try {
            extCapInstance = AMClientCapData.getExternalInstance();
        }
        catch (AMClientCapException aMClientCapException) {
            debug.error("Unable to get an instance Of ExternalData");
            return;
        }
        Set set = extCapInstance.getClients();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map = extCapInstance.getProperties(string);
            if (map != null) {
                Map map2 = this.mergeWithInternal(string, map);
                map = map2 != null ? map2 : this.setParentData(map);
                externalClientData.put(string, map);
                continue;
            }
            debug.error("clientData for " + string + " was null in ExternalDB");
        }
    }

    private Map mergeWithParent(Map map) {
        Set set = (Set)map.get(PARENT_ID);
        String string = this.getFirstString(set);
        Map map2 = (Map)mergedClientData.get(string);
        Map map3 = this.mergeMap(map2, map);
        OrderedSet orderedSet = new OrderedSet();
        orderedSet.add((Object)string);
        Set set2 = (Set)map2.get(PARENT_ID);
        orderedSet.addAll(set2);
        map3.put(PARENT_ID, orderedSet);
        return map3;
    }

    private Map mergeWithInternal(String string, Map map) {
        Map map2 = null;
        Map map3 = (Map)internalClientData.get(string);
        if (map3 != null) {
            Set set = (Set)map3.get(PARENT_ID);
            map2 = this.mergeMap(map3, map);
            map2.put(PARENT_ID, set);
        }
        return map2;
    }

    private Map mergeMap(Map map, Map map2) {
        Map map3 = null;
        if (map != null) {
            map3 = new HashMap(map);
        }
        if (map2 != null) {
            if (map3 != null) {
                map3.putAll(map2);
            } else {
                map3 = map2;
            }
        }
        return map3;
    }

    private void mergeInternalWithExternal() {
        debug.message("-------\nmergeWithInternalWithExternal(): ");
        mergedClientData = this.mergeMap(internalClientData, externalClientData);
    }

    protected void loadAllMaps() {
        debug.message("-------\nloadAllMaps(): ");
        Set set = mergedClientData.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map = (Map)mergedClientData.get(string);
            this.addToClientMap(string, map);
        }
    }

    protected Client addToClientMap(String string, Map map) {
        return this.addToClientMap(string, map, true);
    }

    protected Client addToClientMap(String string, Map map, boolean bl) {
        Client client = new Client(string, map);
        String string2 = client.getProperty(USER_AGENT);
        if (string2 != null) {
            userAgentMap.put(string2, client);
        }
        clientTypeMap.put(string, client);
        if (bl) {
            this.storeInProfilesMap(client);
        }
        return client;
    }

    protected void removeFromClientMap(String string, Client client) {
        clientTypeMap.remove(string);
        String string2 = null;
        if (client != null && (string2 = client.getProperty(USER_AGENT)) != null) {
            userAgentMap.remove(string2);
        }
        this.removeFromProfilesMap(string, client);
    }

    protected void storeInProfilesMap(Client client) {
        Map map;
        Set set = client.getProperties(PARENT_ID);
        String string = client.getClientType();
        if (debug.messageEnabled()) {
            debug.message("Adding To StyleMap, ct = " + string);
        }
        if ((map = this.getStylesProfileMap(string, set)) != null) {
            map.put(string, client);
        }
    }

    protected void removeFromProfilesMap(String string, Client client) {
        if (client == null) {
            return;
        }
        Set set = client.getProperties(PARENT_ID);
        Map map = this.getStylesProfileMap(string, set);
        if (map != null) {
            map.remove(string);
        }
    }

    protected Map getStylesProfileMap(String string, Set set) {
        String string2 = null;
        String string3 = null;
        if (string == null || set == null) {
            return null;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string3 = string2;
            string2 = (String)iterator.next();
        }
        if (string3 == null) {
            string3 = string2;
        }
        if (debug.messageEnabled()) {
            debug.message(" ---> Style = " + string3 + ": Base = " + string2);
        }
        Map map = null;
        Map map2 = (Map)baseProfiles.get(string2);
        if (map2 != null) {
            if (map2.containsKey(string)) {
                map2 = null;
            } else {
                map = (Map)map2.get(string3);
                if (map != null) {
                    map2 = map;
                }
            }
        }
        return map2;
    }

    private String getFirstString(Set set) {
        String string = null;
        if (set != null) {
            string = (String)set.iterator().next();
        }
        return string;
    }

    protected Client addToIndexes(String string, Map map) {
        return this.addToIndexes(string, map, true);
    }

    protected Client addToIndexes(String string, Map map, boolean bl) {
        mergedClientData.put(string, map);
        Client client = this.addToClientMap(string, map, bl);
        String string2 = client.getProperty(USER_AGENT);
        if (string2 != null) {
            partialMatchMap.remove(string2);
            if (partialMatchMap.containsValue(string)) {
                Iterator iterator = partialMatchMap.values().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (string3 == null || !string3.equals(string)) continue;
                    iterator.remove();
                }
            }
        }
        return client;
    }

    public Client getFromUserAgentMap(String string) {
        Client client = string != null ? (Client)userAgentMap.get(string) : null;
        return client;
    }

    public Set userAgentSet() {
        Set set = userAgentMap.keySet();
        return set;
    }

    public String getPartiallyMatchedClient(String string) {
        String string2 = (String)partialMatchMap.get(string);
        return string2;
    }

    public void addToPartialMatchMap(String string, String string2) {
        partialMatchMap.put(string, string2);
    }

    public Client addClient(SSOToken sSOToken, String string, Map map, boolean bl) throws AMClientCapException {
        Client client = null;
        if (debug.messageEnabled()) {
            debug.message("Adding new Client: " + map);
        }
        Set set = updatedClients;
        synchronized (set) {
            if (bl) {
                intCapInstance.addClient(sSOToken, map);
                map = this.reMergeWithParent(string, map);
                internalClientData.put(string, map);
            } else {
                map = this.mergeWithParent(map);
            }
            client = this.addToIndexes(string, map, bl);
            if (bl) {
                updatedClients.add(string);
            }
        }
        return client;
    }

    public boolean canCreateClients() {
        return intCapInstance.canCreateInternalClients();
    }

    public Map getAllClientInstances() {
        return clientTypeMap;
    }

    public Set getAllClientTypes() {
        return clientTypeMap.keySet();
    }

    public Client getClientInstance(String string) {
        if (string.equals(DEFAULT)) {
            string = defaultClientType;
        }
        Client client = (Client)clientTypeMap.get(string);
        return client;
    }

    public Client getClientInstance(String string, SSOToken sSOToken) {
        return this.getClientInstance(string);
    }

    public Map getClientTypeData(String string) {
        if (string.equals(DEFAULT)) {
            string = defaultClientType;
        }
        Map map = (Map)mergedClientData.get(string);
        return map;
    }

    public String getDefaultClientType() {
        return defaultClientType;
    }

    public void updateClientData() throws ClientException {
    }

    public void store(SSOToken sSOToken) throws SMSException, SSOException {
    }

    public void setDirty(String string, Map map) {
    }

    public void clientChanged(String string, int n, int n2) {
        if (debug.messageEnabled()) {
            debug.message("clientChanged() NOTIFICATION: clientType = " + string + " :DB = " + n + " : Op = " + n2);
        }
        if (string == null || string.equals("")) {
            return;
        }
        Set set = updatedClients;
        synchronized (set) {
            if (n2 == 2) {
                string = this.getCaseExactName(string);
            }
            if (updatedClients.contains(string)) {
                updatedClients.remove(string);
                return;
            }
        }
        if (n2 == 1 || n2 == 4) {
            this.handleClientChanged(string, n);
        } else if (n2 == 2) {
            this.handleRemoveClient(string, n);
        } else {
            debug.error("clientChanged(): unknown OpType");
        }
    }

    protected String getCaseExactName(String string) {
        String string2;
        int n = 0;
        if (string == null || (n = string.length()) <= 0) {
            return string;
        }
        Iterator<Object> iterator = updatedClients.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (!string2.regionMatches(true, 0, string, 0, n)) continue;
            return string2;
        }
        string2 = null;
        iterator = clientTypeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            int n2 = string3.length();
            if (n2 != n || !string3.regionMatches(true, 0, string, 0, n)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    protected Map reMergeWithParent(String string, Map map) {
        fixedProfiles.remove(string);
        Map map2 = this.setParentData(map);
        return map2;
    }

    protected void handleRemoveClient(String string, int n) {
        if (string == null) {
            return;
        }
        Map map = null;
        Client client = (Client)clientTypeMap.get(string);
        if (n == 1) {
            internalClientData.remove(string);
            map = extCapInstance.getProperties(string);
            if (map != null) {
                map = this.reMergeWithParent(string, map);
                externalClientData.put(string, map);
            }
        } else if (n == 2) {
            externalClientData.remove(string);
            map = (Map)internalClientData.get(string);
        } else {
            debug.error("handleClientChanged(): unknown dbType");
        }
        if (map != null) {
            this.addToIndexes(string, map);
        } else {
            this.removeFromClientMap(string, client);
        }
    }

    protected void handleClientChanged(String string, int n) {
        Map map = null;
        if (n == 1) {
            map = intCapInstance.getProperties(string);
            if (map != null) {
                map = this.reMergeWithParent(string, map);
                internalClientData.put(string, map);
            }
        } else if (n == 2) {
            map = extCapInstance.getProperties(string);
            Map map2 = this.mergeWithInternal(string, map);
            map = map2 != null ? map2 : this.reMergeWithParent(string, map);
            externalClientData.put(string, map);
        } else {
            debug.error("handleClientChanged(): unknown dbType");
        }
        this.addToIndexes(string, map);
    }

    public Set getBaseProfileNames() {
        return baseProfiles.keySet();
    }

    public Set getStyles(String string) {
        Set set = null;
        Map map = (Map)baseProfiles.get(string);
        if (map != null) {
            set = map.keySet();
        }
        return set;
    }

    public Map getClients(String string, String string2) {
        Map map = null;
        Map map2 = (Map)baseProfiles.get(string);
        if (map2 != null) {
            map = (Map)map2.get(string2);
        }
        return map;
    }

    protected Client addToUpdateList(Map map, boolean bl) {
        Client client = null;
        if (map != null) {
            String string = this.getClientType(map);
            client = this.addToUpdateList(string, map, bl);
        }
        return client;
    }

    protected Client addToUpdateList(String string, Map map, boolean bl) {
        Client client = null;
        if (string != null) {
            updatedClients.add(string);
            if (bl) {
                map = this.reMergeWithParent(string, map);
            }
            externalClientData.put(string, map);
            client = this.addToIndexes(string, map);
        }
        return client;
    }

    public int addClientExternal(SSOToken sSOToken, Map map) throws AMClientCapException {
        Set set = updatedClients;
        synchronized (set) {
            extCapInstance.addClient(sSOToken, map);
            this.addToUpdateList(map, true);
        }
        return 0;
    }

    public int modifyClientExternal(SSOToken sSOToken, Map map) throws AMClientCapException {
        Set set = updatedClients;
        synchronized (set) {
            extCapInstance.modifyClient(sSOToken, map);
            String string = this.getClientType(map);
            Map map2 = (Map)mergedClientData.get(string);
            map = this.mergeMap(map2, map);
            this.addToUpdateList(string, map, false);
        }
        return 0;
    }

    public int removeClientExternal(SSOToken sSOToken, String string) throws AMClientCapException {
        Set set = updatedClients;
        synchronized (set) {
            extCapInstance.removeClient(sSOToken, string);
            Client client = (Client)clientTypeMap.get(string);
            externalClientData.remove(string);
            Map map = (Map)internalClientData.get(string);
            if (map != null) {
                this.addToIndexes(string, map);
            } else {
                this.removeFromClientMap(string, client);
            }
            updatedClients.add(string);
        }
        return 0;
    }

    static {
        try {
            internalToken = DefaultClientTypesManager.getInternalToken();
            defaultClientType = DefaultClientTypesManager.getDefaultClientTypeFromService(internalToken);
        }
        catch (Throwable throwable) {
            debug.error("DefaultClientTypesManager: init() failed: ", throwable);
        }
        isInitialized = false;
    }
}

