/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdc;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthenticationStatement;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContextStmt;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.AssertionSSOTokenListener;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CDCServlet
extends HttpServlet {
    private static final char QUESTION_MARK = '?';
    private static final char AMPERSAND = '&';
    private static final char EQUAL_TO = '=';
    private static final String GOTO_PARAMETER = "goto";
    private static final String TARGET_PARAMETER = "TARGET";
    private static final String DEBUG_FILE_NAME = "amCDC";
    private static final String CDCURI = "/cdcservlet";
    private static final String AUTHURI = "/UI/Login";
    private static final String ssoCookieName = SystemProperties.get((String)"com.iplanet.am.cookie.name");
    private static final ArrayList adviceParams = new ArrayList();
    private String cdcURL = null;
    private String authURL = null;
    private static Debug debug;
    private char authDelimiter;
    private boolean signed = false;
    private String responseID;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        debug = Debug.getInstance((String)DEBUG_FILE_NAME);
        if (debug.messageEnabled()) {
            debug.message("CDCServlet Initializing...");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        SSOToken sSOToken;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FSServiceUtils.getBaseURL(httpServletRequest)).append(CDCURI);
        this.cdcURL = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(FSServiceUtils.getBaseURL(httpServletRequest)).append(AUTHURI);
        this.authURL = stringBuffer2.toString();
        this.setAuthDelimiter();
        if (!this.canProceed()) {
            this.showError(httpServletResponse);
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.doGetPost: Query String received :" + httpServletRequest.getQueryString());
        }
        String string = null;
        String string2 = httpServletRequest.getParameter(GOTO_PARAMETER);
        String string3 = httpServletRequest.getParameter(TARGET_PARAMETER);
        if (string2 == null || string2.length() < 1) {
            if (string3 == null || string3.length() < 1) {
                debug.error("No GOTO or TARGET URL present in the Query !!");
                this.showError(httpServletResponse);
                return;
            }
            string2 = string3;
            if (debug.messageEnabled()) {
                debug.message("CDCServlet.doGetPost: targetURL = " + string2);
            }
        } else if (debug.messageEnabled()) {
            debug.message("CDCServlet.doGetPost: gotoURL = " + string2);
        }
        if ((sSOToken = this.getSSOToken(httpServletRequest, httpServletResponse)) == null) {
            return;
        }
        String string4 = this.checkForPolicyAdvice(httpServletRequest, httpServletResponse);
        if (string4 != null && string4.length() > 0) {
            this.redirectForAuthentication(httpServletRequest, httpServletResponse);
            return;
        }
        SSOTokenID sSOTokenID = sSOToken.getTokenID();
        string = sSOTokenID.toString();
        if (debug.messageEnabled()) {
            debug.message("Valid SSOToken found with token value: " + string);
        }
        if (string2.indexOf(63) < 0) {
            int n = 63;
        } else {
            int n = 38;
        }
        try {
            String string5 = httpServletRequest.getParameter("ProviderID");
            String string6 = this.cdcURL;
            if (debug.messageEnabled()) {
                debug.message("Provider Id = " + string6);
            }
            String string7 = httpServletRequest.getParameter("RequestID");
            FSAssertion fSAssertion = this.createAssertion(string5, string6, sSOToken, string7);
            String string8 = httpServletRequest.getParameter("RelayState");
            StatusCode statusCode = new StatusCode("samlp:Success");
            Status status = new Status(statusCode);
            FSAuthnResponse fSAuthnResponse = this.createAuthnResponse(string6, this.responseID, string7, status, fSAssertion, string8);
            this.sendAuthnResponse(httpServletRequest, httpServletResponse, fSAuthnResponse, string2);
        }
        catch (SAMLException sAMLException) {
            debug.error("CDCServlet.doGetPost:SAMLException occured: " + sAMLException.getMessage());
            this.showError(httpServletResponse);
        }
        catch (FSMsgException fSMsgException) {
            debug.error("CDCServlet.doGetPost:FSMsgException occured: " + fSMsgException.getMessage());
            this.showError(httpServletResponse);
        }
        catch (FSException fSException) {
            debug.error("CDCServlet.doGetPost:FSException occured: " + fSException.getMessage());
            this.showError(httpServletResponse);
        }
    }

    private void setAuthDelimiter() {
        if (this.authURL == null || this.authURL.trim().length() < 1) {
            debug.error("Auth login URL not found :((");
            return;
        }
        this.authDelimiter = this.authURL.indexOf(63) < 0 ? (char)63 : (char)38;
    }

    private boolean canProceed() {
        if (this.authURL == null || this.authURL.trim().length() < 1) {
            return false;
        }
        return ssoCookieName != null && ssoCookieName.trim().length() >= 1;
    }

    private String getParameterString(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = new StringBuffer(128);
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (string.equals(GOTO_PARAMETER) || adviceParams.contains(string)) continue;
            String[] stringArray = httpServletRequest.getParameterValues(string);
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                stringBuffer.append('&').append(string).append('=').append(URLEncoder.encode(stringArray[n]));
                ++n;
            }
        }
        return stringBuffer.toString().substring(1);
    }

    private String checkForPolicyAdvice(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (!adviceParams.contains(string)) continue;
            String[] stringArray = httpServletRequest.getParameterValues(string);
            if (stringBuffer.length() > 0) {
                stringBuffer.append('&');
            }
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                stringBuffer.append(string).append('=').append(stringArray[n]);
                ++n;
            }
        }
        if (stringBuffer.length() < 1) {
            return null;
        }
        return stringBuffer.toString();
    }

    private void redirectForAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        String string = this.getParameterString(httpServletRequest);
        stringBuffer.append(this.authURL);
        stringBuffer.append(this.authDelimiter).append(GOTO_PARAMETER).append('=');
        stringBuffer2.append(this.cdcURL).append('?');
        stringBuffer2.append(TARGET_PARAMETER).append('=').append(URLEncoder.encode(httpServletRequest.getParameter(GOTO_PARAMETER))).append('&').append(string);
        stringBuffer.append(URLEncoder.encode(stringBuffer2.toString()));
        String string2 = this.checkForPolicyAdvice(httpServletRequest, httpServletResponse);
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append('&').append(this.checkForPolicyAdvice(httpServletRequest, httpServletResponse));
        }
        if (debug.messageEnabled()) {
            debug.message("Redirecting for authentication to: " + stringBuffer);
        }
        httpServletResponse.sendRedirect(stringBuffer.toString());
    }

    /*
     * Loose catch block
     */
    private void showError(HttpServletResponse httpServletResponse) {
        block8: {
            ServletOutputStream servletOutputStream = null;
            servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.println("ERROR: An application error has occured.");
            servletOutputStream.flush();
            Object var5_3 = null;
            try {
                servletOutputStream.close();
            }
            catch (IOException iOException) {}
            break block8;
            {
                catch (IOException iOException) {
                    debug.error("Could not show error message to the user " + iOException);
                    Object var5_4 = null;
                    try {
                        servletOutputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    servletOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private SSOToken getSSOToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (sSOToken == null) {
                if (debug.messageEnabled()) {
                    debug.message("SSOToken is null, redirecting forauthentication");
                }
                this.redirectForAuthentication(httpServletRequest, httpServletResponse);
                return null;
            }
            if (!sSOTokenManager.isValidToken(sSOToken)) {
                if (debug.messageEnabled()) {
                    debug.message("SSOToken is not valid, redirecting forauthentication");
                }
                this.redirectForAuthentication(httpServletRequest, httpServletResponse);
                return null;
            }
        }
        catch (SSOException sSOException) {
            if (debug.messageEnabled()) {
                debug.message("SSOException caught: " + (Object)((Object)sSOException));
            }
            this.redirectForAuthentication(httpServletRequest, httpServletResponse);
            return null;
        }
        return sSOToken;
    }

    private FSAuthnResponse createAuthnResponse(String string, String string2, String string3, Status status, FSAssertion fSAssertion, String string4) throws SAMLException, FSMsgException {
        ArrayList<FSAssertion> arrayList = new ArrayList<FSAssertion>();
        arrayList.add(fSAssertion);
        FSAuthnResponse fSAuthnResponse = new FSAuthnResponse(null, string3, status, arrayList, string4);
        fSAuthnResponse.setProviderId(string);
        return fSAuthnResponse;
    }

    private FSAssertion createAssertion(String string, String string2, SSOToken sSOToken, String string3) throws FSException, SAMLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (debug.messageEnabled()) {
            debug.message("FSAssertionManager.createFSAssertion(id): Called");
        }
        if (string == null || string2 == null || sSOToken == null || string3 == null) {
            if (debug.messageEnabled()) {
                debug.message("FSAssertionManager: null input for method createFSAssertionArtifact.");
            }
            throw new FSException(FSUtils.bundle.getString("nullInput"));
        }
        String string4 = string;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        Date date = null;
        String string8 = null;
        String string9 = null;
        NameIdentifier nameIdentifier = null;
        NameIdentifier nameIdentifier2 = null;
        try {
            object6 = URLEncoder.encode(sSOToken.getTokenID().toString());
            object5 = string2;
            nameIdentifier2 = nameIdentifier = new NameIdentifier((String)object6, (String)object5);
            object4 = sSOToken.getProperty("authInstant");
            if (object4 != null) {
                try {
                    date = FSUtils.stringToDate((String)object4);
                }
                catch (Exception exception) {
                    if (debug.messageEnabled()) {
                        debug.message("FSAssertionManager.createFSAssertion(id): AuthInstant not foundin the Token");
                    }
                }
            } else {
                date = new Date();
            }
            string5 = sSOToken.getAuthType();
            if (debug.messageEnabled()) {
                debug.message("FSAssertionManager.createFSAssertion(id):AuthInstant = " + date);
            }
            if (string6 == null && debug.messageEnabled()) {
                debug.message("FSAssertionManager.createFSAssertion(id): AuthnContextStatement for the token is null Assertion will not contain any  AuthenticationStatement");
            }
            if (debug.messageEnabled()) {
                debug.message("FSAssertionManager.createFSAssertion(id):AuthnContextStatement used for authenticating the user: " + string6);
            }
            string9 = sSOToken.getPrincipal().getName();
            if (string2 == null) {
                debug.error("FSAssertionManager.createAssertion(id): Alliance manager could not find local descriptor");
                throw new FSException("Alliance manager could not find local descriptor");
            }
            string8 = string2;
        }
        catch (Exception exception) {
            debug.error("FSAssertionManager.createAssertion(id): exception retrieving info from the SSOToken: ", (Throwable)exception);
            throw new FSException("Alliance manager could not find local descriptor");
        }
        if (debug.messageEnabled()) {
            debug.message("FSAssertionManager.createAssertion(id): Creating Authentication Assertion for user withopaqueHandle= " + nameIdentifier2.getName() + " And SecurityDomain= " + string8);
        }
        object6 = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        object5 = new IDPProvidedNameIdentifier(nameIdentifier.getNameQualifier(), nameIdentifier.getName());
        object4 = new FSSubject(nameIdentifier2, (SubjectConfirmation)object6, (IDPProvidedNameIdentifier)object5);
        SubjectLocality subjectLocality = null;
        try {
            object3 = SystemProperties.get((String)"com.iplanet.am.server.host");
            object2 = InetAddress.getByName((String)object3).getHostAddress();
            subjectLocality = new SubjectLocality((String)object2, (String)object3);
        }
        catch (UnknownHostException unknownHostException) {
            debug.error("CDCServlet:createAssertion: ", (Throwable)unknownHostException);
        }
        object3 = new AuthnContextStmt(string7, string6);
        object2 = new FSAuthenticationStatement(string5, date, (Subject)object4, subjectLocality, null, (AuthnContextStmt)object3);
        Date date2 = new Date();
        Integer n = new Integer(60);
        long l = n * 1000;
        if (l < 60000L) {
            l = 60000L;
        }
        Date date3 = new Date(date2.getTime() + l);
        ((FSAuthenticationStatement)object2).setReauthenticateOnOrAfter(date3);
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.createAssertion(id): Authentication Statement: " + ((FSAuthenticationStatement)object2).toXMLString());
        }
        Conditions conditions = new Conditions(date2, date3);
        if (string4 != null && !string4.equals("")) {
            object = new ArrayList();
            object.add(string4);
            conditions.addAudienceRestrictionCondition(new AudienceRestrictionCondition((List)object));
        }
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.createAssertion(id): Authentication Statement: " + ((FSAuthenticationStatement)object2).toXMLString());
        }
        object = new AssertionIDReference();
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(object2);
        FSAssertion fSAssertion = new FSAssertion(((AssertionIDReference)object).getAssertionIDReference(), string2, date2, conditions, hashSet, string3);
        fSAssertion.setID(((AssertionIDReference)object).getAssertionIDReference());
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.createAssertion(id): Assertion created successfully: " + fSAssertion.toXMLString());
        }
        String string10 = fSAssertion.getAssertionID();
        FSUtils.access("FSAssertionManager", FSUtils.bundle.getString("assertionCreated") + ":" + fSAssertion.toString());
        if (sSOToken != null) {
            AssertionSSOTokenListener assertionSSOTokenListener = new AssertionSSOTokenListener(string10, null);
            try {
                sSOToken.addSSOTokenListener((SSOTokenListener)assertionSSOTokenListener);
            }
            catch (SSOException sSOException) {
                debug.error("CDCServlet.createAssertion(id): Couldn't add listener to token:", (Throwable)sSOException);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.createAssertion(id): Returning Assertion: " + fSAssertion.toXMLString());
        }
        return fSAssertion;
    }

    private void sendAuthnResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnResponse fSAuthnResponse, String string) {
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.sendAuthnResponse: Called");
        }
        try {
            String string2 = fSAuthnResponse.toXMLString(true, true);
            if (debug.messageEnabled()) {
                debug.message("CDCServlet.sendAuthnResponse: Signed AuthnResponse: " + string2);
            }
            String string3 = Base64.encode((byte[])string2.getBytes());
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setHeader("Pragma", "no-cache");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<HTML>");
            printWriter.println("<BODY Onload=\"document.Response.submit()\">");
            String string4 = SystemProperties.get((String)"com.iplanet.services.cdc.WaitImage.display", (String)"false");
            string4 = string4.toLowerCase().trim();
            if (string4.equals("true")) {
                StringBuffer stringBuffer = new StringBuffer();
                String string5 = SystemProperties.get((String)"com.iplanet.services.cdc.WaitImage.name", (String)"waitImage.gif");
                String string6 = SystemProperties.get((String)"com.iplanet.services.cdc.WaitImage.width", (String)"410");
                String string7 = SystemProperties.get((String)"com.iplanet.services.cdc.WaitImage.height", (String)"120");
                stringBuffer.append(FSServiceUtils.getBaseURL(httpServletRequest)).append("/login_images/" + string5);
                printWriter.println("<p>&nbsp;<center><img border=0 src=\"" + stringBuffer.toString() + "\" width=" + string6 + " height=" + string7 + " alt=\"Please wait while we log you in...\"></center>");
                if (debug.messageEnabled()) {
                    debug.message("CDCServlet: Display waiting image " + string5 + " of size " + string6 + "x" + string7);
                }
            }
            printWriter.println("<FORM NAME=\"Response\" METHOD=\"POST\" ACTION=\"" + string + "\">");
            printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"LARES\" VALUE=\"" + string3 + "\"/>");
            printWriter.println("</FORM>");
            printWriter.println("</BODY></HTML>");
            printWriter.close();
            if (debug.messageEnabled()) {
                debug.message("CDCServlet:sendAuthnResponse: AuthnResponse sent successfully to: " + string);
            }
            return;
        }
        catch (FSMsgException fSMsgException) {
            debug.error("CDCServlet:sendAuthnResponse:" + fSMsgException.getMessage());
            return;
        }
        catch (IOException iOException) {
            debug.error("CDCServlet:sendAuthnResponse:" + iOException.getMessage());
            return;
        }
    }

    static {
        adviceParams.add("module");
        adviceParams.add("authlevel");
        adviceParams.add("role");
        adviceParams.add("service");
        adviceParams.add("user");
        adviceParams.add("org");
    }
}

