/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.DerInputStream;
import com.iplanet.security.util.DerOutputStream;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.AVA;
import com.iplanet.security.x509.CertParseError;
import com.iplanet.security.x509.LdapDNStrConverter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class RDN {
    private AVA[] assertion;

    public RDN(String string) throws IOException {
        RDN rDN = LdapDNStrConverter.getDefault().parseRDN(string);
        this.assertion = rDN.getAssertion();
    }

    public RDN(String string, byte[] byArray) throws IOException {
        RDN rDN = LdapDNStrConverter.getDefault().parseRDN(string, byArray);
        this.assertion = rDN.getAssertion();
    }

    public RDN(String string, LdapDNStrConverter ldapDNStrConverter) throws IOException {
        RDN rDN = ldapDNStrConverter.parseRDN(string);
        this.assertion = rDN.getAssertion();
    }

    public RDN(DerValue derValue) throws IOException {
        if (derValue.tag != 49) {
            throw new CertParseError("X500 RDN");
        }
        int n = 50;
        AVA[] aVAArray = new AVA[n];
        int n2 = 0;
        while (n2 < n) {
            aVAArray[n2] = new AVA(derValue.data);
            if (derValue.data.available() == 0) break;
            ++n2;
        }
        if (n2 >= n - 1) {
            this.assertion = new AVA[n2 + 1];
        } else {
            this.assertion = new AVA[n2 + 1];
            int n3 = 0;
            while (n3 < n2 + 1) {
                this.assertion[n3] = aVAArray[n3];
                ++n3;
            }
        }
    }

    public RDN(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = derInputStream.getSet(1);
        this.assertion = new AVA[derValueArray.length];
        int n = 0;
        while (n < this.assertion.length) {
            this.assertion[n] = new AVA(derValueArray[n].data);
            ++n;
        }
    }

    public RDN(AVA[] aVAArray) {
        this.assertion = (AVA[])aVAArray.clone();
    }

    public RDN(Vector vector) {
        int n = vector.size();
        this.assertion = new AVA[n];
        int n2 = 0;
        while (n2 < n) {
            this.assertion[n2] = (AVA)vector.elementAt(n2);
            ++n2;
        }
    }

    public AVA[] getAssertion() {
        return (AVA[])this.assertion.clone();
    }

    public int getAssertionLength() {
        return this.assertion.length;
    }

    public boolean equals(RDN rDN) {
        if (rDN == this) {
            return true;
        }
        if (this.assertion.length != rDN.assertion.length) {
            return false;
        }
        int n = 0;
        while (n < this.assertion.length) {
            if (!this.assertion[n].equals(rDN.assertion[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        int n = 0;
        while (n < this.assertion.length) {
            if (this.assertion[n].oid.equals(objectIdentifier)) {
                return this.assertion[n].value;
            }
            ++n;
        }
        return null;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        int n = 0;
        while (n < this.assertion.length) {
            this.assertion[n].encode(derOutputStream2);
            ++n;
        }
        derOutputStream.write((byte)49, derOutputStream2);
    }

    public Enumeration getAVAs() {
        return new AVAEnumerator();
    }

    public String toLdapDNString() throws IOException {
        return LdapDNStrConverter.getDefault().encodeRDN(this);
    }

    public String toLdapDNString(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        return ldapDNStrConverter.encodeRDN(this);
    }

    public String toString() {
        String string;
        try {
            string = this.toLdapDNString();
        }
        catch (IOException iOException) {
            return null;
        }
        return string;
    }

    private class AVAEnumerator
    implements Enumeration {
        private int index = 0;

        public boolean hasMoreElements() {
            return this.index < RDN.this.assertion.length;
        }

        public Object nextElement() {
            Object var1_1 = null;
            if (this.index >= RDN.this.assertion.length) {
                return null;
            }
            return RDN.this.assertion[this.index++];
        }
    }
}

