/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.ASN1CharStrConvMap;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.x509.AVAValueConverter;
import java.io.CharConversionException;
import java.io.IOException;
import sun.io.CharToByteConverter;

public class PrintableConverter
implements AVAValueConverter {
    public DerValue getValue(String string) throws IOException {
        return this.getValue(string, null);
    }

    public DerValue getValue(String string, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[string.length()];
        try {
            CharToByteConverter charToByteConverter = ASN1CharStrConvMap.getDefault().getCBC((byte)19);
            if (charToByteConverter == null) {
                throw new IOException("No CharToByteConverter for printable");
            }
            charToByteConverter.convert(string.toCharArray(), 0, string.length(), byArray2, 0, byArray2.length);
        }
        catch (CharConversionException charConversionException) {
            throw new IllegalArgumentException("Invalid Printable String AVA Value");
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Cannot instantiate CharToByteConverter");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Cannot load CharToByteConverter");
        }
        return new DerValue(19, byArray2);
    }

    public DerValue getValue(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 19) {
            throw new IOException("Invalid Printable String AVA Value");
        }
        return derValue;
    }

    public String getAsString(DerValue derValue) throws IOException {
        return derValue.getPrintableString();
    }
}

