/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.util;

import com.iplanet.security.util.ASN1CharStrConvMap;
import com.iplanet.security.util.BigInt;
import com.iplanet.security.util.BitArray;
import com.iplanet.security.util.DerInputBuffer;
import com.iplanet.security.util.DerInputStream;
import com.iplanet.security.util.DerOutputStream;
import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.GenericValueConverter;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.io.ByteToCharConverter;

public class DerValue {
    public static final byte TAG_UNIVERSAL = 0;
    public static final byte TAG_APPLICATION = 64;
    public static final byte TAG_CONTEXT = -128;
    public static final byte TAG_PRIVATE = -64;
    public byte tag;
    protected DerInputBuffer buffer;
    public DerInputStream data;
    private int length;
    public static final byte tag_Boolean = 1;
    public static final byte tag_Integer = 2;
    public static final byte tag_BitString = 3;
    public static final byte tag_OctetString = 4;
    public static final byte tag_Null = 5;
    public static final byte tag_ObjectId = 6;
    public static final byte tag_Enumerated = 10;
    public static final byte tag_PrintableString = 19;
    public static final byte tag_VisibleString = 26;
    public static final byte tag_T61String = 20;
    public static final byte tag_IA5String = 22;
    public static final byte tag_UtcTime = 23;
    public static final byte tag_GeneralizedTime = 24;
    public static final byte tag_BMPString = 30;
    public static final byte tag_UniversalString = 28;
    public static final byte tag_UTF8String = 12;
    public static final byte tag_Sequence = 48;
    public static final byte tag_SequenceOf = 48;
    public static final byte tag_Set = 49;
    public static final byte tag_SetOf = 49;

    boolean isUniversal() {
        return (this.tag & 0xC0) == 0;
    }

    boolean isApplication() {
        return (this.tag & 0xC0) == 64;
    }

    public boolean isContextSpecific() {
        return (this.tag & 0xC0) == 128;
    }

    public boolean isContextSpecific(byte by) {
        if (!this.isContextSpecific()) {
            return false;
        }
        return (this.tag & 0x1F) == by;
    }

    boolean isPrivate() {
        return (this.tag & 0xC0) == 192;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    public DerValue(String string) throws IOException {
        GenericValueConverter genericValueConverter = new GenericValueConverter();
        DerValue derValue = genericValueConverter.getValue(string);
        this.tag = derValue.tag;
        this.buffer = derValue.buffer;
        this.length = derValue.length;
        this.data = derValue.data;
        this.data.mark(Integer.MAX_VALUE);
    }

    public DerValue(byte by, byte[] byArray) {
        this.tag = by;
        this.buffer = new DerInputBuffer((byte[])byArray.clone());
        this.length = byArray.length;
        this.data = new DerInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    DerValue(DerInputBuffer derInputBuffer) throws IOException {
        this.tag = (byte)derInputBuffer.read();
        this.length = DerInputStream.getLength(derInputBuffer);
        this.buffer = derInputBuffer.dup();
        this.buffer.truncate(this.length);
        this.data = new DerInputStream(this.buffer);
        derInputBuffer.skip(this.length);
    }

    public DerValue(byte[] byArray) throws IOException {
        this.init(true, new ByteArrayInputStream(byArray));
    }

    public DerValue(byte[] byArray, int n, int n2) throws IOException {
        this.init(true, new ByteArrayInputStream(byArray, n, n2));
    }

    public DerValue(InputStream inputStream) throws IOException {
        this.init(false, inputStream);
    }

    private void init(boolean bl, InputStream inputStream) throws IOException {
        this.tag = (byte)inputStream.read();
        this.length = DerInputStream.getLength(inputStream);
        if (bl && inputStream.available() != this.length) {
            throw new IOException("extra DER value data (constructor)");
        }
        byte[] byArray = new byte[this.length];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readFully(byArray);
        this.buffer = new DerInputBuffer(byArray);
        this.data = new DerInputStream(this.buffer);
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.write(this.tag);
        derOutputStream.putLength(this.length);
        this.buffer.dump(derOutputStream, this.length);
    }

    public boolean getBoolean() throws IOException {
        if (this.tag != 1) {
            throw new IOException("DerValue.getBoolean, not a BOOLEAN " + this.tag);
        }
        if (this.length != 1) {
            throw new IOException("DerValue.getBoolean, invalid length " + this.length);
        }
        return this.buffer.read() != 0;
    }

    public ObjectIdentifier getOID() throws IOException {
        if (this.tag != 6) {
            throw new IOException("DerValue.getOID, not an OID " + this.tag);
        }
        return new ObjectIdentifier(this.buffer);
    }

    public byte[] getOctetString() throws IOException {
        if (this.tag != 4) {
            throw new IOException("DerValue.getOctetString, not an Octet String: " + this.tag);
        }
        byte[] byArray = new byte[this.length];
        if (this.buffer.read(byArray) != this.length) {
            throw new IOException("short read on DerValue buffer");
        }
        return byArray;
    }

    public int getEnumerated() throws IOException {
        if (this.tag != 10) {
            throw new IOException("DerValue.getEnumerated, not an ENUMERATED " + this.tag);
        }
        if (this.length == 0) {
            return 0;
        }
        if (this.length > 4 || this.length < 1) {
            throw new IOException("DerValue.getEnumerated, invalid length " + this.length + "(must be between 1 and 4)");
        }
        byte by = 0;
        int n = this.buffer.read();
        if (n == -1) {
            throw new IOException("short read on DerValue buffer");
        }
        by = (byte)n;
        int n2 = this.length - 1;
        while (n2 > 0) {
            n = this.buffer.read();
            if (n == -1) {
                throw new IOException("short read on DerValue buffer");
            }
            by = (byte)(256 * by + n);
            --n2;
        }
        return by;
    }

    public BigInt getInteger() throws IOException {
        if (this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getUnsigned(this.data.available());
    }

    public BigInt getInteger(boolean bl) throws IOException {
        if (!bl && this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getUnsigned(this.data.available());
    }

    public byte[] getBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getBitString();
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getUnalignedBitString();
    }

    public String getAsString() throws IOException {
        GenericValueConverter genericValueConverter = new GenericValueConverter();
        return genericValueConverter.getAsString(this);
    }

    public byte[] getBitString(boolean bl) throws IOException {
        if (!bl && this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getBitString();
    }

    public BitArray getUnalignedBitString(boolean bl) throws IOException {
        if (!bl && this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getUnalignedBitString();
    }

    public String getPrintableString() throws IOException {
        if (this.tag != 19) {
            throw new IOException("DerValue.getPrintableString, not a string " + this.tag);
        }
        return this.getASN1CharString();
    }

    private String simpleGetString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(this.length);
        try {
            int n = this.length;
            this.data.reset();
            while (n-- > 0) {
                stringBuffer.append((char)this.data.getByte());
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return new String(stringBuffer);
    }

    public String getASN1CharString() throws IOException {
        int n;
        char[] cArray;
        try {
            ByteToCharConverter byteToCharConverter = ASN1CharStrConvMap.getDefault().getBCC(this.tag);
            if (byteToCharConverter == null) {
                return null;
            }
            byte[] byArray = new byte[this.length];
            cArray = new char[byteToCharConverter.getMaxCharsPerByte() * this.length];
            this.data.reset();
            this.data.getBytes(byArray);
            n = byteToCharConverter.convert(byArray, 0, byArray.length, cArray, 0, cArray.length);
        }
        catch (CharConversionException charConversionException) {
            throw new IOException("Misformed DER value");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Illegal Access loading ByteToCharConverter");
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Cannot instantiate ByteToCharConverter");
        }
        return new String(cArray, 0, n);
    }

    public String getT61String() throws IOException {
        if (this.tag != 20) {
            throw new IOException("DerValue.getT61String, not T61 " + this.tag);
        }
        return this.getASN1CharString();
    }

    public String getIA5String() throws IOException {
        if (this.tag != 22) {
            throw new IOException("DerValue.getIA5String, not IA5 " + this.tag);
        }
        return this.getASN1CharString();
    }

    public String getBMPString() throws IOException {
        if (this.tag != 30) {
            throw new IOException("DerValue.getBMPString, not BMP " + this.tag);
        }
        return this.getASN1CharString();
    }

    public String getUniversalString() throws IOException {
        if (this.tag != 28) {
            throw new IOException("DerValue.getUniversalString, not UniversalString " + this.tag);
        }
        return this.getASN1CharString();
    }

    public String getUTF8String() throws IOException {
        if (this.tag != 12) {
            throw new IOException("DerValue.getUTF8String, not UTF8String " + this.tag);
        }
        return this.getASN1CharString();
    }

    public boolean equals(Object object) {
        if (object instanceof DerValue) {
            return this.equals((DerValue)object);
        }
        return false;
    }

    public boolean equals(DerValue derValue) {
        this.data.reset();
        derValue.data.reset();
        if (this == derValue) {
            return true;
        }
        if (this.tag != derValue.tag) {
            return false;
        }
        return this.buffer.equals(derValue.buffer);
    }

    public String toString() {
        try {
            String string = this.getAsString();
            if (string != null) {
                return string;
            }
            if (this.tag == 5) {
                return "[DerValue, null]";
            }
            if (this.tag == 6) {
                return "OID." + this.getOID();
            }
            return "[DerValue, tag = " + this.tag + ", length = " + this.length + "]";
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("misformatted DER value");
        }
    }

    public byte[] toByteArray() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encode(derOutputStream);
        this.data.reset();
        return derOutputStream.toByteArray();
    }

    public DerInputStream toDerInputStream() throws IOException {
        if (this.tag == 48 || this.tag == 49) {
            return new DerInputStream(this.buffer);
        }
        throw new IOException("toDerInputStream rejects tag type " + this.tag);
    }

    public int length() {
        return this.length;
    }

    public static byte createTag(byte by, boolean bl, byte by2) {
        byte by3 = (byte)(by | by2);
        if (bl) {
            by3 = (byte)(by3 | 0x20);
        }
        return by3;
    }

    public void resetTag(byte by) {
        this.tag = by;
    }
}

