/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.profile.agent;

import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.dpro.profile.agent.GetProfileResponse;
import com.iplanet.dpro.profile.agent.ProfileDTDToken;
import com.iplanet.dpro.profile.agent.ProfileRequest;
import com.iplanet.dpro.profile.agent.ProfileResponse;
import com.iplanet.dpro.profile.agent.ProfileService;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetProfileRequest
extends ProfileRequest {
    private boolean schemaFlag = false;
    private boolean templateFlag = false;
    private String serviceName = null;

    public GetProfileRequest(String string, Set set) {
        super(0, string, set);
    }

    public GetProfileRequest() {
        super(0);
    }

    public String toXMLString() {
        return null;
    }

    public ProfileResponse process() {
        String string = this.getProfileName();
        int n = this.getRequestType();
        String string2 = this.getRequestID();
        int n2 = this.getProfileType();
        String string3 = this.getSessionID();
        GetProfileResponse getProfileResponse = new GetProfileResponse(string2, n, null);
        getProfileResponse.setProfileName(string);
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(string3);
            Set set = this.getAttributes();
            AMObject aMObject = null;
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            if (ProfileService.debug.messageEnabled()) {
                ProfileService.debug.message("GPR.process : DN=" + string + " type = " + n2);
            }
            switch (n2) {
                case 1: {
                    aMObject = aMStoreConnection.getUser(string);
                    break;
                }
                case 6: {
                    aMObject = aMStoreConnection.getRole(string);
                    break;
                }
                case 9: {
                    aMObject = aMStoreConnection.getStaticGroup(string);
                    break;
                }
                case 11: {
                    aMObject = aMStoreConnection.getDynamicGroup(string);
                    break;
                }
                case 2: {
                    aMObject = aMStoreConnection.getOrganization(string);
                    break;
                }
                case 5: {
                    aMObject = aMStoreConnection.getPeopleContainer(string);
                    break;
                }
                default: {
                    getProfileResponse.setException(AMSDKBundle.getString("117"));
                    return getProfileResponse;
                }
            }
            Map map = null;
            if (n2 == 1 && set.contains("iplanet-am-web-agent-access-allow-list")) {
                set.add("iplanet-am-domain-url-access-allow");
                map = aMObject.getAttributes(set);
                map = GetProfileRequest.filterAgentAllowAttributes(map);
                map.remove("iplanet-am-domain-url-access-allow");
            } else {
                map = aMObject.getAttributes(set);
            }
            getProfileResponse.setAttributes(map);
            return getProfileResponse;
        }
        catch (Exception exception) {
            getProfileResponse.setException(exception.getMessage());
            return getProfileResponse;
        }
    }

    private static Map filterAgentAllowAttributes(Map map) {
        Set set = (Set)map.get("iplanet-am-domain-url-access-allow");
        Set set2 = (Set)map.get("iplanet-am-web-agent-access-allow-list");
        if (!set.isEmpty()) {
            if (set.contains("*")) {
                return map;
            }
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                boolean bl = string.startsWith("*");
                boolean bl2 = string.endsWith("*");
                boolean bl3 = false;
                if (bl && bl2) {
                    bl3 = true;
                    bl2 = false;
                    bl = false;
                }
                int n = string.length();
                String string2 = null;
                if (bl3) {
                    string2 = string.substring(1, n - 1);
                } else if (bl) {
                    string2 = string.substring(1);
                } else if (bl2) {
                    string2 = string.substring(0, n - 1);
                }
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    if (!(bl3 && string3.lastIndexOf(string2) != -1 || bl && string3.endsWith(string2)) && (!bl2 || !string3.startsWith(string2))) continue;
                    hashSet.add(string3);
                }
            }
            map.put("iplanet-am-web-agent-access-allow-list", hashSet);
        }
        return map;
    }

    public void parseXMLDocument(Document document) {
        NodeList nodeList;
        Element element = document.getDocumentElement();
        String string = element.getAttribute("ver");
        if (string != null) {
            this.setRequestVersion(string);
        }
        if ((string = element.getAttribute("reqid")) != null) {
            this.setRequestID(string);
        }
        if ((nodeList = element.getElementsByTagName("GetProfile")) == null || nodeList.getLength() == 0) {
            return;
        }
        Element element2 = (Element)nodeList.item(0);
        if (element2 == null) {
            return;
        }
        string = element2.getAttribute("profileName");
        if (string != null) {
            this.setProfileName(string);
        }
        if ((string = element2.getAttribute("profileType")) != null) {
            this.setProfileType(this.parseProfileType(string));
        }
        this.setAttributes(XMLUtils.parseAttributesTag((Node)element2.getFirstChild()));
    }

    private int parseProfileType(String string) {
        int n = ProfileDTDToken.findToken(string);
        if (n != -1) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

