/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class CacheBlock {
    private AMHashMap cacheEntries;
    private String entryDN;
    private int objectType = -9999;
    private AMHashMap stringAttributes;
    private AMHashMap byteAttributes;
    private long lastModifiedTime = 0L;
    private boolean isExpired = false;
    private String organizationDN = null;
    private boolean isValidEntry = true;
    private boolean timeStampUpdateRequired = true;
    protected static final String ENTRY_EXPIRATION_ENABLED_KEY = "com.iplanet.am.sdk.cache.entry.expire.enabled";
    protected static final String ENTRY_USER_EXPIRE_TIME_KEY = "com.iplanet.am.sdk.cache.entry.user.expire.time";
    protected static final String ENTRY_DEFAULT_EXPIRE_TIME_KEY = "com.iplanet.am.sdk.cache.entry.default.expire.time";
    protected static boolean ENTRY_EXPIRATION_ENABLED_FLAG = false;
    protected static long ENTRY_USER_EXPIRE_TIME;
    protected static long ENTRY_DEFAULT_EXPIRE_TIME;
    private static Debug debug;

    private static void initializeExpirationParms() {
        CacheBlock.setEntryExpirationEnabledFlag();
        if (CacheBlock.isEntryExpirationEnabled()) {
            CacheBlock.setUserEntryExpirationTime();
            CacheBlock.setDefaultEntryExpirationTime();
        }
    }

    private static void setEntryExpirationEnabledFlag() {
        String string = SystemProperties.get((String)ENTRY_EXPIRATION_ENABLED_KEY, (String)"false");
        ENTRY_EXPIRATION_ENABLED_FLAG = new Boolean(string);
    }

    private static void setUserEntryExpirationTime() {
        ENTRY_USER_EXPIRE_TIME = CacheBlock.getPropertyIntValue(ENTRY_USER_EXPIRE_TIME_KEY, 15) * 60000;
    }

    private static void setDefaultEntryExpirationTime() {
        ENTRY_DEFAULT_EXPIRE_TIME = CacheBlock.getPropertyIntValue(ENTRY_DEFAULT_EXPIRE_TIME_KEY, 30) * 60000;
    }

    private static int getPropertyIntValue(String string, int n) {
        int n2;
        block4: {
            n2 = n;
            String string2 = SystemProperties.get((String)string);
            if (string2 != null && string2.trim().length() > 0) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = n;
                    if (!debug.warningEnabled()) break block4;
                    debug.warning("CacheBlock.getPropertyIntValue(): Invalid value for property: '" + string + "' Defaulting" + " to value: " + n);
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("CacheBlock.getPropertyIntValue(): " + string + " = " + n2);
        }
        return n2;
    }

    protected static boolean isEntryExpirationEnabled() {
        return ENTRY_EXPIRATION_ENABLED_FLAG;
    }

    private static long getUserEntryExpirationTime() {
        return ENTRY_USER_EXPIRE_TIME;
    }

    private static long getDefaultEntryExpirationTime() {
        return ENTRY_DEFAULT_EXPIRE_TIME;
    }

    protected CacheBlock(String string, boolean bl) {
        if (bl) {
            this.cacheEntries = new AMHashMap();
            this.stringAttributes = new AMHashMap(false);
            this.byteAttributes = new AMHashMap(true);
        } else {
            this.isValidEntry = false;
        }
        this.setLastModifiedTime();
        this.entryDN = string;
    }

    protected CacheBlock(String string, String string2, boolean bl) {
        this(string, bl);
        this.organizationDN = string2;
    }

    protected synchronized void setExists(boolean bl) {
        if (bl) {
            this.cacheEntries = new AMHashMap();
            this.stringAttributes = new AMHashMap(false);
            this.byteAttributes = new AMHashMap(true);
        }
        this.isValidEntry = bl;
        this.updateLastModifiedTime();
    }

    private synchronized void setLastModifiedTime() {
        if (CacheBlock.isEntryExpirationEnabled()) {
            this.lastModifiedTime = System.currentTimeMillis();
        }
    }

    private synchronized void updateLastModifiedTime() {
        if (CacheBlock.isEntryExpirationEnabled() && this.isExpired) {
            this.lastModifiedTime = System.currentTimeMillis();
            this.isExpired = false;
        }
    }

    protected synchronized void setObjectType(int n) {
        this.objectType = n;
        this.updateLastModifiedTime();
    }

    protected synchronized void setOrganizationDN(String string) {
        this.organizationDN = string;
        this.updateLastModifiedTime();
    }

    protected String getOrganizationDN() {
        this.hasExpiredAndUpdated();
        return this.organizationDN;
    }

    protected int getObjectType() {
        return this.objectType;
    }

    protected String getEntryDN() {
        return this.entryDN;
    }

    protected synchronized boolean isExists() {
        return this.isValidEntry;
    }

    protected synchronized boolean hasExpiredAndUpdated() {
        if (CacheBlock.isEntryExpirationEnabled() && !this.isExpired) {
            long l = 0L;
            switch (this.objectType) {
                case 1: {
                    l = CacheBlock.getUserEntryExpirationTime();
                    break;
                }
                default: {
                    l = CacheBlock.getDefaultEntryExpirationTime();
                }
            }
            long l2 = System.currentTimeMillis() - this.lastModifiedTime;
            if (l2 >= l) {
                this.isExpired = true;
                int n = this.objectType;
                this.clear();
                AMObjectImpl.sendExpiryEvent(this.entryDN, n);
            }
        }
        return this.isExpired;
    }

    protected synchronized boolean hasCompleteSet(String string) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        boolean bl = false;
        if (cacheEntry != null && !this.hasExpiredAndUpdated()) {
            bl = cacheEntry.isCompleteSet();
        }
        return bl;
    }

    protected synchronized Map getAttributes(String string, boolean bl) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        Map map = new AMHashMap(bl);
        if (cacheEntry != null && !this.hasExpiredAndUpdated()) {
            Set set = cacheEntry.getReadableAttrNames();
            map = !bl ? this.stringAttributes.getCopy(set) : this.byteAttributes.getCopy(set);
        }
        return map;
    }

    protected synchronized Map getAttributes(String string, Set set, boolean bl) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        Map map = new AMHashMap(bl);
        if (cacheEntry != null && !this.hasExpiredAndUpdated()) {
            Set set2 = cacheEntry.getReadableAttrNames(set);
            map = !bl ? this.stringAttributes.getCopy(set2) : this.byteAttributes.getCopy(set2);
            Set set3 = cacheEntry.getInaccessibleAttrNames(set);
            ((AMHashMap)map).addEmptyValues(set3);
        }
        return map;
    }

    protected synchronized void putAttributes(String string, Map map, Set set, boolean bl, boolean bl2) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            this.cacheEntries.put(string, cacheEntry);
        }
        if (!bl2) {
            Set set2 = this.stringAttributes.copyValuesOnly(map);
            cacheEntry.putAttributes(set2, set, bl);
        } else {
            Set set3 = this.byteAttributes.copyValuesOnly(map);
            cacheEntry.putAttributes(set3, set, bl);
        }
        this.updateLastModifiedTime();
    }

    protected synchronized void removeAttributes(String string) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.remove(string);
        if (cacheEntry != null) {
            cacheEntry.clear();
        }
    }

    protected synchronized void removeAttributes(Set set) {
        if (set != null && !set.isEmpty()) {
            this.stringAttributes.removeKeys(set);
            this.byteAttributes.removeKeys(set);
            Iterator iterator = this.cacheEntries.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.removeAttributes(string, set);
            }
        }
    }

    private synchronized void removeAttributes(String string, Set set) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        if (cacheEntry != null) {
            cacheEntry.removeAttributeNames(set);
        }
    }

    protected synchronized void replaceAttributes(Map map, Map map2) {
        this.stringAttributes.copy(map);
        this.byteAttributes.copy(map2);
    }

    protected synchronized void clear() {
        if (this.isValidEntry) {
            this.stringAttributes.clear();
            this.byteAttributes.clear();
            this.cacheEntries.clear();
        }
        this.lastModifiedTime = 0L;
        this.organizationDN = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n----------- START CACHE BLOCK -----------");
        stringBuffer.append("\nEntry DN: ").append(this.entryDN);
        stringBuffer.append(" Valid Entry: ").append(this.isValidEntry);
        stringBuffer.append("\nOrganization: ").append(this.organizationDN);
        stringBuffer.append("\nString Attributes: ");
        stringBuffer.append(AMCommonUtils.mapSetToString(this.stringAttributes));
        stringBuffer.append("\nByte Attributes: ");
        stringBuffer.append(AMCommonUtils.mapSetToString(this.byteAttributes));
        stringBuffer.append("\nByte Negative Attributes: ");
        stringBuffer.append(this.byteAttributes.getNegativeByteAttrClone().toString());
        stringBuffer.append("\nCache Entries: ");
        if (this.cacheEntries != null && !this.cacheEntries.isEmpty()) {
            Iterator iterator = this.cacheEntries.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
                stringBuffer.append("\nPrincipal: ").append(string);
                stringBuffer.append(cacheEntry.toString());
            }
        } else {
            stringBuffer.append("<empty>");
        }
        stringBuffer.append("\n----------- END CACHE BLOCK -----------");
        return stringBuffer.toString();
    }

    static {
        debug = AMCommonUtils.debug;
        CacheBlock.initializeExpirationParms();
    }

    class CacheEntry {
        private boolean completeSet = false;
        private Set readableAttrNames = new HashSet();
        private Set inAccessibleAttrNames = new HashSet();

        CacheEntry() {
        }

        protected Set getReadableAttrNames() {
            return (Set)((HashSet)this.readableAttrNames).clone();
        }

        protected Set getReadableAttrNames(Set set) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = ((String)iterator.next()).toLowerCase();
                if (!this.readableAttrNames.contains(string)) continue;
                hashSet.add(string);
            }
            return hashSet;
        }

        protected Set getInaccessibleAttrNames(Set set) {
            if (set == null || set.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = ((String)iterator.next()).toLowerCase();
                if (!this.inAccessibleAttrNames.contains(string)) continue;
                hashSet.add(string);
            }
            return hashSet;
        }

        protected void putAttributes(Set set, Set set2, boolean bl) {
            String string;
            Iterator iterator;
            this.completeSet = bl;
            if (set != null && !set.isEmpty()) {
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    string = ((String)iterator.next()).toLowerCase();
                    this.readableAttrNames.add(string);
                }
            }
            if (set2 != null && !set2.isEmpty()) {
                iterator = set2.iterator();
                while (iterator.hasNext()) {
                    string = ((String)iterator.next()).toLowerCase();
                    this.inAccessibleAttrNames.add(string);
                }
            }
        }

        protected void removeAttributeNames(Set set) {
            this.completeSet = false;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = ((String)iterator.next()).toLowerCase();
                boolean bl = this.readableAttrNames.remove(string);
                if (bl) continue;
                this.inAccessibleAttrNames.remove(string);
            }
        }

        protected boolean isCompleteSet() {
            return this.completeSet;
        }

        protected void clear() {
            this.completeSet = false;
            this.readableAttrNames.clear();
            this.inAccessibleAttrNames.clear();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" Complete Set: ").append(this.completeSet);
            stringBuffer.append(" Attributes: ").append(this.readableAttrNames);
            stringBuffer.append(" In Accessable attributes: ");
            stringBuffer.append(this.inAccessibleAttrNames);
            return stringBuffer.toString();
        }
    }
}

