/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.AssignableDynamicGroup;
import com.iplanet.ums.DynamicGroup;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.ManagedRole;
import com.iplanet.ums.Organization;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.Resource;
import com.iplanet.ums.StaticGroup;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.User;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

class AMCompliance
implements AMConstants {
    private static Map roleToGroupMap = new HashMap();
    private static Map groupToRoleMap = new HashMap();
    private static Map deletedOrg = new HashMap();
    protected static final String ADMIN_GROUPS_ENABLED_ATTR = "iplanet-am-admin-console-compliance-admin-groups";
    protected static final String COMPLIANCE_USER_DELETION_ATTR = "iplanet-am-admin-console-compliance-user-deletion";
    private static String USER_STATUS_ATTRIBUTE = "inetuserstatus";
    private static String GROUP_STATUS_ATTRIBUTE = "inetgroupstatus";
    private static String ORG_STATUS_ATTRIBUTE = "inetdomainstatus";
    private static String RESOURCE_STATUS_ATTRIBUTE = "icsstatus";
    private static String DEFAULT_DELETED_ORG_FILTER = "(&(sunPreferredDomain=%V)(inetDomainStatus=deleted)(objectclass=sunManagedOrganization))";
    private static String DEFAULT_DELETED_GROUP_FILTER = "(&(inetgroupstatus=deleted)(objectclass=iplanet-am-managed-group))";
    private static String DEFAULT_DELETED_USER_FILTER = "(&(inetUserStatus=deleted)(objectclass=inetorgperson))";
    private static String DEFAULT_DELETED_OBJECT_FILTER = "(|(objectclass=*)(objectclass=ldapsubentry))";
    private static String DEFAULT_DELETED_RESOURCE_FILTER = "(&(objectclass=icsCalendarResource)(icsStatus = deleted))";
    private static String rootSuffix;
    protected static ServiceSchema gsc;
    static Debug debug;
    static AMDirectoryManager dsManager;
    static SSOToken internalToken;

    AMCompliance() {
    }

    protected static void init() {
        rootSuffix = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
        if (rootSuffix == null || rootSuffix == "") {
            debug.error("com.iplanet.am.rootsuffix property value should not be null");
            return;
        }
        roleToGroupMap.put(AMNamingAttrManager.getNamingAttr(6) + "=Top-level Admin Role," + rootSuffix, "ServiceAdministrators");
        roleToGroupMap.put(AMNamingAttrManager.getNamingAttr(6) + "=Top-level Help Desk Admin Role," + rootSuffix, "ServiceHelpDeskAdministrators");
        roleToGroupMap.put("Organization Admin Role", "DomainAdministrators");
        roleToGroupMap.put("Organization Help Desk Admin Role", "DomainHelpDeskAdministrators");
        groupToRoleMap.put("ServiceAdministrators", "Top-level Admin Role");
        groupToRoleMap.put("ServiceHelpDeskAdministrators", "Top-level Help Desk Admin Role");
        groupToRoleMap.put("DomainAdministrators", "Organization Admin Role");
        groupToRoleMap.put("DomainHelpDeskAdministrators", "Organization Help Desk Admin Role");
    }

    private static void addAttributesToEntry(SSOToken sSOToken, String string, AttrSet attrSet) throws UMSException {
        PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
        int n = attrSet.size();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = attrSet.elementAt(n2);
            persistentObject.modify(attr, 0);
            ++n2;
        }
        persistentObject.save();
    }

    private static void removeAttributesFromEntry(SSOToken sSOToken, String string, AttrSet attrSet) throws UMSException {
        PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
        int n = attrSet.size();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = attrSet.elementAt(n2);
            persistentObject.modify(attr, 1);
            ++n2;
        }
        persistentObject.save();
    }

    private static String getGroupFromRoleDN(DN dN) {
        String string = (String)roleToGroupMap.get(dN.toString());
        if (string == null) {
            String string2 = ((RDN)dN.getRDNs().firstElement()).getValues()[0];
            string = (String)roleToGroupMap.get(string2);
            if (debug.messageEnabled()) {
                debug.message("AMCompliance.getGroupRoleFromDN():Role Name: " + string2 + " Group Name: " + string);
            }
        }
        return string;
    }

    private static String getRoleFromGroupDN(DN dN) {
        String string = dN.explodeDN(true)[0];
        String string2 = (String)groupToRoleMap.get(string);
        if (debug.messageEnabled()) {
            debug.message("AMCompliance.getRoleFromGroupDN: Obtained group to role mapping: " + string + " ::" + string2);
        }
        if (string2 == null) {
            if (debug.messageEnabled()) {
                debug.message("AMCompliance.getRoleFromGroupDN Group: " + dN.toString() + "is not an admin group");
            }
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("AMCompliance.getRoleFromGroupDN:Role Name: " + string2 + " Group Name: " + string);
        }
        return string2;
    }

    protected static void verifyAndLinkRoleToGroup(SSOToken sSOToken, Guid[] guidArray, String string) throws AMException {
        DN dN = new DN(string);
        String string2 = AMCompliance.getGroupFromRoleDN(dN);
        if (string2 != null) {
            String string3 = dN.getParent().toString();
            String string4 = AMNamingAttrManager.getNamingAttr(9) + "=" + string2 + ",ou=Groups," + string3;
            String string5 = AMNamingAttrManager.getNamingAttr(9) + "=" + string2;
            try {
                AssignableDynamicGroup assignableDynamicGroup = (AssignableDynamicGroup)UMSObject.getObject(sSOToken, new Guid(string4));
                assignableDynamicGroup.addMembers(guidArray);
                Attr[] attrArray = new Attr[]{new Attr("adminrole", string5)};
                AttrSet attrSet = new AttrSet(attrArray);
                int n = guidArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AMCompliance.addAttributesToEntry(sSOToken, guidArray[n2].getDn(), attrSet);
                    ++n2;
                }
            }
            catch (EntryNotFoundException entryNotFoundException) {
                debug.error("AMCompliance.verifyAndLinkRoleToGroup: Admin groups are missing");
            }
            catch (UMSException uMSException) {
                debug.error("AMCompliance.verifyAndLinkRoleToGroup(): ", (Throwable)uMSException);
                throw new AMException(AMSDKBundle.getString("771"), "771");
            }
        }
    }

    protected static void verifyAndUnLinkRoleToGroup(SSOToken sSOToken, Set set, String string) throws AMException {
        DN dN = new DN(string);
        String string2 = AMCompliance.getGroupFromRoleDN(dN);
        if (string2 != null) {
            String string3 = dN.getParent().toString();
            String string4 = AMNamingAttrManager.getNamingAttr(9) + "=" + string2 + ",ou=Groups," + string3;
            String string5 = AMNamingAttrManager.getNamingAttr(9) + "=" + string2;
            Attr[] attrArray = new Attr[]{new Attr("adminrole", string5)};
            AttrSet attrSet = new AttrSet(attrArray);
            Iterator iterator = set.iterator();
            try {
                AssignableDynamicGroup assignableDynamicGroup = (AssignableDynamicGroup)UMSObject.getObject(sSOToken, new Guid(string4));
                while (iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    AMCompliance.removeAttributesFromEntry(sSOToken, string6, attrSet);
                    assignableDynamicGroup.removeMember(new Guid(string6));
                }
            }
            catch (EntryNotFoundException entryNotFoundException) {
                debug.error("AMCompliance.verifyAndUnLinkRoleToGroup: Admin groups are missing");
            }
            catch (UMSException uMSException) {
                debug.error("AMCompliance.verifyAndUnLinkRoleToGroup(): ", (Throwable)uMSException);
                throw new AMException(AMSDKBundle.getString("772"), "772");
            }
        }
    }

    protected static void verifyAndLinkGroupToRole(SSOToken sSOToken, Guid[] guidArray, String string) throws AMException {
        DN dN = new DN(string);
        String string2 = AMCompliance.getRoleFromGroupDN(dN);
        if (string2 != null) {
            String string3 = dN.getParent().getParent().toString();
            String string4 = AMNamingAttrManager.getNamingAttr(6) + "=" + string2 + "," + string3;
            String string5 = AMNamingAttrManager.getNamingAttr(6) + "=" + string2;
            if (debug.messageEnabled()) {
                debug.message("AMCompliance.verifyAndLinkGroupToRole Linking group: " + string + " to role :" + string4);
            }
            try {
                ManagedRole managedRole = (ManagedRole)UMSObject.getObject(sSOToken, new Guid(string4));
                managedRole.addMembers(guidArray);
            }
            catch (EntryNotFoundException entryNotFoundException) {
                debug.error("AMCompliance.verifyAndLinkGroupToRole: Admin groups are missing");
            }
            catch (UMSException uMSException) {
                debug.error("AMCompliance.verifyAndLinkGroupToRole():", (Throwable)uMSException);
                Object[] objectArray = new Object[]{string4};
                throw new AMException(AMSDKBundle.getString("972", objectArray), "771", objectArray);
            }
        }
    }

    protected static void verifyAndUnLinkGroupToRole(SSOToken sSOToken, Set set, String string) throws AMException {
        DN dN = new DN(string);
        String string2 = AMCompliance.getRoleFromGroupDN(dN);
        if (string2 != null) {
            String string3 = dN.getParent().getParent().toString();
            String string4 = AMNamingAttrManager.getNamingAttr(6) + "=" + string2 + "," + string3;
            String string5 = AMNamingAttrManager.getNamingAttr(6) + "=" + string2;
            if (debug.messageEnabled()) {
                debug.error("AMCompliance.verifyAndUnlinkGroupToRole(): Unlinking group: " + string + " to role :" + string4);
            }
            Iterator iterator = set.iterator();
            try {
                ManagedRole managedRole = (ManagedRole)UMSObject.getObject(sSOToken, new Guid(string4));
                while (iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    managedRole.removeMember(new Guid(string6));
                }
            }
            catch (EntryNotFoundException entryNotFoundException) {
                debug.error("AMCompliance.verifyAndUnLinkGroupToRole: Admin groups are missing");
            }
            catch (UMSException uMSException) {
                debug.error("AMCompliance.verifyAndUnLinkGroupToRole(): ", (Throwable)uMSException);
                Object[] objectArray = new Object[]{string4};
                throw new AMException(AMSDKBundle.getString("972", objectArray), "772", objectArray);
            }
        }
    }

    protected static void verifyAttributes(AttrSet attrSet) throws AMException {
        String string = attrSet.getValue(USER_STATUS_ATTRIBUTE);
        if (string != null && string.equalsIgnoreCase("deleted")) {
            debug.warning("AMCompliance.verifyAttributes(): " + USER_STATUS_ATTRIBUTE + ": " + string);
            throw new AMException(AMSDKBundle.getString("327"), "327");
        }
    }

    protected static AttrSet verifyAndGetAttributes(PersistentObject persistentObject, String[] stringArray) throws AMException {
        AttrSet attrSet;
        boolean bl = false;
        int n = 0;
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2 + 1];
        while (n < n2) {
            if (stringArray[n].equalsIgnoreCase(USER_STATUS_ATTRIBUTE)) {
                bl = true;
                break;
            }
            stringArray2[n] = stringArray[n];
            ++n;
        }
        if (!bl) {
            stringArray2[n] = USER_STATUS_ATTRIBUTE;
        } else {
            stringArray2 = stringArray;
        }
        try {
            attrSet = persistentObject.getAttributes(stringArray2);
        }
        catch (UMSException uMSException) {
            debug.error("AMCompliance.verifyAndGetAttributes(): ", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("330"), "330");
        }
        AMCompliance.verifyAttributes(attrSet);
        if (!bl) {
            attrSet.remove(USER_STATUS_ATTRIBUTE);
        }
        return attrSet;
    }

    protected static void checkIfDeletedUser(SSOToken sSOToken, String string) throws AMEntryExistsException {
        Attr attr;
        Object object;
        String[] stringArray = new String[]{USER_STATUS_ATTRIBUTE};
        try {
            object = UMSObject.getObject(sSOToken, new Guid(string), stringArray);
            attr = ((PersistentObject)object).getAttribute(USER_STATUS_ATTRIBUTE);
        }
        catch (UMSException uMSException) {
            if (debug.messageEnabled()) {
                debug.message("AMCompliance.checkIfDeleted(): ", (Throwable)uMSException);
            }
            return;
        }
        if (attr != null && (object = attr.getValue()) != null && ((String)object).equalsIgnoreCase("deleted")) {
            debug.warning("AMCompliance.checkIfDeleted(): deleted user entry: " + string);
            throw new AMEntryExistsException(AMSDKBundle.getString("329"), "329");
        }
    }

    protected static boolean isAncestorOrgDeleted(SSOToken sSOToken, String string, int n) throws AMException {
        if (debug.messageEnabled()) {
            debug.message("AMCompliance.issOrgDeleted->  checking from... " + string);
        }
        String string2 = new DN(string).toRFCString().toLowerCase();
        if (n == 2 && deletedOrg.containsKey(string2) && ((Boolean)deletedOrg.get(string2)).booleanValue()) {
            return true;
        }
        if (n != 2) {
            string2 = dsManager.getOrganizationDN(internalToken, string);
        }
        while (!string2.equalsIgnoreCase(rootSuffix)) {
            if (debug.messageEnabled()) {
                debug.message("AMCompliance.isOrgDelete-> Checking for deleted status of " + string2);
            }
            if (deletedOrg.containsKey(string2)) {
                return (Boolean)deletedOrg.get(string2);
            }
            try {
                Map map;
                PersistentObject persistentObject = UMSObject.getObject(internalToken, new Guid(string2));
                Attr attr = persistentObject.getAttribute(ORG_STATUS_ATTRIBUTE);
                if (debug.messageEnabled() && attr != null) {
                    debug.message("AMCompliance.isOrgDelete-> " + ORG_STATUS_ATTRIBUTE + "=" + attr.toString());
                }
                if (attr != null && attr.size() != 0 && attr.contains("deleted")) {
                    if (debug.messageEnabled()) {
                        debug.message("isOrgDeleted: caching org: " + string2 + " as deleted");
                    }
                    map = deletedOrg;
                    synchronized (map) {
                        deletedOrg.put(string2, new Boolean(true));
                    }
                    return true;
                }
                if (debug.messageEnabled()) {
                    debug.message("isOrgDeleted: caching org: " + string2 + " as active");
                }
                map = deletedOrg;
                synchronized (map) {
                    deletedOrg.put(string2, new Boolean(false));
                }
            }
            catch (UMSException uMSException) {
                debug.error("AMCompliance.isOrgDelete-> UMSException", (Throwable)uMSException);
                return false;
            }
            string2 = dsManager.getOrganizationDN(sSOToken, string);
        }
        return false;
    }

    protected static void cleanDeletedOrgCache(String string) {
        Set set = deletedOrg.keySet();
        DN dN = new DN(string);
        String string2 = string;
        while (!string2.equalsIgnoreCase(rootSuffix)) {
            if (deletedOrg.containsKey(string2)) {
                Map map = deletedOrg;
                synchronized (map) {
                    deletedOrg.remove(string2);
                }
            }
            string2 = new DN(string2).getParent().toRFCString().toLowerCase();
        }
    }

    public static void verifyAndDeleteObject(SSOToken sSOToken, String string) throws AMException {
        try {
            Guid guid = new Guid(string);
            PersistentObject persistentObject = UMSObject.getObject(sSOToken, guid);
            if (persistentObject instanceof User) {
                Attr attr = new Attr(USER_STATUS_ATTRIBUTE, "deleted");
                if (debug.messageEnabled()) {
                    debug.message("AMCompliance:verifyAndDeleteObject: Soft-delete mode, setting inetuserstatus to deleted");
                }
                persistentObject.modify(attr, 2);
                persistentObject.save();
                return;
            }
            if (persistentObject instanceof Resource) {
                Attr attr = new Attr(RESOURCE_STATUS_ATTRIBUTE, "deleted");
                if (debug.messageEnabled()) {
                    debug.message("AMCompliance:verifyAndDeleteObject: Soft-delete mode, setting icsstatus to deleted");
                }
                persistentObject.modify(attr, 2);
                persistentObject.save();
                return;
            }
            if (persistentObject instanceof StaticGroup || persistentObject instanceof AssignableDynamicGroup || persistentObject instanceof DynamicGroup) {
                Attr attr = new Attr(GROUP_STATUS_ATTRIBUTE, "deleted");
                if (debug.messageEnabled()) {
                    debug.message("AMCompliance:verifyAndDeleteObject: Soft-delete mode, setting inetgroupstatus to deleted");
                }
                persistentObject.modify(attr, 2);
                persistentObject.save();
                return;
            }
            if (persistentObject instanceof Organization) {
                if (debug.messageEnabled()) {
                    debug.message("AMCompliance:verifyAndDeleteObject: Soft-delete mode, setting inetdomainstatus to deleted");
                }
                Attr attr = new Attr(ORG_STATUS_ATTRIBUTE, "deleted");
                persistentObject.modify(attr, 2);
                persistentObject.save();
                if (AMDCTree.isRequired()) {
                    AMDCTree.updateDomainStatus(sSOToken, string, "deleted");
                }
            } else {
                UMSObject.removeObject(sSOToken, guid);
            }
        }
        catch (UMSException uMSException) {
            debug.error("AMCompliance.deleteObject(): ", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("773"), "773");
        }
    }

    protected static boolean isAdminGroupsEnabled(String string) throws AMException {
        if (!AMCompliance.isUnderRootSuffix(string)) {
            return false;
        }
        try {
            Object object;
            if (gsc == null) {
                object = new ServiceSchemaManager("iPlanetAMAdminConsoleService", internalToken);
                gsc = ((ServiceSchemaManager)object).getGlobalSchema();
            }
            object = gsc.getReadOnlyAttributeDefaults();
            Set set = (Set)object.get(ADMIN_GROUPS_ENABLED_ATTR);
            boolean bl = false;
            if (set == null || set.isEmpty()) {
                bl = false;
            } else {
                String string2 = (String)set.iterator().next();
                bl = string2.equalsIgnoreCase("true");
            }
            if (debug.messageEnabled()) {
                debug.message("AMCompliance.isAdminGroupsEnabled = " + bl);
            }
            return bl;
        }
        catch (SMSException sMSException) {
            debug.error(AMSDKBundle.getString("357"), (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("357"), "357");
        }
        catch (SSOException sSOException) {
            debug.error(AMSDKBundle.getString("357"), (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("357"), "357");
        }
    }

    protected static boolean isUnderRootSuffix(String string) {
        if (string == null || string.equals("")) {
            return true;
        }
        DN dN = new DN(AMStoreConnection.rootSuffix);
        DN dN2 = new DN(string);
        return dN.equals(dN2) || dN.equals(dN2.getParent());
    }

    protected static void createAdminGroups(SSOToken sSOToken, PersistentObject persistentObject) throws AMException {
        String string = AMNamingAttrManager.getNamingAttr(4) + "=groups," + persistentObject.getDN();
        AttrSet attrSet = new AttrSet();
        Attr attr = new Attr("objectclass", "inetadmin");
        attrSet.add(attr);
        attr = new Attr("adminrole", "DomainAdministrators");
        attrSet.add(attr);
        Map map = AMCommonUtils.attrSetToMap(attrSet);
        dsManager.createEntry(sSOToken, "DomainAdministrators", 12, string, map);
        attrSet = new AttrSet();
        attr = new Attr("objectclass", "inetadmin");
        attrSet.add(attr);
        attr = new Attr("adminrole", "DomainAdministrators");
        attrSet.add(attr);
        map = AMCommonUtils.attrSetToMap(attrSet);
        dsManager.createEntry(sSOToken, "DomainHelpDeskAdministrators", 12, string, map);
    }

    protected static boolean isComplianceUserDeletionEnabled() throws AMException {
        try {
            Object object;
            if (gsc == null) {
                object = new ServiceSchemaManager("iPlanetAMAdminConsoleService", internalToken);
                gsc = ((ServiceSchemaManager)object).getGlobalSchema();
            }
            object = gsc.getReadOnlyAttributeDefaults();
            Set set = (Set)object.get(COMPLIANCE_USER_DELETION_ATTR);
            boolean bl = false;
            if (set == null || set.isEmpty()) {
                bl = false;
            } else {
                String string = (String)set.iterator().next();
                bl = string.equalsIgnoreCase("true");
            }
            if (debug.messageEnabled()) {
                debug.message("AMCompliance.isComplianceUserDeletionEnabled = " + bl);
            }
            return bl;
        }
        catch (SMSException sMSException) {
            debug.error(AMSDKBundle.getString("359"), (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("359"), "359");
        }
        catch (SSOException sSOException) {
            debug.error(AMSDKBundle.getString("359"), (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("359"), "359");
        }
    }

    protected static String getDeletedObjectFilter(int n) throws AMException, SSOException {
        Object object;
        Set set = new HashSet();
        try {
            if (gsc == null) {
                object = new ServiceSchemaManager("iPlanetAMAdminConsoleService", internalToken);
                gsc = ((ServiceSchemaManager)object).getGlobalSchema();
            }
            if ((object = gsc.getAttributeDefaults()) != null) {
                set = (Set)object.get("iplanet-am-admin-console-special-search-filters");
            }
            if (debug.messageEnabled()) {
                debug.message("AMCompliance.getDeletedObjectSearchFilter = " + set.toString());
            }
        }
        catch (SMSException sMSException) {
            debug.error(AMSDKBundle.getString("359"), (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("359"), "359");
        }
        catch (SSOException sSOException) {
            debug.error(AMSDKBundle.getString("359"), (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("359"), "359");
        }
        object = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object var7_9 = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            if (string5.startsWith("Organization=")) {
                object = string5.substring(13);
                continue;
            }
            if (string5.startsWith("Group=")) {
                string = string5.substring(6);
                continue;
            }
            if (string5.startsWith("User=")) {
                string2 = string5.substring(5);
                continue;
            }
            if (string5.startsWith("Misc=")) {
                string3 = string5.substring(5);
                continue;
            }
            if (!string5.startsWith("Resource=")) continue;
            string4 = string5.substring(9);
        }
        object = object == null ? DEFAULT_DELETED_ORG_FILTER : object;
        string = string == null ? DEFAULT_DELETED_GROUP_FILTER : string;
        string2 = string2 == null ? DEFAULT_DELETED_USER_FILTER : string2;
        string3 = string3 == null ? DEFAULT_DELETED_OBJECT_FILTER : string3;
        string4 = string4 == null ? DEFAULT_DELETED_RESOURCE_FILTER : string4;
        switch (n) {
            case 2: {
                return object;
            }
            case 1: {
                return string2;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return string;
            }
            case 21: {
                return string4;
            }
        }
        return "(|" + (String)object + string + string2 + string3 + string4 + ")";
    }

    static {
        gsc = null;
        debug = AMCommonUtils.debug;
        AMCompliance.init();
        internalToken = AMCommonUtils.getInternalToken();
        dsManager = AMDirectoryWrapper.getInstance();
    }
}

