/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCallBackImpl;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.CacheBlock;
import com.iplanet.am.sdk.CacheStats;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.Guid;
import com.iplanet.ums.InvalidSearchFilterException;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

class AMCacheManager
extends AMDirectoryManager {
    private static boolean cachingEnabled = true;
    private static int maxSize = 10000;
    private static AMDirectoryManager instance = null;
    private Cache sdkCache;
    private CacheStats cacheStats;

    private static void initializeParams() {
        String string = SystemProperties.get((String)"com.iplanet.am.sdk.cache.maxSize", (String)"10000");
        try {
            maxSize = Integer.parseInt(string);
            if (maxSize < 1) {
                maxSize = 10000;
            }
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCachingManager.intializeParams() Caching size set to: " + maxSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            maxSize = 10000;
            AMDirectoryManager.debug.warning("AMCachingManager.initializeParams() - invalid value for cache size specified. Setting to default value: " + maxSize);
        }
    }

    private AMCacheManager() {
        this.initializeCache();
        this.cacheStats = CacheStats.getInstance();
    }

    private void initializeCache() {
        this.sdkCache = new Cache(maxSize);
    }

    protected int getCachesize() {
        return this.sdkCache.size();
    }

    protected static synchronized AMDirectoryManager getInstance() {
        if (instance == null) {
            AMDirectoryManager.debug.message("AMCacheManager.getInstance(): Creating a new Instance of AMCacheManager()");
            instance = new AMCacheManager();
        }
        return instance;
    }

    protected static int getMaxSize() {
        return maxSize;
    }

    protected static boolean isCachingEnabled() {
        return cachingEnabled;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n<<<<<<< BEGIN SDK CACHE CONTENTS >>>>>>>>");
        if (!this.sdkCache.isEmpty()) {
            Enumeration enumeration = this.sdkCache.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string);
                stringBuffer.append("\nSDK Cache Block: ").append(string);
                stringBuffer.append(cacheBlock.toString());
            }
        } else {
            stringBuffer.append("<empty>");
        }
        stringBuffer.append("\n<<<<<<< END SDK CACHE CONTENTS >>>>>>>>");
        return stringBuffer.toString();
    }

    private void removeCachedAttributes(String string, String string2, Set set) {
        Enumeration enumeration = this.sdkCache.keys();
        while (enumeration.hasMoreElements()) {
            CacheBlock cacheBlock;
            int n;
            int n2;
            String string3 = (String)enumeration.nextElement();
            if (!string3.regionMatches(true, (n2 = string3.length()) - (n = string2.length()), string2, 0, n) || string3.equals(string) || (cacheBlock = (CacheBlock)this.sdkCache.get((Object)string3)) == null || cacheBlock.hasExpiredAndUpdated() || !cacheBlock.isExists()) continue;
            cacheBlock.removeAttributes(set);
        }
    }

    private void clearCachedEntries(String string, String string2) {
        Enumeration enumeration = this.sdkCache.keys();
        while (enumeration.hasMoreElements()) {
            CacheBlock cacheBlock;
            int n;
            int n2;
            String string3 = (String)enumeration.nextElement();
            if (!string3.regionMatches(true, (n2 = string3.length()) - (n = string2.length()), string2, 0, n) || string3.equals(string) || (cacheBlock = (CacheBlock)this.sdkCache.get((Object)string3)) == null) continue;
            cacheBlock.clear();
        }
    }

    protected void dirtyCache(DSEvent dSEvent, String string, boolean bl, boolean bl2, String string2, Set set) {
        int n = dSEvent.getEventType();
        switch (n) {
            case 1: {
                CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
                if (cacheBlock != null) {
                    cacheBlock.setExists(true);
                }
                if (!bl) break;
                this.removeCachedAttributes(string2, string, set);
                break;
            }
            case 2: {
                CacheBlock cacheBlock = (CacheBlock)this.sdkCache.remove((Object)string2);
                if (cacheBlock != null) {
                    cacheBlock.clear();
                }
                if (!bl) break;
                this.removeCachedAttributes(string2, string, set);
                break;
            }
            case 8: {
                CacheBlock cacheBlock = (CacheBlock)this.sdkCache.remove((Object)string2);
                if (cacheBlock != null) {
                    cacheBlock.clear();
                }
                if (!bl) break;
                this.removeCachedAttributes(string2, string, set);
                break;
            }
            case 4: {
                CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
                if (cacheBlock != null) {
                    cacheBlock.clear();
                }
                if (bl) {
                    this.removeCachedAttributes(string2, string, set);
                    break;
                }
                if (!bl2) break;
                this.clearCachedEntries(string2, string);
            }
        }
        if (AMDirectoryManager.debug.messageEnabled()) {
            AMDirectoryManager.debug.message("AMCacheManager.dirtyCache(): Cache dirtied because of Event Notification. Parameters - eventType: " + n + ", cosType: " + bl + ", aciChange: " + bl2 + ", fullDN: " + string2 + ", affectDNs: " + string);
        }
    }

    private void dirtyCache(String string) {
        String string2 = AMCommonUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
        if (cacheBlock != null) {
            cacheBlock.clear();
        }
    }

    private void dirtyCache(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = AMCommonUtils.formatToRFC(string);
            CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
            if (cacheBlock == null) continue;
            cacheBlock.clear();
        }
    }

    private void updateCache(SSOToken sSOToken, String string, Map map, Map map2) {
        String string2 = AMCommonUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
        if (cacheBlock != null && !cacheBlock.hasExpiredAndUpdated() && cacheBlock.isExists()) {
            cacheBlock.replaceAttributes(map, map2);
        }
    }

    private void validateEntry(SSOToken sSOToken, CacheBlock cacheBlock) throws AMException {
        if (!cacheBlock.hasExpiredAndUpdated() && !cacheBlock.isExists()) {
            Object[] objectArray = new String[]{cacheBlock.getEntryDN()};
            String string = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("461", objectArray, string), "461", objectArray);
        }
    }

    protected boolean doesEntryExists(SSOToken sSOToken, String string) {
        String string2 = AMCommonUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
        if (cacheBlock != null && !cacheBlock.hasExpiredAndUpdated()) {
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.doesEntryExist(): entryDN: " + string + " found in cache & exists: " + cacheBlock.isExists());
            }
            return cacheBlock.isExists();
        }
        boolean bl = super.doesEntryExists(sSOToken, string2);
        if (AMDirectoryManager.debug.messageEnabled()) {
            AMDirectoryManager.debug.message("AMCacheManager.doesEntryExist(): entryDN: " + string + " got from DS & exists: " + bl);
        }
        if (cacheBlock == null) {
            cacheBlock = new CacheBlock(string, bl);
            this.sdkCache.put((Object)string2, (Object)cacheBlock);
        } else {
            cacheBlock.setExists(bl);
        }
        return bl;
    }

    private void setOrganizationDNs(String string, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
            if (cacheBlock == null) {
                cacheBlock = new CacheBlock(string2, string, true);
                this.sdkCache.put((Object)string2, (Object)cacheBlock);
                continue;
            }
            cacheBlock.setOrganizationDN(string);
        }
        if (AMDirectoryManager.debug.messageEnabled() && !set.isEmpty()) {
            AMDirectoryManager.debug.message("AMCacheManager.setOrganizationDNs(): Set org DNs as: " + string + " for children: " + set);
        }
    }

    protected void updateUserAttribute(SSOToken sSOToken, Set set, String string, boolean bl) throws AMException {
        super.updateUserAttribute(sSOToken, set, string, bl);
        this.dirtyCache(set);
    }

    protected String getOrganizationDN(SSOToken sSOToken, String string) throws AMException {
        String string2;
        if (string.equals("") || !DN.isDN(string)) {
            AMDirectoryManager.debug.error("AMCacheManager.getOrganizationDN() Invalid DN: " + string);
            throw new AMException(sSOToken, "157");
        }
        DN dN = new DN(string);
        String[] stringArray = new String[]{"objectclass"};
        SearchControl searchControl = new SearchControl();
        searchControl.setSearchScope(0);
        SSOToken sSOToken2 = AMCommonUtils.getInternalToken();
        String string3 = "";
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        boolean bl2 = false;
        try {
            while (!bl && !bl2) {
                CacheBlock cacheBlock;
                string2 = dN.toString().toLowerCase();
                if (AMDirectoryManager.debug.messageEnabled()) {
                    AMDirectoryManager.debug.message("AMCacheManager.getOrganizationDN() - looping Organization DN for entry: " + string2);
                }
                if ((cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2)) != null && (string3 = cacheBlock.getOrganizationDN()) != null) {
                    if (AMDirectoryManager.debug.messageEnabled()) {
                        AMDirectoryManager.debug.message("AMCacheManager.getOrganizationDN(): found OrganizationDN: " + string3 + " for: " + string2);
                    }
                    bl2 = true;
                    this.setOrganizationDNs(string3, hashSet);
                    continue;
                }
                hashSet.add(string2);
                PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken2, new Guid(string2));
                String string4 = super.getOrgSearchFilter(string);
                SearchResults searchResults = persistentObject.search(string4, stringArray, searchControl);
                if (searchResults.hasMoreElements()) {
                    bl2 = true;
                    searchResults.abandon();
                    string3 = persistentObject.getGuid().toString().toLowerCase();
                    this.setOrganizationDNs(string3, hashSet);
                    continue;
                }
                if (dN.countRDNs() == 1) {
                    bl = true;
                    AMDirectoryManager.debug.error("AMDirectoryManager.getOrganizationDN(): Reached root suffix. Unable to get parent Org");
                    continue;
                }
                dN = dN.getParent();
            }
        }
        catch (InvalidSearchFilterException invalidSearchFilterException) {
            bl = true;
            AMDirectoryManager.debug.error("AMDirectoryManager.getOrganizationDN(): Invalid search filter, unable to get Parent Organization: ", (Throwable)invalidSearchFilterException);
        }
        catch (UMSException uMSException) {
            bl = true;
            AMDirectoryManager.debug.error("AMDirectoryManager.getOrganizationDN(): Unable to Obtain Parent Organization", (Throwable)uMSException);
        }
        if (bl) {
            string2 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("124", string2), "124");
        }
        return string3;
    }

    protected int getObjectType(SSOToken sSOToken, String string) throws AMException, SSOException {
        int n;
        String string2 = AMCommonUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
        if (cacheBlock != null) {
            this.validateEntry(sSOToken, cacheBlock);
            n = cacheBlock.getObjectType();
            if (n != -9999) {
                return n;
            }
        } else {
            cacheBlock = new CacheBlock(string2, true);
            this.sdkCache.put((Object)string2, (Object)cacheBlock);
        }
        n = super.getObjectType(sSOToken, string2);
        cacheBlock.setObjectType(n);
        return n;
    }

    private Map getExternalAttributes(SSOToken sSOToken, String string, Set set, int n) throws AMException {
        SSOToken sSOToken2 = AMCommonUtils.getInternalToken();
        String string2 = n == 1 ? new DN(string).getParent().toString() : string;
        String string3 = this.getOrganizationDN(sSOToken2, string2);
        return AMCallBackImpl.getAttributes(sSOToken, string, set, string3);
    }

    protected Map getAttributes(SSOToken sSOToken, String string, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        AMHashMap aMHashMap;
        CacheBlock cacheBlock;
        this.cacheStats.incrementRequestCount();
        String string2 = AMCommonUtils.getPrincipalDN(sSOToken);
        String string3 = AMCommonUtils.formatToRFC(string);
        if (AMDirectoryManager.debug.messageEnabled()) {
            AMDirectoryManager.debug.message("In AMCacheManager.getAttributes(SSOTokenentryDN, ignoreCompliance) (" + string2 + ", " + string + ", " + bl + " method.");
        }
        if ((cacheBlock = (CacheBlock)this.sdkCache.get((Object)string3)) != null) {
            this.validateEntry(sSOToken, cacheBlock);
            if (cacheBlock.hasCompleteSet(string2)) {
                this.cacheStats.updateHitCount();
                if (AMDirectoryManager.debug.messageEnabled()) {
                    AMDirectoryManager.debug.message("AMCacheManager.getAttributes(): foundall attributes in Cache.");
                }
                aMHashMap = (AMHashMap)cacheBlock.getAttributes(string2, bl2);
            } else {
                if (AMDirectoryManager.debug.messageEnabled()) {
                    AMDirectoryManager.debug.message("AMCacheManager.getAttributes():  complete attribute set NOT found in cache. Getting from DS.");
                }
                aMHashMap = (AMHashMap)super.getAttributes(sSOToken, string, bl, bl2, n);
                cacheBlock.putAttributes(string2, aMHashMap, null, true, bl2);
            }
        } else {
            aMHashMap = (AMHashMap)super.getAttributes(sSOToken, string, bl, bl2, n);
            cacheBlock = new CacheBlock(string, true);
            cacheBlock.putAttributes(string2, aMHashMap, null, true, bl2);
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getAttributes(): attributes NOT found in cache. Fetched from DS.");
            }
        }
        Map map = this.getExternalAttributes(sSOToken, string, null, n);
        if (map != null && map.isEmpty()) {
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getAttributes(): External attributes present. Merging them with original list");
            }
            aMHashMap.merge(map);
        }
        return aMHashMap;
    }

    private AMHashMap getPluginAttrsAndUpdateCache(SSOToken sSOToken, String string, String string2, CacheBlock cacheBlock, AMHashMap aMHashMap, Set set, boolean bl, int n) throws AMException {
        Map map = this.getExternalAttributes(sSOToken, string2, set, n);
        if (map != null && map.isEmpty()) {
            aMHashMap.removeKeys(map.keySet());
            cacheBlock.putAttributes(string, aMHashMap, null, false, bl);
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getPluginAttrsAndUpdateCache(): External attributes present. Merging them with original list");
            }
            aMHashMap.merge(map);
        }
        return aMHashMap;
    }

    protected Map getAttributes(SSOToken sSOToken, String string, Set set, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        String string2;
        CacheBlock cacheBlock;
        if (set == null || set.isEmpty()) {
            return this.getAttributes(sSOToken, string, bl, bl2, n);
        }
        this.cacheStats.incrementRequestCount();
        if (AMDCTree.isRequired()) {
            this.getAttributes(sSOToken, string, bl, bl2, n);
        }
        String string3 = AMCommonUtils.getPrincipalDN(sSOToken);
        if (AMDirectoryManager.debug.messageEnabled()) {
            AMDirectoryManager.debug.message("In AMCacheManager.getAttributes(SSOTokenentryDN, attrNames, ignoreCompliance, byteValues) (" + string3 + ", " + string + ", " + set + ", " + bl + ", " + bl2 + " method.");
        }
        if ((cacheBlock = (CacheBlock)this.sdkCache.get((Object)(string2 = AMCommonUtils.formatToRFC(string)))) == null) {
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getAttributes():  NO entry found in Cache. Getting all these attributes from DS: " + set);
            }
            AMHashMap aMHashMap = (AMHashMap)super.getAttributes(sSOToken, string, set, bl, bl2, n);
            Set set2 = aMHashMap.getMissingAndEmptyKeys(set);
            cacheBlock = new CacheBlock(string2, true);
            cacheBlock.putAttributes(string3, aMHashMap, set2, false, bl2);
            this.sdkCache.put((Object)string2, (Object)cacheBlock);
            if (!set2.isEmpty()) {
                aMHashMap = this.getPluginAttrsAndUpdateCache(sSOToken, string3, string, cacheBlock, aMHashMap, set2, bl2, n);
            }
            return aMHashMap;
        }
        this.validateEntry(sSOToken, cacheBlock);
        AMHashMap aMHashMap = (AMHashMap)cacheBlock.getAttributes(string3, set, bl2);
        Set set3 = aMHashMap.getMissingKeys(set);
        if (!set3.isEmpty()) {
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getAttributes(): Trying to get these missing attributes from DS: " + set3);
            }
            AMHashMap aMHashMap2 = (AMHashMap)super.getAttributes(sSOToken, string, set3, bl, bl2, n);
            aMHashMap.putAll(aMHashMap2);
            Set set4 = aMHashMap2.getMissingAndEmptyKeys(set3);
            cacheBlock.putAttributes(string3, aMHashMap2, set4, false, bl2);
            if (!set4.isEmpty()) {
                aMHashMap = this.getPluginAttrsAndUpdateCache(sSOToken, string3, string, cacheBlock, aMHashMap, set4, bl2, n);
            }
        } else {
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getAttributes():  found all attributes in Cache.");
            }
            this.cacheStats.updateHitCount();
        }
        return aMHashMap;
    }

    protected String renameEntry(SSOToken sSOToken, int n, String string, String string2, boolean bl) throws AMException {
        String string3 = super.renameEntry(sSOToken, n, string, string2, bl);
        String string4 = AMCommonUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.remove((Object)string4);
        string3 = AMCommonUtils.formatToRFC(string3);
        this.sdkCache.put((Object)string3, (Object)cacheBlock);
        return string3;
    }

    protected void setAttributes(SSOToken sSOToken, String string, int n, Map map, Map map2, boolean bl) throws AMException, SSOException {
        super.setAttributes(sSOToken, string, n, map, map2, bl);
        if (n == 1) {
            this.updateCache(sSOToken, string, map, map2);
        } else if (n != 1) {
            this.dirtyCache(string);
        }
    }

    protected void modifyRoleMembership(SSOToken sSOToken, String string, Set set, int n, int n2) throws UMSException, AMException {
        super.modifyRoleMembership(sSOToken, string, set, n, n2);
        this.dirtyCache(set);
    }

    protected void createEntry(SSOToken sSOToken, String string, int n, String string2, Map map) throws AMEntryExistsException, AMException {
        super.createEntry(sSOToken, string, n, string2, map);
        this.dirtyCache(string);
    }

    protected String createAMTemplate(SSOToken sSOToken, String string, int n, String string2, Map map, int n2) throws AMException {
        String string3 = super.createAMTemplate(sSOToken, string, n, string2, map, n2);
        String string4 = AMCommonUtils.formatToRFC(string3);
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string4);
        if (cacheBlock != null) {
            cacheBlock.setExists(true);
        }
        return string3;
    }

    static {
        AMCacheManager.initializeParams();
    }
}

