/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

abstract class ServiceTemplateAttrValuesReq
extends AdminReq {
    protected Map mapAttrValues = new HashMap();
    protected String serviceName;
    protected int stype;
    protected String scope = "SCOPE_ONE";
    protected boolean roleTemplate = false;
    protected SSOToken ssoToken = null;

    ServiceTemplateAttrValuesReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString(this.getDescriptionString()) + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    abstract String getDescriptionString();

    void addRequest(String string, String string2, String string3, String string4, Map map, SSOToken sSOToken) throws AdminException {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new UnsupportedOperationException();
        }
        this.serviceName = string;
        this.mapAttrValues = map;
        this.scope = string3;
        this.roleTemplate = string4.equalsIgnoreCase("true");
        this.stype = -1;
        this.ssoToken = sSOToken;
        if (string2.equalsIgnoreCase("dynamic")) {
            this.stype = 301;
        } else if (string2.equalsIgnoreCase("organization")) {
            this.stype = 302;
        } else if (string2.equalsIgnoreCase("policy")) {
            this.stype = 300;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    abstract void modifyServiceTemplates(AMStoreConnection var1, String var2) throws AdminException;

    AMTemplate getTemplate(AMRole aMRole) throws AdminException {
        AMTemplate aMTemplate = null;
        try {
            aMTemplate = aMRole.getTemplate(this.serviceName, this.stype);
            if (aMTemplate != null && !aMTemplate.isExists()) {
                aMTemplate = null;
            }
        }
        catch (AMException aMException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(aMException.toString());
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        return aMTemplate;
    }

    AMTemplate getTemplate(AMOrganization aMOrganization) throws AdminException {
        AMTemplate aMTemplate = null;
        try {
            aMTemplate = aMOrganization.getTemplate(this.serviceName, this.stype);
            if (aMTemplate != null && !aMTemplate.isExists()) {
                aMTemplate = null;
            }
        }
        catch (AMException aMException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(aMException.toString());
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        return aMTemplate;
    }

    AMTemplate getTemplate(AMOrganizationalUnit aMOrganizationalUnit) throws AdminException {
        AMTemplate aMTemplate = null;
        try {
            aMTemplate = aMOrganizationalUnit.getTemplate(this.serviceName, this.stype);
            if (aMTemplate != null && !aMTemplate.isExists()) {
                aMTemplate = null;
            }
        }
        catch (AMException aMException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(aMException.toString());
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        return aMTemplate;
    }

    abstract void process(AMStoreConnection var1) throws AdminException;
}

