/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

class RoleUtils {
    RoleUtils() {
    }

    static AMRole getRole(String string, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        AMRole aMRole = null;
        try {
            switch (n) {
                case 6: {
                    aMRole = aMStoreConnection.getRole(string);
                    break;
                }
                case 8: {
                    aMRole = aMStoreConnection.getFilteredRole(string);
                }
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
        return aMRole;
    }

    static int getRoleType(String string, AMStoreConnection aMStoreConnection) throws AdminException {
        try {
            return aMStoreConnection.getAMObjectType(string);
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    static void printRoleInformation(PrintUtils printUtils, Set set, AMStoreConnection aMStoreConnection, ResourceBundle resourceBundle, int n) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AMRole aMRole = RoleUtils.getRole(string, aMStoreConnection, n);
                Map map = aMRole.getAttributes();
                AdminReq.writer.println("  " + string);
                printUtils.printAVPairs(map, 2);
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

