/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class OrgUnregisterServicesReq
extends AdminReq {
    private Set serviceSet = new HashSet();

    OrgUnregisterServicesReq() {
    }

    OrgUnregisterServicesReq(String string) {
        super(string);
    }

    void unregisterServicesReq(String string) {
        this.serviceSet.add(string);
    }

    Set getUnregisterOrgReq() {
        return this.serviceSet;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription45") + " " + this.targetDN);
        printUtils.printSet(this.serviceSet, 1);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("unregisteredservices"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("unregisteredservices"));
        try {
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            Iterator iterator = this.serviceSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                aMOrganization.unregisterService(string);
                AdminReq.writer.println(string);
                if (AdminUtils.logEnabled()) {
                    AdminUtils.log(string);
                }
                this.doLog(string, aMOrganization, "unregister-service");
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

