/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;

class OrgGetNumOfServicesReq
extends AdminReq {
    OrgGetNumOfServicesReq() {
    }

    OrgGetNumOfServicesReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Request Description: Get Number of services from Organization " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        try {
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            long l = aMOrganization.getNumberOfServices();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("numberofservices") + l);
            }
            AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("numberofservices") + l);
            AdminReq.writer.flush();
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

