/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AddDeleteReq;
import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;

class OrgDeleteRoleReq
extends AddDeleteReq {
    OrgDeleteRoleReq() {
    }

    OrgDeleteRoleReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println("Request Description: Delete Roles in Organization " + this.targetDN);
        if (this.DNSet.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.DNSet, 1);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deleteroles"));
        try {
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            aMOrganization.deleteRoles(this.DNSet);
            PrintUtils printUtils = new PrintUtils(AdminReq.writer);
            printUtils.printSet(this.DNSet, 1);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deletedroles") + ": " + this.DNSet);
            }
            this.doLogStringSet(this.DNSet, "delete-role");
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

