/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.GroupUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class GroupGetSubGroupReq
extends AdminReq {
    private Set subGroupDNs = new HashSet();
    private String level = "SCOPE_SUB";
    private boolean DNsOnly = true;

    GroupGetSubGroupReq(String string) {
        super(string);
    }

    void setLevel(String string) {
        this.level = string;
    }

    void setDNsOnly(boolean bl) {
        this.DNsOnly = bl;
    }

    void addSubGroupDNs(String string) {
        this.subGroupDNs.add(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription23") + " " + this.targetDN);
        printWriter.println("  level = " + this.level);
        printWriter.println("  DNsOnly = " + this.DNsOnly);
        if (this.subGroupDNs.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.subGroupDNs, 2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("getsubgroups") + this.targetDN);
        }
        AdminReq.writer.println(AdminReq.bundle.getString("group") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getsubgroups"));
        try {
            int n;
            boolean bl = false;
            int n2 = n = this.level.equals("SCOPE_SUB") ? 2 : 1;
            if (this.subGroupDNs.isEmpty()) {
                this.subGroupDNs = this.getSubGroups(aMStoreConnection, n);
            } else {
                bl = true;
            }
            Iterator iterator = this.subGroupDNs.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AMObject aMObject = GroupUtils.getGroupObject(string, aMStoreConnection, AdminReq.bundle);
                if (bl && (!aMObject.isExists() || !AdminUtils.isDescendantOf(aMObject, this.targetDN, n))) continue;
                AdminReq.writer.println("  " + string);
                if (this.DNsOnly) continue;
                printUtils.printAVPairs(aMObject.getAttributes(), 2);
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    protected Set getSubGroups(AMStoreConnection aMStoreConnection, int n) throws AdminException {
        try {
            AMStaticGroup aMStaticGroup = aMStoreConnection.getStaticGroup(this.targetDN);
            return aMStaticGroup.searchGroups("*", n);
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

