/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AddDeleteReq;
import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;

class GroupDeleteUserReq
extends AddDeleteReq {
    GroupDeleteUserReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription80") + " " + this.targetDN);
        if (this.DNSet.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.DNSet, 1);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("group") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("removeusers"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("group") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("removeusers"));
        try {
            int n = aMStoreConnection.getAMObjectType(this.targetDN);
            if (n == 12) {
                AMAssignableDynamicGroup aMAssignableDynamicGroup = aMStoreConnection.getAssignableDynamicGroup(this.targetDN);
                aMAssignableDynamicGroup.removeUsers(this.DNSet);
                this.doLogStringSet(this.DNSet, aMAssignableDynamicGroup, "remove-user-from-group");
            } else if (n == 10) {
                AMStaticGroup aMStaticGroup = aMStoreConnection.getStaticGroup(this.targetDN);
                aMStaticGroup.removeUsers(this.DNSet);
                this.doLogStringSet(this.DNSet, aMStaticGroup, "remove-user-from-group");
            } else {
                throw new AdminException(AdminReq.bundle.getString("cannotRemoveUsersFromDynamicGroup"));
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("group") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("removedusers"));
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

