/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.COTHandler;
import com.iplanet.am.admin.cli.ProviderHandler;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSCircleOfTrustDescriptor;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSIDPAuthenticationContextInfo;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.alliance.FSSPAuthenticationContextInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FedServicesRequestHandler
extends AdminReq {
    private SSOToken ssoToken = null;
    private FSAllianceManager allianceMgr = null;
    private FSAccountManager accountMgr = null;
    private ProviderHandler provReqHandler = null;
    private String orgDN = null;
    private String providerId = null;
    private String providerRole = null;
    public String errorMessage = null;
    HashMap authCtxtMapping = null;

    public FedServicesRequestHandler(String string, SSOToken sSOToken) throws FSAllianceManagementException, FSInvalidNameException {
        this.orgDN = string;
        this.ssoToken = sSOToken;
        this.allianceMgr = new FSAllianceManager(sSOToken, string);
        this.initAuthCtxtHashMap();
    }

    void initAuthCtxtHashMap() {
        this.authCtxtMapping = new HashMap();
        this.authCtxtMapping.put("MobileContract", "http://www.projectliberty.org/schemas/authctx/classes/MobileContract");
        this.authCtxtMapping.put("MobileDigitalID", "http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID");
        this.authCtxtMapping.put("MobileUnregistered", "http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered");
        this.authCtxtMapping.put("Password", "http://www.projectliberty.org/schemas/authctx/classes/Password");
        this.authCtxtMapping.put("Password-ProtectedTransport", "http://www.projectliberty.org/schemas/authctx/classes/Password-ProtectedTransport");
        this.authCtxtMapping.put("Previous-Session", "http://www.projectliberty.org/schemas/authctx/classes/Previous-Session");
        this.authCtxtMapping.put("Smartcard", "http://www.projectliberty.org/schemas/authctx/classes/Smartcard");
        this.authCtxtMapping.put("Smartcard-PKI", "http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI");
        this.authCtxtMapping.put("Software-PKI", "http://www.projectliberty.org/schemas/authctx/classes/Software-PKI");
        this.authCtxtMapping.put("Time-Sync-Token", "http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token");
    }

    public FedServicesRequestHandler() throws FSAccountMgmtException {
        this.accountMgr = FSAccountManager.getInstance();
    }

    public void createRemoteProvider(Node node) throws FSInvalidNameException, FSAllianceManagementException {
        Map map = this.getAttrVals(node);
        String string = ((Element)node).getAttributeNode("id").getValue();
        String string2 = ((Element)node).getAttributeNode("role").getValue();
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.orgDN + "\n" + AdminReq.bundle.getString("createremoteprovider") + " " + string);
        this.provReqHandler = new ProviderHandler(string, string2);
        FSProviderDescriptor fSProviderDescriptor = this.provReqHandler.getProviderDescriptor(map, "remote");
        this.allianceMgr.createProvider(fSProviderDescriptor);
    }

    public void createHostedProvider(Node node) throws FSInvalidNameException, FSAllianceManagementException {
        Map map = this.getAttrVals(node);
        Map map2 = this.getSPAuthCtxtInfo(node);
        Map map3 = this.getIDPAuthCtxtInfo(node);
        String string = ((Element)node).getAttributeNode("id").getValue();
        String string2 = ((Element)node).getAttributeNode("role").getValue();
        String string3 = null;
        if (((Element)node).hasAttribute("defaultUrlPrefix")) {
            string3 = ((Element)node).getAttributeNode("defaultUrlPrefix").getValue();
        }
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.orgDN + "\n" + AdminReq.bundle.getString("createhostedprovider") + " " + string);
        this.provReqHandler = new ProviderHandler(string, string2, string3);
        FSHostedProviderDescriptor fSHostedProviderDescriptor = (FSHostedProviderDescriptor)this.provReqHandler.getProviderDescriptor(map, "hosted");
        FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration();
        map3 = this.updateMap(map3, fSLocalConfigurationDescriptor.getIDPAuthContextInfo());
        if (map3 != null && map3.size() > 0) {
            fSHostedProviderDescriptor = this.provReqHandler.setIDPAuthCtxtInfo(fSHostedProviderDescriptor, map3);
        }
        fSHostedProviderDescriptor.setLocalConfiguration(fSLocalConfigurationDescriptor);
        map2 = this.updateMap(map2, fSLocalConfigurationDescriptor.getSPAuthContextInfo());
        if (map2 != null && map2.size() > 0) {
            fSHostedProviderDescriptor = this.provReqHandler.setSPAuthCtxtInfo(fSHostedProviderDescriptor, map2);
        }
        fSLocalConfigurationDescriptor = this.provReqHandler.modifyLocalConfiguration(fSLocalConfigurationDescriptor, map);
        fSHostedProviderDescriptor.setLocalConfiguration(fSLocalConfigurationDescriptor);
        this.allianceMgr.createProvider(fSHostedProviderDescriptor);
    }

    public void modifyRemoteProvider(Node node) throws FSAllianceManagementException {
        Map map = this.getAttrVals(node);
        String string = ((Element)node).getAttributeNode("id").getValue();
        String string2 = ((Element)node).getAttributeNode("role").getValue();
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.orgDN + "\n" + AdminReq.bundle.getString("modifyremoteprovider") + " " + string);
        this.provReqHandler = new ProviderHandler(string, string2);
        FSProviderDescriptor fSProviderDescriptor = this.allianceMgr.getProvider(string);
        fSProviderDescriptor = this.provReqHandler.changeProvider(fSProviderDescriptor, map);
        this.allianceMgr.modifyProvider(fSProviderDescriptor);
    }

    public void modifyHostedProvider(Node node) throws FSAllianceManagementException {
        Map map = this.getAttrVals(node);
        Map map2 = this.getSPAuthCtxtInfo(node);
        Map map3 = this.getIDPAuthCtxtInfo(node);
        String string = ((Element)node).getAttributeNode("id").getValue();
        String string2 = ((Element)node).getAttributeNode("role").getValue();
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.orgDN + "\n" + AdminReq.bundle.getString("modifyhostedprovider") + " " + string);
        this.provReqHandler = new ProviderHandler(string, string2);
        FSProviderDescriptor fSProviderDescriptor = this.allianceMgr.getProvider(string);
        fSProviderDescriptor = this.provReqHandler.changeProvider(fSProviderDescriptor, map);
        if (map2 != null && map2.size() > 0) {
            fSProviderDescriptor = this.provReqHandler.setSPAuthCtxtInfo((FSHostedProviderDescriptor)fSProviderDescriptor, map2);
        }
        if (map3 != null && map3.size() > 0) {
            fSProviderDescriptor = this.provReqHandler.setIDPAuthCtxtInfo((FSHostedProviderDescriptor)fSProviderDescriptor, map3);
        }
        FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = ((FSHostedProviderDescriptor)fSProviderDescriptor).getLocalConfiguration();
        fSLocalConfigurationDescriptor = this.provReqHandler.modifyLocalConfiguration(fSLocalConfigurationDescriptor, map);
        ((FSHostedProviderDescriptor)fSProviderDescriptor).setLocalConfiguration(fSLocalConfigurationDescriptor);
        this.allianceMgr.modifyProvider(fSProviderDescriptor);
    }

    Map updateMap(Map map, Map map2) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            map2.put(k, map.get(k));
        }
        return map2;
    }

    public void deleteProvider(String string) throws FSAllianceManagementException, FSInvalidNameException {
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.orgDN + "\n" + AdminReq.bundle.getString("deleteprovider") + " " + string);
        this.allianceMgr.deleteProvider(string);
    }

    public void createAuthenticationDomain(Node node) throws FSAllianceManagementException, FSInvalidNameException {
        Map map = this.getAttrVals(node);
        String string = ((Element)node).getAttributeNode("name").getValue();
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.orgDN + "\n" + AdminReq.bundle.getString("createauthenticationdomain") + " " + string);
        COTHandler cOTHandler = new COTHandler(string);
        FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor = cOTHandler.getCicleOfTrustInfo(map);
        this.allianceMgr.createCircleOfTrust(fSCircleOfTrustDescriptor);
    }

    private Map getAttrVals(Node node) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = "";
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).hasChildNodes() && nodeList.item(n).getNodeName().equalsIgnoreCase("AttributeValuePair")) {
                NodeList nodeList2;
                Element element = (Element)((Element)nodeList.item(n)).getElementsByTagName("Attribute").item(0);
                if (element.hasAttribute("name")) {
                    string = element.getAttributeNode("name").getValue();
                }
                if ((nodeList2 = ((Element)nodeList.item(n)).getElementsByTagName("Value")).getLength() == 1) {
                    hashMap.put(string.toLowerCase(), nodeList2.item(0).getFirstChild().getNodeValue());
                } else {
                    HashSet<String> hashSet = new HashSet<String>(nodeList2.getLength());
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        hashSet.add(nodeList2.item(n2).getFirstChild().getNodeValue());
                        ++n2;
                    }
                    hashMap.put(string.toLowerCase(), hashSet);
                }
            }
            ++n;
        }
        return hashMap;
    }

    private Map getSPAuthCtxtInfo(Node node) {
        HashMap<String, FSSPAuthenticationContextInfo> hashMap = new HashMap<String, FSSPAuthenticationContextInfo>();
        NodeList nodeList = ((Element)node).getElementsByTagName("SPAuthContextInfo");
        int n = 0;
        while (n < nodeList.getLength()) {
            String string = ((Element)nodeList.item(n)).getAttributeNode("AuthContext").getValue();
            String string2 = this.authCtxtKeyValue(string);
            String string3 = ((Element)nodeList.item(n)).getAttributeNode("AuthLevel").getValue();
            hashMap.put(string2, new FSSPAuthenticationContextInfo(string2, Integer.parseInt(string3)));
            ++n;
        }
        return hashMap;
    }

    private Map getIDPAuthCtxtInfo(Node node) {
        HashMap<String, FSIDPAuthenticationContextInfo> hashMap = new HashMap<String, FSIDPAuthenticationContextInfo>();
        NodeList nodeList = ((Element)node).getElementsByTagName("IDPAuthContextInfo");
        FSIDPAuthenticationContextInfo fSIDPAuthenticationContextInfo = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            String string = ((Element)nodeList.item(n)).getAttributeNode("AuthContext").getValue();
            String string2 = ((Element)nodeList.item(n)).getAttributeNode("Priority").getValue();
            NodeList nodeList2 = ((Element)nodeList.item(n)).getElementsByTagName("AuthMethodQueryString").item(0).getChildNodes();
            String string3 = ((Element)nodeList.item(n)).getAttributeNode("IsSupported").getValue();
            if (nodeList2.getLength() > 0) {
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Node node2 = nodeList2.item(n2);
                    if (node2.getNodeType() == 1) {
                        String string4 = node2.getNodeName();
                        String string5 = node2.getFirstChild().getNodeValue();
                        fSIDPAuthenticationContextInfo = new FSIDPAuthenticationContextInfo(this.authCtxtKeyValue(string), Integer.parseInt(string2), string4, string5, Boolean.valueOf(string3));
                    }
                    ++n2;
                }
            }
            hashMap.put(this.authCtxtKeyValue(string), fSIDPAuthenticationContextInfo);
            ++n;
        }
        return hashMap;
    }

    String authCtxtKeyValue(String string) {
        return (String)this.authCtxtMapping.get(string);
    }

    public void modifyAuthenticationDomain(Node node) throws FSAllianceManagementException, FSInvalidNameException {
        Map map = this.getAttrVals(node);
        String string = ((Element)node).getAttributeNode("name").getValue();
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.orgDN + "\n" + AdminReq.bundle.getString("modifyauthenticationdomain") + " " + string);
        FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor = this.allianceMgr.getCircleOfTrust(string);
        COTHandler cOTHandler = new COTHandler(string);
        fSCircleOfTrustDescriptor = cOTHandler.modifyCircleOfTrust(fSCircleOfTrustDescriptor, map);
        this.allianceMgr.modifyCircleOfTrust(fSCircleOfTrustDescriptor);
    }

    public void deleteAuthenticationDomain(String string) throws FSAllianceManagementException, FSInvalidNameException {
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.orgDN + "\n" + AdminReq.bundle.getString("deleteauthenticationdomain") + " " + string);
        this.allianceMgr.deleteCircleOfTrust(string);
    }

    public void getAuthenticationDomain(String string) throws FSAllianceManagementException, FSInvalidNameException {
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.orgDN + "\n" + AdminReq.bundle.getString("getauthenticationdomain") + " " + string);
        FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor = this.allianceMgr.getCircleOfTrust(string);
        System.out.println("AuthenticationDomain : " + string);
        System.out.println("iplanet-am-authenticationdomain-description : " + fSCircleOfTrustDescriptor.getCircleOfTrustDescription());
        System.out.println("iplanet-am-authenticationdomain-status : " + fSCircleOfTrustDescriptor.getCircleOfTrustStatus());
        System.out.println("iplanet-am-readerservice-url : " + fSCircleOfTrustDescriptor.getReaderServiceURL());
        System.out.println("iplanet-am-writerservice-url : " + fSCircleOfTrustDescriptor.getWriterServiceURL());
    }

    public void getProvider(String string) throws FSAllianceManagementException, FSInvalidNameException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.orgDN + "\n" + AdminReq.bundle.getString("getprovider") + " " + string);
        FSProviderDescriptor fSProviderDescriptor = this.allianceMgr.getProvider(string);
        System.out.println("Provider : " + string);
        System.out.println("iplanet-am-provider-name : " + fSProviderDescriptor.getProviderName());
        System.out.println("iplanet-am-provider-status : " + fSProviderDescriptor.getProviderStatus());
        System.out.println("iplanet-am-provider-succinctid : " + fSProviderDescriptor.getProviderSuccinctID());
        System.out.println("iplanet-am-provider-role : " + fSProviderDescriptor.getProviderRole());
        System.out.println("iplanet-am-certificate-alias : " + fSProviderDescriptor.getKeyInfo());
        System.out.println("iplanet-am-soap-end-point : " + fSProviderDescriptor.getSOAPEndPoint());
        System.out.println("iplanet-am-slo-service-url : " + fSProviderDescriptor.getSLOServiceURL());
        System.out.println("iplanet-am-slo-service-return-url : " + fSProviderDescriptor.getSLOServiceReturnURL());
        System.out.println("iplanet-am-federation-termination-service-url : " + fSProviderDescriptor.getFederationTerminationServiceURL());
        System.out.println("iplanet-am-federation-termination-service-return-url : " + fSProviderDescriptor.getFederationTerminationServiceReturnURL());
        System.out.println("iplanet-am-name-registration-url : " + fSProviderDescriptor.getNameRegistrationURL());
        System.out.println("iplanet-am-name-registration-return-url : " + fSProviderDescriptor.getNameRegistrationReturnURL());
        System.out.println("iplanet-am-name-registration-profile : " + fSProviderDescriptor.getNameRegistrationProfile());
        System.out.println("iplanet-am-name-registration-after-sso : " + fSProviderDescriptor.getNameRegistrationAfterSSO());
        System.out.println("iplanet-am-assertion-consumer-service-url : " + fSProviderDescriptor.getAssertionConsumerServiceURL());
        System.out.println("iplanet-am-federation-termination-protocol-profile : " + fSProviderDescriptor.getFederationTerminationProtocolProfile());
        System.out.println("iplanet-am-slo-protocol-profile : " + fSProviderDescriptor.getSLOProtocolProfile());
        System.out.println("iplanet-am-authnrequest-signed : " + fSProviderDescriptor.getAuthnRequestSigned());
        System.out.println("iplanet-am-sso-service-url : " + fSProviderDescriptor.getSSOServiceURL());
        System.out.println("iplanet-am-name-registration-indicator : " + fSProviderDescriptor.getNameRegistrationIndicator());
        System.out.println("iplanet-am-list-of-authenticationdomains : ");
        Set set = fSProviderDescriptor.getListOfCOTs();
        int n = 1;
        if (set != null) {
            object4 = set.iterator();
            while (object4.hasNext()) {
                System.out.println(n + ")" + (String)object4.next());
                ++n;
            }
        }
        object4 = null;
        if (fSProviderDescriptor instanceof FSHostedProviderDescriptor) {
            object4 = ((FSHostedProviderDescriptor)fSProviderDescriptor).getLocalConfiguration();
        }
        if (object4 == null) {
            return;
        }
        System.out.println("iplanet-am-provider-alias : " + ((FSLocalConfigurationDescriptor)object4).getProviderAlias());
        System.out.println("iplanet-am-provider-auth-type : " + ((FSLocalConfigurationDescriptor)object4).getProviderAuthType());
        System.out.println("iplanet-am-authnfed-profile : " + ((FSLocalConfigurationDescriptor)object4).getAuthnfedProfile());
        System.out.println("iplanet-am-force-authentication : " + ((FSLocalConfigurationDescriptor)object4).getForceAuthentication());
        System.out.println("iplanet-am-is-passive : " + ((FSLocalConfigurationDescriptor)object4).getIsPassive());
        System.out.println("iplanet-am-respond-withs : " + ((FSLocalConfigurationDescriptor)object4).getRespondWiths());
        System.out.println("iplanet-am-liberty-version-url : " + ((FSLocalConfigurationDescriptor)object4).getLibertyVersionURI());
        System.out.println("iplanet-am-assertion-interval : " + ((FSLocalConfigurationDescriptor)object4).getAssertionInterval());
        System.out.println("iplanet-am-assertion-limit : " + ((FSLocalConfigurationDescriptor)object4).getAssertionLimit());
        System.out.println("iplanet-am-cleanup-interval : " + ((FSLocalConfigurationDescriptor)object4).getCleanupInterval());
        System.out.println("iplanet-am-artifact-timeout : " + ((FSLocalConfigurationDescriptor)object4).getArtifactTimeout());
        System.out.println("iplanet-am-provider-homepage-url : " + ((FSLocalConfigurationDescriptor)object4).getProviderHomePageURL());
        System.out.println("iplanet-am-trusted-providers : ");
        Set set2 = ((FSLocalConfigurationDescriptor)object4).getTrustedProviders();
        n = 1;
        if (set2 != null) {
            object3 = set2.iterator();
            while (object3.hasNext()) {
                System.out.println(n + ")" + (String)object3.next());
                ++n;
            }
        }
        if ((object3 = ((FSLocalConfigurationDescriptor)object4).getSPAuthContextInfo()) != null) {
            System.out.println("SPAuthenticationContextInfo");
            object2 = object3.keySet().iterator();
            while (object2.hasNext()) {
                object = (FSSPAuthenticationContextInfo)object3.get(object2.next());
                System.out.println(((FSSPAuthenticationContextInfo)object).getAuthenticationContext() + " : " + ((FSSPAuthenticationContextInfo)object).getAuthenticationLevel());
            }
        }
        if ((object = ((FSLocalConfigurationDescriptor)object4).getIDPAuthContextInfo()) != null) {
            System.out.println("IDPAuthenticationContextInfo");
            Iterator iterator = object.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (FSIDPAuthenticationContextInfo)object.get(iterator.next());
                System.out.println(((FSIDPAuthenticationContextInfo)object2).getAuthenticationContext() + "  " + ((FSIDPAuthenticationContextInfo)object2).getPriority() + " " + ((FSIDPAuthenticationContextInfo)object2).getModuleIndicatorKey() + " " + ((FSIDPAuthenticationContextInfo)object2).getModuleIndicatorValue() + " " + ((FSIDPAuthenticationContextInfo)object2).getIsSupported());
            }
        }
    }

    public void ListAccts(Node node) {
        this.errorMessage = null;
        if (node.getNodeName().equalsIgnoreCase("ListAccts")) {
            try {
                String string = ((Element)node).getAttributeNode("dn").getValue();
                Set set = this.accountMgr.readAllFederatedProviderID(string);
                if (set != null) {
                    Iterator iterator = set.iterator();
                    if (set.size() > 0) {
                        int n = 0;
                        while (n < set.size()) {
                            System.out.println(n + ")" + (String)iterator.next());
                            ++n;
                        }
                    } else {
                        this.errorMessage = "account-not-federated";
                    }
                }
            }
            catch (FSAccountMgmtException fSAccountMgmtException) {
                this.errorMessage = "accountmgr-error";
            }
        }
    }
}

