/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.RoleUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;

class ContGetRoleReq
extends AdminReq {
    private String level = "SCOPE_SUB";

    ContGetRoleReq() {
    }

    ContGetRoleReq(String string) {
        super(string);
    }

    void setLevel(String string) {
        this.level = string;
    }

    String getLevel() {
        return this.level;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription16") + " " + this.targetDN);
        printWriter.println("   level =" + this.level);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        try {
            if (AdminUtils.logEnabled() && AdminUtils.debugEnabled) {
                AdminUtils.log(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getroles"));
            }
            AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + "\n" + AdminReq.bundle.getString("getroles"));
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            AdminReq.writer.println(this.targetDN);
            int n = this.level.equals("SCOPE_SUB") ? 2 : 1;
            RoleUtils.printRoleInformation(printUtils, aMOrganizationalUnit.searchRoles("*", n), aMStoreConnection, AdminReq.bundle, 6);
            RoleUtils.printRoleInformation(printUtils, aMOrganizationalUnit.searchFilteredRoles("*", n), aMStoreConnection, AdminReq.bundle, 8);
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

