/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ContGetPCReq
extends AdminReq {
    private Set PCDNs = new HashSet();
    private boolean DNsOnly = true;

    ContGetPCReq() {
    }

    public ContGetPCReq(String string) {
        super(string);
    }

    void setDNsOnly(boolean bl) {
        this.DNsOnly = bl;
    }

    boolean isDNsOnly() {
        return this.DNsOnly;
    }

    void addPCDNs(String string) {
        this.PCDNs.add(string);
    }

    Set getPCDNs() {
        return this.PCDNs;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription14") + " " + this.targetDN);
        printWriter.println("   DNsOnly =" + this.DNsOnly);
        if (this.PCDNs.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.PCDNs, 2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        if (AdminUtils.logEnabled() && AdminUtils.debugEnabled) {
            AdminUtils.log(AdminReq.bundle.getString("getpeoplecontainers") + AdminReq.bundle.getString("container") + this.targetDN);
        }
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getpeoplecontainers"));
        try {
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            AdminReq.writer.println(this.targetDN);
            boolean bl = false;
            if (this.PCDNs.isEmpty()) {
                this.PCDNs = aMOrganizationalUnit.searchPeopleContainers("*", 1);
            } else {
                bl = true;
            }
            Iterator iterator = this.PCDNs.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AMPeopleContainer aMPeopleContainer = aMStoreConnection.getPeopleContainer(string);
                if (bl && (!aMPeopleContainer.isExists() || !AdminUtils.isChildOf(aMPeopleContainer, this.targetDN))) continue;
                AdminReq.writer.println("  " + string);
                if (this.DNsOnly) continue;
                printUtils.printAVPairs(aMPeopleContainer.getAttributes(), 2);
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

