/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AddDeleteReq;
import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;

class ContDeleteSubContReq
extends AddDeleteReq {
    private boolean recursiveDelete = false;

    ContDeleteSubContReq(String string) {
        super(string);
    }

    void setRecursiveDelete(boolean bl) {
        this.recursiveDelete = bl;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription10") + " " + this.targetDN);
        if (this.DNSet.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.DNSet, 1);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deletecontainer"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deletecontainer"));
        try {
            Iterator iterator = this.DNSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(string);
                aMOrganizationalUnit.delete(this.recursiveDelete);
                AdminReq.writer.println(string);
                if (AdminUtils.logEnabled()) {
                    AdminUtils.log(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deletedcontainers") + ": " + string);
                }
                this.doLog(aMOrganizationalUnit, "delete-container");
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

