/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.log.Logger;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

class AdminUtils {
    public static final int VERBOSE = 1;
    public static final int DEBUG = 2;
    private static final String ACCESS_LOG = "amAdmin.access";
    private static final String ERROR_LOG = "amAdmin.error";
    private static int level;
    private static Debug debug;
    private static Logger logger;
    protected static boolean verboseEnabled;
    protected static boolean debugEnabled;
    private static boolean logEnabled;
    private static SSOToken ssot;
    public static final int LOG_ACCESS = 0;
    public static final int LOG_ERROR = 1;

    private AdminUtils() {
    }

    static void setDebug(Debug debug) {
        AdminUtils.debug = debug;
    }

    static void setDebugStatus(int n) {
        debug.setDebug(n);
    }

    static void setLog(boolean bl) {
        logEnabled = bl;
    }

    static void setSSOToken(SSOToken sSOToken) {
        ssot = sSOToken;
    }

    static void enableVerbose(boolean bl) {
        verboseEnabled = bl;
        level = 1;
    }

    static void enableDebug(boolean bl) {
        debugEnabled = bl;
        level = 2;
    }

    public static void log(String string) {
        if (level == 1) {
            System.out.println(string);
        } else if (level == 2 && debug != null && debug.messageEnabled()) {
            debug.message(string);
        }
    }

    public static void logOperation(int n, String string) {
        AdminUtils.logOperation(n, string, ssot);
    }

    public static void logOperation(int n, String string, SSOToken sSOToken) {
        if (logEnabled) {
            com.sun.identity.log.LogRecord logRecord = new com.sun.identity.log.LogRecord(Level.INFO, string, (Object)sSOToken);
            try {
                logRecord.addLogInfo("HostName", (Object)sSOToken.getHostName());
                logRecord.addLogInfo("LoginID", (Object)sSOToken.getPrincipal().getName());
            }
            catch (SSOException sSOException) {
                debug.error("AdminUtils.logOperation", (Throwable)sSOException);
            }
            logRecord.addLogInfo("LoginIDSid", (Object)sSOToken.getTokenID().toString());
            switch (n) {
                case 0: {
                    logger = (Logger)Logger.getLogger((String)ACCESS_LOG);
                    logRecord.addLogInfo("ModuleName", (Object)ACCESS_LOG);
                    break;
                }
                case 1: {
                    logger = (Logger)Logger.getLogger((String)ERROR_LOG);
                    logRecord.addLogInfo("ModuleName", (Object)ERROR_LOG);
                    break;
                }
                default: {
                    logger = (Logger)Logger.getLogger((String)ACCESS_LOG);
                    logRecord.addLogInfo("ModuleName", (Object)ACCESS_LOG);
                }
            }
            logger.log((LogRecord)logRecord, (Object)sSOToken);
        }
    }

    public static void log(String string, Throwable throwable) {
        if (level == 1) {
            System.err.println(string);
        } else if (level == 2 && debug != null && debugEnabled) {
            debug.error(string, throwable);
        }
    }

    public static boolean logEnabled() {
        return verboseEnabled || debugEnabled;
    }

    static void printAttributeNameValuesMap(PrintWriter printWriter, PrintUtils printUtils, Map map) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            printWriter.println("  " + k.toString());
            printUtils.printAVPairs((Map)map.get(k), 2);
        }
    }

    static boolean isChildOf(AMObject aMObject, String string) {
        return AdminUtils.isDescendantOf(aMObject, string, 1);
    }

    static boolean isDescendantOf(AMObject aMObject, String string) {
        return AdminUtils.isDescendantOf(aMObject, string, 2);
    }

    static boolean isDescendantOf(AMObject aMObject, String string, int n) {
        boolean bl = LDAPDN.equals(aMObject.getDN(), string);
        if (!bl) {
            if (n == 1) {
                bl = LDAPDN.equals(aMObject.getParentDN(), string);
            } else {
                DN dN = new DN(aMObject.getDN());
                bl = dN.isDescendantOf(new DN(string));
            }
        }
        return bl;
    }

    static String getPeopleContainerDN(AMOrganization aMOrganization) throws AdminException {
        try {
            Set set = aMOrganization.getPeopleContainers(1);
            String string = null;
            if (set != null && !set.isEmpty()) {
                string = (String)set.iterator().next();
            }
            return string;
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    static String getPeopleContainerDN(AMOrganizationalUnit aMOrganizationalUnit) throws AdminException {
        try {
            Set set = aMOrganizationalUnit.getPeopleContainers(1);
            String string = null;
            if (set != null && !set.isEmpty()) {
                string = (String)set.iterator().next();
            }
            return string;
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    static {
        debug = null;
        logger = null;
        verboseEnabled = false;
        debugEnabled = false;
        logEnabled = true;
        ssot = null;
    }
}

