/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.s1is;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.https.JSSPasswordCallback;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.util.PasswordCallback;

public class LogConfigReader
implements ServiceListener {
    private static Debug debug;
    private static ServiceSchema smsLogSchema;
    private static ServiceSchema smsPlatformSchema;
    private static ServiceSchema smsNamingSchema;
    private static Map logAttributes;
    private static Map platformAttributes;
    private static Map namingAttributes;
    private String localProtocol = SystemProperties.get((String)"com.iplanet.am.server.protocol");
    private String localHost = SystemProperties.get((String)"com.iplanet.am.server.host");
    private String localPort = SystemProperties.get((String)"com.iplanet.am.server.port");
    public static String localLogServiceID;
    private static boolean isRegisteredForDSEvents;
    private LogManager manager;

    public LogConfigReader() throws IOException {
        SSOToken sSOToken;
        localLogServiceID = this.localProtocol + "://" + this.localHost + ":" + this.localPort;
        try {
            sSOToken = this.getSSOToken();
        }
        catch (SSOException sSOException) {
            debug.error("LogConfigReader: Couldnot get proper SSOToken", (Throwable)sSOException);
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("LogConfigReader: ssoToken obtained" + sSOToken);
        }
        try {
            this.getDefaultAttributes(sSOToken);
        }
        catch (SMSException sMSException) {
            debug.warning("LogConfigReader: Could not get defaultAttributes", (Throwable)sMSException);
            return;
        }
        catch (SSOException sSOException) {
            debug.error("LogConfigReader: Could not get defaultAttributes", (Throwable)sSOException);
            return;
        }
        String string = this.constructInputStream();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes("ISO8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            debug.error("LogConfigReader: unsupported Encoding" + unsupportedEncodingException);
        }
        this.manager = (LogManager)LogManagerUtil.getLogManager();
        try {
            this.manager.readConfiguration(byteArrayInputStream);
        }
        catch (IOException iOException) {
            debug.error("LogConfigReader: cant load configuration" + iOException);
            throw new IOException(iOException.toString());
        }
        this.setLocalFlag();
    }

    private String constructInputStream() {
        Iterator iterator;
        Set set;
        String string;
        StringBuffer stringBuffer = new StringBuffer(2000);
        String string2 = null;
        String string3 = null;
        try {
            logAttributes = smsLogSchema.getAttributeDefaults();
            string2 = "iplanet-am-logging-type";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: Backend string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read Backend ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-db-driver";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: Driver string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read driver ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-db-password";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: Password string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read password ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-db-user";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: DB_USER string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read db user ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-allfields";
            string = "time, Data, ";
            set = (Set)logAttributes.get(string2);
            iterator = set.iterator();
            string = string + (String)iterator.next();
            while (iterator.hasNext()) {
                string = string + ", " + (String)iterator.next();
            }
            stringBuffer.append(string2).append("=").append(string).append("\r\n");
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read all field  ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-logfields";
            set = (Set)logAttributes.get(string2);
            if (set != null && set.size() != 0) {
                iterator = set.iterator();
                string = (String)iterator.next();
                while (iterator.hasNext()) {
                    string = string + ", " + (String)iterator.next();
                }
                stringBuffer.append(string2).append("=").append(string).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read log-field ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-max-file-size";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: Max File Size string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read maxfilesize ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-num-hist-file";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: NUM_HIST_FILES string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read numhistfiles ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-archiver-class";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: Archiver string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:couldnot read filehandler ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-file-handler";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: FileHandler class string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:couldnot read filehandler ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-secure-file-handler";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: Secure FH string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:couldnot read secure filehandler ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-jdbc-handler";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: DBHandler string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read dbhandler ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-remote-handler";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: Remote Handler string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read remotehandler ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-elf-formatter";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader:ELFFormatter string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read elfformatter ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-secure-elf-formatter";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: Secure ELFFormatter string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read secure formatter ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-db-formatter";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            stringBuffer.append(string2).append("=").append(string3).append("\r\n");
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read dbformatter ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-remote-formatter";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            stringBuffer.append(string2).append("=").append(string3).append("\r\n");
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read remoteformatter ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-authz-class";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: AUTHZ string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read authz class", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-location";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: LogLocation string is null");
            } else {
                string3 = string3.replace('\\', '/');
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read loglocation ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-security-status";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: Security status string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read security status ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-verify-period-in-seconds";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: Verify period string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read logverify period", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-signature-period-in-seconds";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: sign period string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read sign fieldname ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-file-read-handler";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: file readhandler string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read filehandler class ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-max-records";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: Max records string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read max-records ", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-files-per-keystore";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: filesper keystore string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read files per keystore", (Throwable)exception);
        }
        try {
            string2 = "iplanet-am-logging-token-class";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: token provider string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read Token Generation Class name");
        }
        try {
            string2 = "iplanet-am-logging-secure-timestamp-generator";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: timestamp generator string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read Token Generation Class name");
        }
        try {
            string2 = "iplanet-am-logging-verifier-action-class";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: verifier actionclass string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read verifier output Class name");
        }
        try {
            string2 = "iplanet-am-logging-filter-class-name";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: filter class name string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read filter class");
        }
        try {
            string2 = "iplanet-am-logging-debug-class";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.error("LogConfigReader: debug implclass string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read debug Impl Class name");
        }
        try {
            string2 = "iplanet-am-logging-certificate-database-directory";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: cert db dir string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read Cert-DB dir name");
        }
        try {
            string2 = "iplanet-am-logging-certificate-database-prefix";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: cert db prefix string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read Cert-DB prefix");
        }
        try {
            string2 = "iplanet-am-logging-key-database-prefix";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: key db prefix string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read Key-DB prefix");
        }
        try {
            string2 = "iplanet-am-logging-security-module-name";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: security module db name string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read Security Module DB name");
        }
        try {
            string2 = "iplanet-am-logging-security-initializer-class-name";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: security Initializer class name string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read Security Initializer class name");
        }
        try {
            string2 = "iplanet-am-logging-buffer-size";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: buffer size string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read buf size");
        }
        try {
            string2 = "iplanet-am-logging-buffer-time-in-seconds";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: buffer time string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read buf time");
        }
        try {
            string2 = "iplanet-am-logging-time-buffering-status";
            string3 = Misc.getMapAttr((Map)logAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: time buffering status string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read time buffering status ");
        }
        try {
            string2 = "com.iplanet.am.logstatus";
            string3 = SystemProperties.get((String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: Log Status string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader:Couldnot read Log Status");
        }
        try {
            platformAttributes = smsPlatformSchema.getAttributeDefaults();
            string2 = "iplanet-am-platform-locale";
            string3 = Misc.getMapAttr((Map)platformAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: locale string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: couldnot read platform ", (Throwable)exception);
        }
        try {
            namingAttributes = smsNamingSchema.getAttributeDefaults();
            string2 = "iplanet-am-naming-logging-url";
            string3 = Misc.getMapAttr((Map)namingAttributes, (String)string2);
            if (string3 == null || string3.length() == 0) {
                debug.warning("LogConfigReader: loggins service url string is null");
            } else {
                stringBuffer.append(string2).append("=").append(string3).append("\r\n");
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: could not get from DS", (Throwable)exception);
        }
        return stringBuffer.toString();
    }

    private void getDefaultAttributes(SSOToken sSOToken) throws SMSException, SSOException {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMLoggingService", sSOToken);
        smsLogSchema = serviceSchemaManager.getGlobalSchema();
        if (!isRegisteredForDSEvents) {
            serviceSchemaManager.addListener((ServiceListener)this);
        }
        serviceSchemaManager = new ServiceSchemaManager("iPlanetAMPlatformService", sSOToken);
        if (!isRegisteredForDSEvents) {
            serviceSchemaManager.addListener((ServiceListener)this);
        }
        smsPlatformSchema = serviceSchemaManager.getGlobalSchema();
        serviceSchemaManager = new ServiceSchemaManager("iPlanetAMNamingService", sSOToken);
        if (!isRegisteredForDSEvents) {
            serviceSchemaManager.addListener((ServiceListener)this);
            isRegisteredForDSEvents = true;
        }
        smsNamingSchema = serviceSchemaManager.getGlobalSchema();
        logAttributes = smsLogSchema.getAttributeDefaults();
        platformAttributes = smsPlatformSchema.getAttributeDefaults();
        namingAttributes = smsNamingSchema.getAttributeDefaults();
    }

    private SSOToken getSSOToken() throws SSOException {
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        String string = (String)AccessController.doPrivileged(new AdminDNAction());
        String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
        SSOToken sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        return sSOToken;
    }

    private void setLocalFlag() {
        if (debug.messageEnabled()) {
            debug.message("LogConfigReader: logserviceID is" + localLogServiceID);
        }
        try {
            String string = this.manager.getProperty("iplanet-am-naming-logging-url");
            String string2 = null;
            string2 = string.indexOf("%") == -1 ? string : localLogServiceID;
            if (localLogServiceID != null && string2 != null) {
                LogManager.isLocal = string2.startsWith(localLogServiceID);
            }
        }
        catch (Exception exception) {
            debug.error("LogConfigReader: Error setting localFlag: ", (Throwable)exception);
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
        debug.message("Global config change");
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        debug.message("Org config change");
    }

    public void schemaChanged(String string, String string2) {
        if (debug.messageEnabled()) {
            debug.message("LogService schemaChanged(): ver = " + string2);
        }
        try {
            this.manager.readConfiguration();
        }
        catch (Exception exception) {
            debug.error("Error in readConfiguration()", (Throwable)exception);
        }
    }

    static {
        smsLogSchema = null;
        smsPlatformSchema = null;
        smsNamingSchema = null;
        logAttributes = null;
        platformAttributes = null;
        namingAttributes = null;
        localLogServiceID = null;
        isRegisteredForDSEvents = false;
        debug = Debug.getInstance((String)"amLog");
        String string = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.passfile");
        String string2 = null;
        if (string != null) {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(string);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                string2 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                debug.warning("LogConfigReader:static Unable to read JSS password file. This is OK if logging security is not turned on.");
            }
            try {
                fileInputStream = CryptoManager.getInstance();
                if (string2 != null) {
                    fileInputStream.setPasswordCallback((PasswordCallback)new JSSPasswordCallback(string2));
                }
            }
            catch (CryptoManager.NotInitializedException notInitializedException) {
                debug.message("LogConfigReader:static CryptoManager not initialized");
            }
        }
    }
}

