/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.LogQuery;
import com.sun.identity.log.QueryElement;
import com.sun.identity.log.handlers.LogReadHandler;
import com.sun.identity.log.util.LogRecordSorter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class LogReadFileHandler
implements LogReadHandler {
    private String logFileName;
    private String logFileLocation;
    private LogQuery queryChriteria = null;
    private int maxNoOfRecs = -1;
    private String version = "#Version:";
    private String fieldName = "#Fields: ";
    private LogRecordSorter sorter = null;
    private String[][] queryResult;
    private ArrayList listOfValidRecords = new ArrayList();

    public String[][] logRecRead(String string, LogQuery logQuery, boolean bl) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        String string2;
        this.cleaner();
        this.logFileName = string;
        boolean bl2 = false;
        if (bl) {
            this.queryChriteria = logQuery;
        }
        try {
            bl2 = this.getFieldNames();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw exception;
        }
        if (!bl2) {
            return this.queryResult;
        }
        this.maxNoOfRecs = logQuery != null ? (logQuery.getNumRecordsWanted() == -1 || logQuery.getNumRecordsWanted() < -2 ? 1 : logQuery.getNumRecordsWanted()) : 1;
        try {
            if (bl) {
                this.getRecords(true);
            } else {
                this.getRecords(false);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw exception;
        }
        int n = this.listOfValidRecords.size();
        if (n <= 0) {
            return null;
        }
        if (this.queryChriteria != null && (string2 = this.queryChriteria.getSortingField()) != null) {
            try {
                this.sorter = new LogRecordSorter(string2, this.listOfValidRecords);
                this.queryResult = this.sorter.getSortedRecords();
                return this.queryResult;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw noSuchFieldException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        this.queryResult = new String[n][];
        int n2 = 0;
        while (n2 < n) {
            this.queryResult[n2] = (String[])this.listOfValidRecords.get(n2);
            ++n2;
        }
        return this.queryResult;
    }

    private boolean getFieldNames() throws IOException, RuntimeException, Exception {
        boolean bl = false;
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFileName));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().length() <= 0 || string.startsWith(this.version) || !string.startsWith(this.fieldName)) continue;
                String string2 = string.substring(this.fieldName.length());
                if (!bl) {
                    ArrayList arrayList = this.getFields(string2, true);
                    String[] stringArray = new String[arrayList.size()];
                    int n = 0;
                    while (n < stringArray.length) {
                        stringArray[n] = (String)arrayList.get(n);
                        ++n;
                    }
                    this.listOfValidRecords.add(stringArray);
                    bl = true;
                }
                break;
            }
        }
        catch (IOException iOException) {
            String string = "Problem in reading " + this.logFileName;
            throw new IOException(string);
        }
        catch (RuntimeException runtimeException) {
            String string = "Problem in reading " + this.logFileName;
            throw new RuntimeException(string);
        }
        catch (Exception exception) {
            throw exception;
        }
        return bl;
    }

    private boolean getRecords(boolean bl) throws IOException, RuntimeException {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFileName));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().length() <= 0 || string.startsWith(this.version) || string.startsWith(this.fieldName)) continue;
                ArrayList arrayList = new ArrayList();
                arrayList = this.getFields(string, bl);
                String[] stringArray = new String[arrayList.size()];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = (String)arrayList.get(n);
                    ++n;
                }
                if (this.queryChriteria == null) {
                    this.collect(stringArray);
                    continue;
                }
                if (!this.applyQuery(stringArray)) continue;
                this.collect(stringArray);
            }
        }
        catch (RuntimeException runtimeException) {
            String string = "Problem in reading " + this.logFileName;
            throw new IOException(string);
        }
        catch (Exception exception) {
            String string = "Problem in reading " + this.logFileName;
            throw new RuntimeException(string);
        }
        return true;
    }

    private boolean applyQuery(String[] stringArray) {
        ArrayList arrayList = this.queryChriteria.getQueries();
        if (arrayList == null) {
            return true;
        }
        int n = arrayList.size();
        if (n == 0) {
            return true;
        }
        int n2 = this.queryChriteria.getGlobalOperand();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            bl = false;
            bl = this.doMatch(stringArray, (QueryElement)arrayList.get(n3));
            if (n2 == 1 ? !bl : n2 == 2 && bl) {
                return bl;
            }
            ++n3;
        }
        return bl;
    }

    private boolean doMatch(String[] stringArray, QueryElement queryElement) {
        boolean bl = false;
        int n = -1;
        String[] stringArray2 = (String[])this.listOfValidRecords.get(0);
        int n2 = stringArray2.length;
        String string = queryElement.getFieldName();
        String string2 = queryElement.getFieldValue();
        int n3 = 0;
        while (n3 < n2) {
            if (string.compareTo(stringArray2[n3]) == 0) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n == -1) {
            return bl;
        }
        int n4 = 0;
        n4 = stringArray[n].compareTo(string2);
        int n5 = queryElement.getRelation();
        switch (n5) {
            case 3: {
                if (n4 != 0) break;
                return true;
            }
            case 2: {
                if (n4 >= 0) break;
                return true;
            }
            case 1: {
                if (n4 <= 0) break;
                return true;
            }
            case 6: {
                if (n4 > 0) break;
                return true;
            }
            case 5: {
                if (n4 < 0) break;
                return true;
            }
            case 4: {
                if (n4 == 0) break;
                return true;
            }
        }
        return false;
    }

    private void collect(String[] stringArray) {
        int n = this.listOfValidRecords.size();
        if (this.maxNoOfRecs != -2 && n > this.maxNoOfRecs) {
            this.shiftRecordsUpward();
        }
        this.appendRecord(stringArray);
    }

    private void appendRecord(String[] stringArray) {
        this.listOfValidRecords.add(stringArray);
    }

    private void shiftRecordsUpward() {
        if (this.listOfValidRecords.size() <= 1) {
            return;
        }
        this.listOfValidRecords.remove(1);
    }

    private ArrayList getFields(String string, boolean bl) {
        String string2 = string.trim();
        String string3 = string.trim();
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = '\"';
        char c2 = '\n';
        char c3 = '\r';
        int n = string3.length();
        int n2 = 0;
        boolean bl2 = true;
        String string4 = new String();
        int n3 = string3.length();
        while (n2 < n3) {
            char c4 = string3.charAt(n2);
            if (c4 == c) {
                String string5 = string3.substring(n2);
                int n4 = string5.length();
                int n5 = 1;
                boolean bl3 = false;
                String string6 = new String();
                if (!bl) {
                    string6 = string6 + c;
                }
                boolean bl4 = false;
                while (n5 < n3) {
                    char c5 = string5.charAt(n5);
                    if (c5 != c && c5 != c2 && c5 != c3) {
                        string6 = string6 + c5;
                        ++n5;
                        continue;
                    }
                    if (n5 == string5.length() - 1) {
                        if (!bl) {
                            string6 = string6 + c5;
                        } else if (c5 != c) {
                            string6 = string6 + c5;
                        }
                        arrayList.add(string6);
                        n2 += ++n5;
                        bl3 = true;
                        break;
                    }
                    if (string5.charAt(n5 + 1) != c || string5.charAt(n5 + 1) != c2 || string5.charAt(n5 + 1) != c3) {
                        if (!bl) {
                            string6 = string6 + c5;
                        }
                        ++n5;
                        if (bl4) {
                            bl4 = false;
                            continue;
                        }
                        arrayList.add(string6);
                        n2 += n5;
                        bl3 = true;
                        break;
                    }
                    if (!bl) {
                        string6 = string6 + c5;
                        bl4 = true;
                    } else if (!bl4) {
                        string6 = string6 + c5;
                        bl4 = true;
                    } else {
                        bl4 = false;
                    }
                    ++n5;
                }
                if (bl3) continue;
                arrayList.add(string6);
                n2 += n5;
                continue;
            }
            if (c4 == ' ' || c4 == '\t' || c4 == '\f' || c4 == '\r' || c4 == '\n') {
                if (bl2) {
                    if (string4.length() != 0) {
                        arrayList.add(string4);
                    }
                    string4 = new String();
                    ++n2;
                    continue;
                }
                bl2 = true;
                ++n2;
                continue;
            }
            if (!bl2) continue;
            string4 = string4 + c4;
            if (++n2 != n3) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    private void cleaner() {
        this.logFileName = null;
        this.queryChriteria = null;
        this.listOfValidRecords.clear();
        this.queryResult = null;
    }
}

