/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.ITimestampGenerator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;

public class ELFFormatter
extends Formatter {
    private LogManager lmanager = (LogManager)LogManagerUtil.getLogManager();
    private String[] allFields;
    private ITimestampGenerator secureTimestampGenerator;

    public ELFFormatter() {
        String string = this.lmanager.getProperty("iplanet-am-logging-secure-timestamp-generator");
        try {
            Class<?> clazz = Class.forName(string);
            this.secureTimestampGenerator = (ITimestampGenerator)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.error("ELFFormatter: TimeStamp Generator Class not found", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Debug.error("ELFFormatter: Timestamp Generator Couldnot be Instantiated", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Debug.error("ELFFormatter: Timestamp Generator Couldnot be Instantiated", illegalAccessException);
        }
    }

    private void getAllFields() {
        String string = this.lmanager.getProperty("iplanet-am-logging-allfields");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        this.allFields = new String[n];
        n = 0;
        while (stringTokenizer.hasMoreElements()) {
            this.allFields[n++] = stringTokenizer.nextToken().trim();
        }
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + this.allFields[n2] + "\t";
            ++n2;
        }
    }

    public String format(java.util.logging.LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        Map map = ((LogRecord)logRecord).getLogInfoMap();
        try {
            this.getAllFields();
            Set set = this.getSelectedFieldSet();
            String string = "";
            if (this.secureTimestampGenerator != null) {
                string = this.secureTimestampGenerator.getTimestamp();
            }
            stringBuffer.append("\"").append(string).append("\"\t");
            String string2 = this.processString(this.formatMessage(logRecord));
            if (string2.indexOf(32) != -1 || string2.indexOf(9) != -1) {
                stringBuffer.append("\"").append(string2).append("\"\t");
            } else {
                stringBuffer.append(string2).append("\t");
            }
            String string3 = null;
            String string4 = null;
            int n = 2;
            while (n < this.allFields.length) {
                string3 = this.allFields[n];
                if (string3 != null && string3.length() != 0 && set != null && map != null && set.contains(string3)) {
                    string4 = (String)map.get(string3);
                    string4 = string4 != null && string4.length() != 0 ? this.processString(string4) : "Not Available";
                    if (string4.indexOf(32) != -1 || string4.indexOf(9) != -1) {
                        stringBuffer.append("\"").append(string4).append("\"\t");
                    } else {
                        stringBuffer.append(string4).append("\t");
                    }
                } else {
                    stringBuffer.append("-").append("\t");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Debug.error("ELFFormatter: Exception in String handling loop", exception);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String getHead(Handler handler) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#Version: 1.0").append("\n");
        stringBuffer.append("#Fields: ").append(this.constructHeader()).append("\n");
        return stringBuffer.toString();
    }

    public String getTail(Handler handler) {
        return "";
    }

    private String constructHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.allFields.length) {
            stringBuffer.append(this.allFields[n]).append("\t");
            ++n;
        }
        return stringBuffer.toString();
    }

    private Set getSelectedFieldSet() {
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.lmanager.getProperty("iplanet-am-logging-logfields");
        if (string != null && string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            while (stringTokenizer.hasMoreElements()) {
                hashSet.add(stringTokenizer.nextToken());
            }
        }
        return hashSet;
    }

    private String processString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"') {
                stringBuffer.append("\"\"");
                bl = true;
            }
            if (c == '\r') {
                stringBuffer.append("\\\\r");
                bl = true;
            }
            if (c == '\n') {
                stringBuffer.append("\\\\n");
                bl = true;
            }
            if (!bl) {
                stringBuffer.append(c);
            }
            bl = false;
            ++n2;
        }
        return stringBuffer.toString();
    }
}

