/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.iplanet.log.ConnectionException;
import com.iplanet.log.DriverLoadException;
import com.iplanet.log.NullLocationException;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.handlers.FormatterInitException;
import com.sun.identity.log.spi.Debug;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class DBHandler
extends Handler {
    private LogManager lmanager = (LogManager)LogManagerUtil.getLogManager();
    private String driver;
    private String databaseURL;
    private Connection conn = null;
    private String tableName;
    private Formatter formatter;
    private String userName;
    private String password;
    private int recCount = 0;
    private int recCountLimit;
    private String[] recordBuffer;
    private Timer bufferTimer;
    private boolean timeBufferingEnabled = false;
    static /* synthetic */ Class class$com$sun$identity$log$handlers$DBHandler;

    private void configure() throws NullLocationException, FormatterInitException {
        String string;
        String string2 = (class$com$sun$identity$log$handlers$DBHandler == null ? (class$com$sun$identity$log$handlers$DBHandler = DBHandler.class$("com.sun.identity.log.handlers.DBHandler")) : class$com$sun$identity$log$handlers$DBHandler).getName();
        this.setLevel(Level.INFO);
        this.setFilter(null);
        try {
            this.setEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.error(this.tableName + ":DBHandler: unsupportedEncodingException ", unsupportedEncodingException);
        }
        String string3 = this.lmanager.getProperty("iplanet-am-logging-buffer-size");
        if (string3 != null && string3.length() > 0) {
            try {
                this.recCountLimit = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.warning(this.tableName + ":DBHandler: NumberFormatException ", numberFormatException);
                if (Debug.messageEnabled()) {
                    Debug.message(this.tableName + ":DBHandler: Setting buffer size to 1");
                }
                this.recCountLimit = 1;
            }
        } else {
            Debug.warning(this.tableName + ":DBHandler: Invalid buffer size: " + string3);
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler: Setting buffer size to 1");
            }
            this.recCountLimit = 1;
        }
        if ((string = this.lmanager.getProperty("iplanet-am-logging-time-buffering-status")) != null && string.equalsIgnoreCase("ON")) {
            this.timeBufferingEnabled = true;
        }
        this.databaseURL = this.lmanager.getProperty("iplanet-am-logging-location");
        if (this.databaseURL == null || this.databaseURL.length() == 0) {
            throw new NullLocationException("Database URL location is null");
        }
        String string4 = LogManager.FORMATTER;
        if (string4 == null || string4.length() == 0) {
            throw new FormatterInitException("Unable To Initialize DBFormatter");
        }
        this.userName = this.lmanager.getProperty("iplanet-am-logging-db-user");
        if (this.userName == null || this.userName.length() == 0) {
            throw new NullLocationException("userName is null");
        }
        this.password = this.lmanager.getProperty("iplanet-am-logging-db-password");
        if (this.password == null || this.password.length() == 0) {
            throw new NullLocationException("password not provided");
        }
        this.driver = this.lmanager.getProperty("iplanet-am-logging-db-driver");
        if (this.driver == null || this.driver.length() == 0) {
            throw new NullLocationException("driver not provided");
        }
        try {
            Class<?> clazz = Class.forName(string4);
            this.formatter = (Formatter)clazz.newInstance();
            this.setFormatter(this.formatter);
        }
        catch (Exception exception) {
            Debug.error(this.tableName + ":DBHandler: Couldnot load Formatter", exception);
            throw new FormatterInitException("Unable To Initialize DBFormatter " + exception.getMessage());
        }
    }

    private void connectToDatabase(String string, String string2) throws SQLException, ClassNotFoundException, ConnectionException, DriverLoadException {
        try {
            Class.forName(this.driver);
            this.conn = DriverManager.getConnection(this.databaseURL, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.error(this.tableName + ":DBHandler: ClassNotFoundException ", classNotFoundException);
            throw new DriverLoadException(classNotFoundException.getMessage());
        }
        catch (SQLException sQLException) {
            Debug.error(this.tableName + ":DBHandler: ConnectionException:", sQLException);
            throw new ConnectionException(sQLException.getMessage());
        }
    }

    public DBHandler(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.tableName = string = string.replace('.', '_');
        try {
            this.configure();
        }
        catch (NullLocationException nullLocationException) {
            Debug.error(string + ":DBHandler: Null Location", nullLocationException);
        }
        catch (FormatterInitException formatterInitException) {
            Debug.error(string + ":DBHandler: Unable to Initialize formatter", formatterInitException);
        }
        try {
            this.connectToDatabase(this.userName, this.password);
            this.createTable(string);
        }
        catch (SQLException sQLException) {
            Debug.error(string + ":DBHandler: sql operation unsuccessful", sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.error(string + ":DBHandler: Class not found", classNotFoundException);
        }
        catch (ConnectionException connectionException) {
            Debug.error(string + ":DBHandler: Couldnot connect to database", connectionException);
        }
        catch (DriverLoadException driverLoadException) {
            Debug.error(string + ":DBHandler: Couldnot load driver", driverLoadException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.error(string + ":DBHandler: Unsupported Encoding", unsupportedEncodingException);
        }
        this.recordBuffer = new String[this.recCountLimit];
        if (this.timeBufferingEnabled) {
            this.startTimeBufferingThread();
        }
    }

    public synchronized void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        this.recordBuffer[this.recCount] = string = this.getFormatter().format(logRecord);
        ++this.recCount;
        if (this.recCount == this.recCountLimit) {
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler:.publish(): got " + this.recCount + " records, writing all");
            }
            this.flush();
        }
    }

    private String getColString() {
        String string = this.getFormatter().getHead(this);
        if (Debug.messageEnabled()) {
            Debug.message("cols = " + string);
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("insert into ").append(this.tableName).append(" (").append(string).append(")").append(" values (");
        return stringBuffer.toString();
    }

    public synchronized void flush() {
        block19: {
            if (this.recCount <= 0) {
                if (Debug.messageEnabled()) {
                    Debug.message(this.tableName + ":DBHandler.flush: no records in buffer to write");
                }
                return;
            }
            if (this.conn == null) {
                Debug.error(this.tableName + ":DBHandler: Connection is null");
                this.recCount = 0;
                return;
            }
            String string = this.getTableName();
            if (string == null) {
                Debug.error(string + ":DBHandler:NullLocationException: table name is null");
                this.recCount = 0;
                return;
            }
            Statement statement = null;
            try {
                statement = this.conn.createStatement();
            }
            catch (SQLException sQLException) {
                Debug.error(string + ":DBHandler: SQLException ", sQLException);
                this.recCount = 0;
                return;
            }
            String string2 = null;
            if (Debug.messageEnabled()) {
                Debug.message(string + ":DBHandler.flush: writing buffered records");
            }
            int n = 0;
            while (n < this.recCount) {
                string2 = this.recordBuffer[n];
                if (Debug.messageEnabled()) {
                    Debug.message("values = " + string2);
                }
                StringBuffer stringBuffer = new StringBuffer(2000);
                stringBuffer.append(this.getColString()).append(string2).append(")");
                String string3 = stringBuffer.toString();
                if (Debug.messageEnabled()) {
                    Debug.message(string + ":DBHandler:insertString is: " + string3);
                }
                try {
                    statement.executeUpdate(string3);
                }
                catch (SQLException sQLException) {
                    if (Debug.warningEnabled()) {
                        Debug.warning(string + ":DBHandler: SQLException: ", sQLException);
                        Debug.warning(string + ":DBHandler: Table might have been deleted. " + " Trying to recreate table: " + string);
                    }
                    try {
                        this.createTable(string);
                        statement.executeUpdate(string3);
                    }
                    catch (SQLException sQLException2) {
                        Debug.error(string + ":DBHandler: SQLException ", sQLException2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Debug.error(string + ":DBHandler: UnsupportedEncodingException ", unsupportedEncodingException);
                    }
                }
                ++n;
            }
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                if (!Debug.warningEnabled()) break block19;
                Debug.warning(string + ":DBHandler: SQLException: ", sQLException);
            }
        }
        this.recCount = 0;
    }

    public void close() {
        this.flush();
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                Debug.error(this.tableName + ":DBHandler: Unable To Close Connection", sQLException);
            }
        }
        this.stopBufferTimer();
    }

    private void setTableName(String string) {
        this.tableName = string;
    }

    private String getTableName() {
        return this.tableName;
    }

    private void createTable(String string) throws SQLException, UnsupportedEncodingException {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            if (this.driver.toLowerCase().indexOf("oracle") != -1) {
                stringBuffer.append("select count(table_name) from all_tables where table_name = ");
                stringBuffer.append("'").append(new String(string.getBytes("UTF-8")).toUpperCase()).append("'");
            } else if (this.driver.toLowerCase().indexOf("mysql") != -1) {
                bl = true;
                stringBuffer.append("show tables like ");
                stringBuffer.append("'").append(new String(string.getBytes("UTF-8")).toUpperCase()).append("'");
            } else {
                Debug.error(string + ":DBHandler: createTable non supported driver: " + this.driver);
                return;
            }
            stringArray = this.conn.createStatement();
            ResultSet resultSet = stringArray.executeQuery(stringBuffer.toString());
            if (bl) {
                String string2 = null;
                while (resultSet.next()) {
                    string2 = resultSet.getString(1);
                }
                if (string2 != null && string2.equalsIgnoreCase(string)) {
                    return;
                }
            } else {
                int n = 0;
                while (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
                if (n == 1) {
                    return;
                }
            }
        }
        catch (SQLException sQLException) {
            Debug.error(string + ":DBHandler: SQLException ", sQLException);
            throw new SQLException(sQLException.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.error(string + ":DBHandler: UnsupportedEncodingException ", unsupportedEncodingException);
            throw new UnsupportedEncodingException(unsupportedEncodingException.getMessage());
        }
        stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("create table ").append(new String(string.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.error(string + ":DBHandler: unsupported encoding exception uee", unsupportedEncodingException);
        }
        stringBuffer.append(" (time varchar(30), ");
        if (bl) {
            stringBuffer.append(" data varchar(255), ");
        } else {
            stringBuffer.append(" data varchar(1024), ");
        }
        stringArray = this.getAllFields();
        int n = 0;
        n = 2;
        while (n < stringArray.length - 1) {
            stringBuffer.append(stringArray[n]).append(" varchar (255), ");
            ++n;
        }
        stringBuffer.append(stringArray[n]).append(" varchar (255)) ");
        String string3 = stringBuffer.toString();
        try {
            Statement statement = this.conn.createStatement();
            if (Debug.messageEnabled()) {
                Debug.message(string + ":DBHandler: the query string for creating is " + string3);
            }
            statement.executeUpdate(string3);
            statement.close();
        }
        catch (SQLException sQLException) {
            Debug.error(string + ":DBHandler: SQLException ", sQLException);
            throw new SQLException(sQLException.getMessage());
        }
    }

    private String[] getAllFields() {
        String string = this.lmanager.getProperty("iplanet-am-logging-allfields");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n++] = stringTokenizer.nextToken().trim();
        }
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + stringArray[n2] + "\t";
            ++n2;
        }
        return stringArray;
    }

    private void startTimeBufferingThread() {
        String string = this.lmanager.getProperty("iplanet-am-logging-buffer-time-in-seconds");
        long l = string != null || string.length() != 0 ? Long.parseLong(string) : 3600L;
        l *= 1000L;
        if (this.bufferTimer == null) {
            this.bufferTimer = new Timer();
            this.bufferTimer.scheduleAtFixedRate((TimerTask)new TimeBufferingTask(), l, l);
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler: Time Buffering Thread Started");
            }
        }
    }

    private void stopBufferTimer() {
        if (this.bufferTimer != null) {
            this.bufferTimer.cancel();
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler: Buffer Timer Stopped");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TimeBufferingTask
    extends TimerTask {
        private TimeBufferingTask() {
        }

        public void run() {
            if (Debug.messageEnabled()) {
                Debug.message(DBHandler.this.tableName + ":DBHandler:TimeBufferingTask.run() called");
            }
            DBHandler.this.flush();
        }
    }
}

