/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.cli;

import com.sun.identity.log.LogReader;
import com.sun.identity.log.secure.SecureLogHelper;
import com.sun.identity.log.secure.VerifierList;
import com.sun.identity.log.spi.CMSAuthorizer;
import com.sun.identity.log.spi.CMSTokenProvider;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.IVerifierOutput;
import com.sun.identity.log.spi.VerifierAction;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.util.Password;

public class CMSArchiveVerify {
    private static String PREFIX = "_secure.";
    private String curMAC = null;
    private String prevSignature = null;
    private IVerifierOutput result;
    private boolean verified = true;
    private SecureLogHelper helper;
    private Password logPassword;
    private Password verPassword;
    private String name;
    private static ResourceBundle bundle = null;
    static final int INVALID = 0;
    static final int LOGNAME = 1;
    static final int PATH = 2;
    static final int USERNAME = 3;
    static final int PASSWORD = 4;
    static Map OPTIONS = new HashMap();

    static int getToken(String string) {
        try {
            return (Integer)OPTIONS.get(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println(bundle.getString("usage"));
            System.exit(1);
        }
        if (!stringArray[0].equals("-commandfile")) {
            // empty if block
        }
        if (stringArray.length != 8) {
            System.err.println(bundle.getString("usage"));
            System.exit(1);
        }
        CMSArchiveVerify.runCommand(stringArray);
    }

    private static void runCommand(String[] stringArray) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            int n5 = 0;
            while (n5 < stringArray.length) {
                int n6 = CMSArchiveVerify.getToken(stringArray[n5]);
                switch (n6) {
                    case 1: {
                        n = ++n5;
                        break;
                    }
                    case 2: {
                        n2 = ++n5;
                        break;
                    }
                    case 3: {
                        n3 = ++n5;
                        break;
                    }
                    case 4: {
                        n4 = ++n5;
                        break;
                    }
                    default: {
                        throw new Exception(bundle.getString("invalidOpt"));
                    }
                }
            }
            CMSArchiveVerify cMSArchiveVerify = new CMSArchiveVerify();
            cMSArchiveVerify.verifyArchive(stringArray[n], stringArray[n2], stringArray[n3], stringArray[n4]);
        }
        catch (Exception exception) {
            if (exception.getMessage() != null) {
                System.err.println(exception.getMessage());
            }
            System.err.println(bundle.getString("usage"));
            System.exit(1);
        }
    }

    private boolean verifyLogRecord(String[] stringArray, int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < stringArray.length - 2) {
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        this.curMAC = new String(stringArray[n]);
        this.verified = this.helper.verifyMAC(stringBuffer.toString(), SecureLogHelper.toByteArray(this.curMAC));
        return this.verified;
    }

    private boolean verifySignature(String[] stringArray, int n, int n2) throws Exception {
        byte[] byArray;
        String string = new String(stringArray[n]);
        byte[] byArray2 = SecureLogHelper.toByteArray(this.curMAC);
        if (this.prevSignature == null || this.prevSignature.equals("")) {
            byArray = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        } else {
            byArray = new byte[byArray2.length + SecureLogHelper.toByteArray(this.prevSignature).length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(SecureLogHelper.toByteArray(this.prevSignature), 0, byArray, byArray2.length, SecureLogHelper.toByteArray(this.prevSignature).length);
        }
        if (n2 != 0) {
            this.prevSignature = string;
        }
        this.verified = this.helper.verifySignature(SecureLogHelper.toByteArray(string), byArray);
        return this.verified;
    }

    public boolean verifyArchive(String string, String string2, String string3, String string4) throws Exception {
        TreeMap treeMap;
        Password password;
        String string5 = string;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            try {
                password = new Password(new String(messageDigest.digest(Password.charToByte((char[])string4.toCharArray())), "UTF-8").toCharArray());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                password = new Password(new String(messageDigest.digest(Password.charToByte((char[])string4.toCharArray()))).toCharArray());
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            password = new Password(string4.toCharArray());
        }
        CMSTokenProvider cMSTokenProvider = new CMSTokenProvider();
        Object object = cMSTokenProvider.createToken(string3, string4);
        CMSAuthorizer cMSAuthorizer = new CMSAuthorizer();
        if (!cMSAuthorizer.isAuthorized(string, "READ", object)) {
            System.err.println("Error in Authorization");
            System.exit(1);
        }
        VerifierList verifierList = new VerifierList();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        if ((treeMap = verifierList.getKeysAndFiles(new File(string2), PREFIX + this.name)).size() == 0) {
            Debug.message(" Verifying Archive:-LogVerifier::verifyArchive::no files to verify");
            return VerifierAction.doVerifierAction(string5, this.verified);
        }
        Object[] objectArray = treeMap.keySet().toArray();
        String string6 = new String();
        CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues("/tmp");
        int n = 1;
        while (n < objectArray.length) {
            this.helper = new SecureLogHelper(initializationValues);
            Vector vector = (Vector)treeMap.get(objectArray[n]);
            string6 = ((String)objectArray[n]).substring(((String)objectArray[n]).indexOf("."));
            string6 = "ver" + string6;
            this.helper.initializeVerifier(string2 + string6, password, password);
            this.curMAC = null;
            this.prevSignature = null;
            int n2 = 0;
            while (n2 < vector.size()) {
                int n3 = 0;
                String[][] stringArray = LogReader.read((String)vector.elementAt(n2), object);
                if (stringArray != null || stringArray.length != 0) {
                    Vector<String> vector2 = new Vector<String>(stringArray[0].length);
                    int n4 = 0;
                    while (n4 < stringArray[0].length) {
                        vector2.add(stringArray[0][n4]);
                        ++n4;
                    }
                    int n5 = -1;
                    int n6 = -1;
                    String string7 = "Signature";
                    String string8 = "MAC";
                    int n7 = 0;
                    while (n7 < vector2.size()) {
                        if (((String)vector2.get(n7)).equalsIgnoreCase(string7)) {
                            n5 = n7;
                            break;
                        }
                        ++n7;
                    }
                    int n8 = 0;
                    while (n8 < vector2.size()) {
                        if (((String)vector2.get(n8)).equalsIgnoreCase(string8)) {
                            n6 = n8;
                            break;
                        }
                        ++n8;
                    }
                    if (n5 == -1 || n6 == -1) {
                        Debug.error("Could not locate mac and sign header");
                        return VerifierAction.doVerifierAction(string5, this.verified);
                    }
                    int n9 = 1;
                    while (n9 < stringArray.length) {
                        if (stringArray[n9][n5].equals("-")) {
                            this.verified = this.verifyLogRecord(stringArray[n9], n6);
                            if (!this.verified) {
                                Debug.error("Log Record Verification Failed in file:" + (String)vector.elementAt(n2) + " at record no. " + n9);
                                break;
                            }
                            if (Debug.messageEnabled()) {
                                Debug.message("Log Record Verification Succeeded in file:" + (String)vector.elementAt(n2) + "at record no." + n9);
                            }
                        } else {
                            n3 = stringArray.length - 1 - n9;
                            this.verified = this.verifySignature(stringArray[n9], n5, n3);
                            if (!this.verified) {
                                Debug.error("Signature Verification Failed in file:" + (String)vector.elementAt(n2) + " at record no. " + n9);
                                break;
                            }
                            if (Debug.messageEnabled()) {
                                Debug.message("Log Signature Verification Succeeded in file:" + (String)vector.elementAt(n2) + "at record no." + n9);
                            }
                        }
                        ++n9;
                    }
                } else {
                    Debug.error("LogVerifier::verifyArchive::Empty return from read of " + (String)vector.elementAt(n2));
                }
                ++n2;
            }
            this.helper.reinitializeVerifier(string2 + string6, password);
            ++n;
        }
        return VerifierAction.doVerifierAction(string5, this.verified);
    }

    static {
        Locale locale = Locale.getDefault();
        bundle = ResourceBundle.getBundle("isVerifierCli", locale);
        OPTIONS.put("-logname", new Integer(1));
        OPTIONS.put("-path", new Integer(2));
        OPTIONS.put("-username", new Integer(3));
        OPTIONS.put("-password", new Integer(4));
    }
}

