/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.log.spi.Debug;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;

public class LogRecord
extends java.util.logging.LogRecord {
    private Map logInfoMap = new HashMap();

    public LogRecord(Level level, String string) {
        super(level, string);
    }

    public LogRecord(Level level, String string, Object object) {
        this(level, string);
        SSOToken sSOToken = null;
        if (object instanceof SSOToken) {
            sSOToken = (SSOToken)object;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.addLogInfo("TIME", simpleDateFormat.format(date));
        this.addLogInfo("Data", this.getMessage());
        this.addLogInfo("LogLevel", this.getLevel().toString());
        String string6 = sSOToken.getTokenID().toString();
        try {
            InetAddress inetAddress = sSOToken.getIPAddress();
            if (inetAddress != null) {
                string4 = inetAddress.getHostAddress();
            }
            if ((string5 = sSOToken.getHostName()) == null || string4 != null && string4.equals(string5)) {
                string5 = inetAddress.getHostName();
            }
            if ((string2 = sSOToken.getProperty("cdomain")) == null || string2.length() == 0) {
                string2 = sSOToken.getProperty("Organization");
            }
            string3 = sSOToken.getPrincipal().getName();
        }
        catch (SSOException sSOException) {
            Debug.error("LogRecord: SSOException: " + sSOException.getMessage());
        }
        this.addLogInfo("Domain", string2);
        this.addLogInfo("LoginID", string3);
        this.addLogInfo("IPAddr", string4);
        this.addLogInfo("HostName", string5);
        this.addLogInfo("LoginIDSid", string6);
    }

    public LogRecord(Level level, String string, Hashtable hashtable) {
        this(level, string);
        String string2 = (String)hashtable.get("Domain");
        String string3 = (String)hashtable.get("LoginID");
        String string4 = (String)hashtable.get("IPAddr");
        String string5 = (String)hashtable.get("LoginIDSid");
        String string6 = (String)hashtable.get("ModuleName");
        String string7 = null;
        if (string4 != null) {
            try {
                string7 = InetAddress.getByName(string4).getHostName();
            }
            catch (Exception exception) {
                Debug.error("LogRecord: Unable to get Host for:" + string4);
            }
        }
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.addLogInfo("TIME", simpleDateFormat.format(date));
        this.addLogInfo("Data", this.getMessage());
        this.addLogInfo("LogLevel", this.getLevel().toString());
        this.addLogInfo("Domain", string2);
        this.addLogInfo("LoginID", string3);
        this.addLogInfo("IPAddr", string4);
        this.addLogInfo("HostName", string7);
        this.addLogInfo("LoginIDSid", string5);
        this.addLogInfo("ModuleName", string6);
    }

    public void addLogInfo(String string, Object object) {
        this.logInfoMap.put(string, object);
    }

    public void setLogInfoMap(Map map) {
        this.logInfoMap = map;
    }

    public Map getLogInfoMap() {
        return this.logInfoMap;
    }
}

