/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternMatcherInput;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import netscape.ldap.util.BadFilterException;
import netscape.ldap.util.LDAPFilter;
import netscape.ldap.util.LDAPFilterList;
import netscape.ldap.util.LDAPIntFilterSet;

public class LDAPFilterDescriptor {
    private Vector m_vFilterSet = new Vector();
    private String m_strLine;
    private int m_nLine;
    private String m_strPrefix;
    private String m_strAffix;
    private LDAPIntFilterSet m_tmpFilterSet = null;
    private String m_strLastMatchPattern = null;
    private String m_strLastDelimiter = null;
    private static final int DEFAULT_SCOPE = 2;

    public LDAPFilterDescriptor(String string) throws FileNotFoundException, BadFilterException {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        this.init(bufferedReader);
    }

    public LDAPFilterDescriptor(StringBuffer stringBuffer) throws BadFilterException {
        this.init(stringBuffer);
    }

    public LDAPFilterDescriptor(URL uRL) throws IOException, BadFilterException {
        URLConnection uRLConnection = uRL.openConnection();
        DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        this.init(bufferedReader);
    }

    private BadFilterException MakeException(String string) {
        return new BadFilterException("BadFilterException while creating Filters,\nLine Number: " + this.m_nLine + ",\n --> " + this.m_strLine + "\nThe error is: " + string, this.m_nLine);
    }

    public LDAPFilterList getFilters(String string, String string2) throws IllegalArgumentException {
        Perl5Pattern perl5Pattern;
        string = string.trim();
        string2 = string2.trim();
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("The Tag Pattern can not be null");
        }
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("The Value can not be null");
        }
        LDAPFilterList lDAPFilterList = new LDAPFilterList();
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string2);
        try {
            perl5Pattern = (Perl5Pattern)perl5Compiler.compile(string);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new IllegalArgumentException("The parameter: " + string + " is not valid");
        }
        boolean bl = false;
        int n = 0;
        while (!bl) {
            Vector vector = ((LDAPIntFilterSet)this.m_vFilterSet.elementAt(n)).getFilters(perl5Pattern, patternMatcherInput);
            if (vector.size() > 0) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    LDAPFilter lDAPFilter = (LDAPFilter)((LDAPFilter)vector.elementAt(n2)).clone();
                    lDAPFilter.setupFilter(string2, this.m_strPrefix, this.m_strAffix);
                    bl = true;
                    lDAPFilterList.add(lDAPFilter);
                    ++n2;
                }
                return lDAPFilterList;
            }
            ++n;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void init(Object var1_1) throws BadFilterException {
        var2_2 = "(?:^\\s*#|^\\s*$)";
        var3_3 = "(?:\\s*\"([^\"]*)\"|([^\\s]*))\\s*";
        var4_4 = new Perl5Compiler();
        var7_5 = new Vector<E>(5);
        try {
            var5_6 = (Perl5Pattern)var4_4.compile(var2_2);
            var6_7 = (Perl5Pattern)var4_4.compile(var3_3);
        }
        catch (MalformedPatternException var8_8) {
            System.out.println("FATAL Error, couldn't compile pattern");
            System.out.println("  " + var8_8.getMessage());
            return;
        }
        this.m_nLine = 0;
        try {
            block9: {
                if (!(var1_1 instanceof StringBuffer)) ** GOTO lbl33
                var8_9 = (StringBuffer)var1_1;
                var9_10 = new StringBuffer();
                var10_11 = 0;
                while (var10_11 < var8_9.length()) {
                    if (var8_9.charAt(var10_11) == '\n') {
                        this.m_strLine = var9_10.toString();
                        ++this.m_nLine;
                        this.setFilter(var5_6, var6_7, var7_5);
                        var9_10 = new StringBuffer();
                    } else {
                        var9_10.append(var8_9.charAt(var10_11));
                    }
                    ++var10_11;
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    ++this.m_nLine;
                    this.setFilter(var5_6, var6_7, var7_5);
lbl33:
                    // 2 sources

                    ** while ((this.m_strLine = ((BufferedReader)var1_1).readLine()) != null)
                }
            }
            if (this.m_tmpFilterSet != null) {
                this.m_vFilterSet.addElement(this.m_tmpFilterSet);
            }
        }
        catch (IOException v0) {}
    }

    private void setFilter(Perl5Pattern perl5Pattern, Perl5Pattern perl5Pattern2, Vector vector) throws IOException, BadFilterException {
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        LDAPFilter lDAPFilter = null;
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(this.m_strLine);
        if (!perl5Matcher.contains(patternMatcherInput, (Pattern)perl5Pattern)) {
            patternMatcherInput.setCurrentOffset(patternMatcherInput.getBeginOffset());
            if (!vector.isEmpty()) {
                vector.removeAllElements();
            }
            while (perl5Matcher.contains(patternMatcherInput, (Pattern)perl5Pattern2)) {
                MatchResult matchResult = perl5Matcher.getMatch();
                int n = 1;
                while (n <= 2) {
                    if (matchResult.group(n) != null && !matchResult.group(n).equals("")) {
                        vector.addElement(matchResult.group(n));
                    }
                    ++n;
                }
            }
            switch (vector.size()) {
                case 1: {
                    if (this.m_tmpFilterSet != null) {
                        this.m_vFilterSet.addElement(this.m_tmpFilterSet);
                    }
                    this.m_tmpFilterSet = new LDAPIntFilterSet((String)vector.elementAt(0));
                    break;
                }
                case 2: {
                    if (this.m_strLastMatchPattern != null && this.m_strLastDelimiter != null) {
                        lDAPFilter = new LDAPFilter(this.m_strLastMatchPattern, this.m_strLastDelimiter, (String)vector.elementAt(0), (String)vector.elementAt(1), 2);
                        lDAPFilter.setLine(this.m_nLine);
                        if (this.m_tmpFilterSet != null) {
                            this.m_tmpFilterSet.appendFilter(lDAPFilter);
                            break;
                        }
                        throw this.MakeException("Attempting to add a filter to a null filterset");
                    }
                    throw this.MakeException("Attempting to create a relative filter with no preceeding full filter");
                }
                case 3: {
                    if (this.m_strLastMatchPattern != null && this.m_strLastDelimiter != null) {
                        lDAPFilter = new LDAPFilter(this.m_strLastMatchPattern, this.m_strLastDelimiter, (String)vector.elementAt(0), (String)vector.elementAt(1), (String)vector.elementAt(2));
                        lDAPFilter.setLine(this.m_nLine);
                        if (this.m_tmpFilterSet != null) {
                            this.m_tmpFilterSet.appendFilter(lDAPFilter);
                            break;
                        }
                        throw this.MakeException("Attempting to add a filter to a null filterset");
                    }
                    throw this.MakeException("Attempting to create a relative filter with no preceeding full filter");
                }
                case 4: {
                    lDAPFilter = new LDAPFilter((String)vector.elementAt(0), (String)vector.elementAt(1), (String)vector.elementAt(2), (String)vector.elementAt(3), 2);
                    lDAPFilter.setLine(this.m_nLine);
                    this.m_strLastMatchPattern = (String)vector.elementAt(0);
                    this.m_strLastDelimiter = (String)vector.elementAt(1);
                    if (this.m_tmpFilterSet != null) {
                        this.m_tmpFilterSet.newFilter(lDAPFilter);
                        break;
                    }
                    throw this.MakeException("Attempting to add a filter to a null filterset");
                }
                case 5: {
                    lDAPFilter = new LDAPFilter((String)vector.elementAt(0), (String)vector.elementAt(1), (String)vector.elementAt(2), (String)vector.elementAt(3), (String)vector.elementAt(4));
                    lDAPFilter.setLine(this.m_nLine);
                    this.m_strLastMatchPattern = (String)vector.elementAt(0);
                    this.m_strLastDelimiter = (String)vector.elementAt(1);
                    if (this.m_tmpFilterSet != null) {
                        this.m_tmpFilterSet.newFilter(lDAPFilter);
                        break;
                    }
                    throw this.MakeException("Attempting to add a filter to a null filterset");
                }
                default: {
                    throw this.MakeException("Wrong number of tokens (" + vector.size() + ")");
                }
            }
        }
    }

    public void setFilterAffixes(String string, String string2) {
        this.m_strPrefix = string;
        this.m_strAffix = string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(4000);
        int n = 0;
        while (n < this.m_vFilterSet.size()) {
            stringBuffer.append("Filter Set number: " + n + "\n");
            stringBuffer.append(String.valueOf(((LDAPIntFilterSet)this.m_vFilterSet.elementAt(n)).toString()) + "\n");
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

