/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.um;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Cache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.um.SDKUtils;
import com.sun.identity.um.StoreConnectionIF;
import com.sun.identity.um.UMException;

public class StoreConnectionImpl
implements StoreConnectionIF {
    private static SSOTokenManager tokenManager;
    protected static Object lock;
    protected static boolean isLocal;
    private static Cache scCache;

    private static void checkInitialization() throws SSOException {
        if (tokenManager == null) {
            Object object = lock;
            synchronized (object) {
                if (tokenManager == null) {
                    try {
                        tokenManager = SSOTokenManager.getInstance();
                        scCache = new Cache(1000);
                    }
                    catch (SSOException sSOException) {
                        SDKUtils.debug.error("StoreConnectionImpl: Unable to get SSOTokenManager", (Throwable)sSOException);
                        SDKUtils.debug.error("stacktrace= ", (Throwable)sSOException);
                        throw sSOException;
                    }
                }
            }
        }
    }

    public AMStoreConnection initializeStoreConnection(String string) throws SSOException {
        StoreConnectionImpl.checkInitialization();
        try {
            AMStoreConnection aMStoreConnection = (AMStoreConnection)scCache.get((Object)string);
            if (aMStoreConnection == null) {
                SSOToken sSOToken = tokenManager.createSSOToken(string);
                aMStoreConnection = new AMStoreConnection(sSOToken);
                scCache.put((Object)string, (Object)aMStoreConnection);
                return aMStoreConnection;
            }
        }
        catch (SSOException sSOException) {
            SDKUtils.debug.error("Unable to convert SSOToken: " + string, (Throwable)sSOException);
            throw sSOException;
        }
        SDKUtils.debug.message("Obtained ssotoken: " + string);
        SDKUtils.debug.message("Obtained AMSToreConnection object for SSOToken: " + string);
        return null;
    }

    public String getUserNamingAttribute(String string) throws SSOException {
        AMStoreConnection aMStoreConnection = this.initializeStoreConnection(string);
        return AMStoreConnection.getUserNamingAttribute();
    }

    public String getGroupNamingAttribute(String string) throws SSOException {
        AMStoreConnection aMStoreConnection = this.initializeStoreConnection(string);
        return AMStoreConnection.getGroupNamingAttribute();
    }

    public String getRoleNamingAttribute(String string) throws SSOException {
        AMStoreConnection aMStoreConnection = this.initializeStoreConnection(string);
        return AMStoreConnection.getRoleNamingAttribute();
    }

    public String getFilteredRoleNamingAttribute(String string) throws SSOException {
        AMStoreConnection aMStoreConnection = this.initializeStoreConnection(string);
        return AMStoreConnection.getFilteredRoleNamingAttribute();
    }

    public String getOrganizationNamingAttribute(String string) throws SSOException {
        AMStoreConnection aMStoreConnection = this.initializeStoreConnection(string);
        return AMStoreConnection.getFilteredRoleNamingAttribute();
    }

    public String getOrganizationalUnitNamingAttribute(String string) throws SSOException {
        AMStoreConnection aMStoreConnection = this.initializeStoreConnection(string);
        return AMStoreConnection.getOrganizationalUnitNamingAttribute();
    }

    public String getOrganizationDN(String string, String string2, String string3) throws UMException, SSOException {
        AMStoreConnection aMStoreConnection = this.initializeStoreConnection(string);
        try {
            return aMStoreConnection.getOrganizationDN(string2, string3);
        }
        catch (AMException aMException) {
            throw SDKUtils.convertException(aMException);
        }
    }

    public void checkForLocal() {
        isLocal = true;
    }

    static {
        lock = new Object();
    }
}

