/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchemaImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class ServiceConfig {
    private SSOToken token;
    private ServiceConfigImpl sc;
    private ServiceSchemaImpl ss;
    private ServiceConfigManager scm;

    private ServiceConfig() {
    }

    protected ServiceConfig(ServiceConfigManager serviceConfigManager, ServiceConfigImpl serviceConfigImpl) throws SMSException, SSOException {
        this.scm = serviceConfigManager;
        this.token = serviceConfigManager.getSSOToken();
        this.sc = serviceConfigImpl;
        this.ss = serviceConfigImpl.getServiceSchemaImpl();
    }

    public String getServiceName() {
        return this.scm.getName();
    }

    public String getVersion() {
        return this.scm.getVersion();
    }

    public String getComponentName() {
        return this.sc.getComponentName();
    }

    public int getPriority() {
        return this.sc.getPriority();
    }

    public void setPriority(int n) throws SSOException, SMSException {
        StringBuffer stringBuffer = new StringBuffer(8);
        String[] stringArray = new String[]{stringBuffer.append(n).toString()};
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        sMSEntry.setAttribute("sunsmspriority", stringArray);
        this.saveSMSEntry(sMSEntry);
    }

    public Set getSubConfigNames() throws SMSException {
        return this.sc.getSubConfigNames();
    }

    public Set getSubConfigNames(String string) throws SMSException {
        return this.sc.getSubConfigNames(string);
    }

    public ServiceConfig getSubConfig(String string) throws SSOException, SMSException {
        ServiceConfig serviceConfig = null;
        ServiceConfigImpl serviceConfigImpl = this.sc.getSubConfig(this.token, string);
        if (serviceConfigImpl != null) {
            serviceConfig = new ServiceConfig(this.scm, serviceConfigImpl);
        }
        return serviceConfig;
    }

    public void addSubConfig(String string, String string2, int n, Map map) throws SMSException, SSOException {
        Object object;
        Object object2;
        if (this.sc.isNewEntry()) {
            object2 = new DN(this.sc.getDN()).toRFCString().toLowerCase();
            int n2 = ((String)object2).indexOf((String)(object = "ou=" + this.getVersion().toLowerCase() + ",ou=" + this.getServiceName().toLowerCase() + ",ou=services,")) + ((String)object).length();
            if (n2 == -1) {
                Object[] objectArray = new String[]{string};
                throw new SMSException("amSDK", "sms-invalid-add-sub-config", objectArray);
            }
            String string3 = ((String)object2).substring(n2);
            this.scm.createOrganizationConfig(string3, null);
        }
        object2 = null;
        object2 = string2 != null ? this.ss.getSubSchema(string2) : this.ss.getSubSchema(string);
        if (object2 == null) {
            object = new String[]{string};
            throw new SMSException("amSDK", "sms-invalid-add-sub-config", (Object[])object);
        }
        object = new StringBuffer(8);
        ((StringBuffer)object).append(n);
        CreateServiceConfig.createSubConfigEntry(this.token.getPrincipal(), "ou=" + string + "," + this.sc.getDN(), (ServiceSchemaImpl)object2, string2, ((StringBuffer)object).toString(), map);
    }

    public void removeSubConfig(String string) throws SMSException, SSOException {
        CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(this.token.getPrincipal(), "ou=" + string + "," + this.sc.getDN(), null);
        SMSEntry sMSEntry = cachedSMSEntry.getSMSEntry();
        sMSEntry.delete(this.token.getPrincipal());
        cachedSMSEntry.refresh(sMSEntry);
        CachedSubEntries cachedSubEntries = CachedSubEntries.getInstance(this.sc.getDN());
        cachedSubEntries.remove(string);
    }

    public Map getAttributes() {
        return this.sc.getAttributes();
    }

    public void setAttributes(Map map) throws SMSException, SSOException {
        Object object;
        Map map2 = this.sc.getAttributesWithoutDefaults();
        Iterator iterator = map2.keySet().iterator();
        HashMap hashMap = new HashMap(map);
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (hashMap.containsKey(object)) continue;
            hashMap.put(object, map2.get(object));
        }
        this.ss.validateAttributes(hashMap, true);
        object = this.sc.getSMSEntry();
        SMSUtils.setAttributeValuePairs((SMSEntry)object, hashMap);
        this.saveSMSEntry((SMSEntry)object);
    }

    public void addAttribute(String string, Set hashSet) throws SMSException, SSOException {
        Map map = this.getAttributes();
        HashSet hashSet2 = hashSet;
        Set set = (Set)map.get(string);
        if (set != null) {
            hashSet2 = new HashSet();
            hashSet2.addAll(hashSet);
            hashSet2.addAll(set);
        }
        this.ss.validateAttrValues(string, hashSet2, true);
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        SMSUtils.addAttribute(sMSEntry, string, hashSet2);
        this.saveSMSEntry(sMSEntry);
    }

    public void removeAttribute(String string) throws SMSException, SSOException {
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        SMSUtils.removeAttribute(sMSEntry, string);
        this.saveSMSEntry(sMSEntry);
    }

    public void removeAttributeValues(String string, Set set) throws SMSException, SSOException {
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        SMSUtils.removeAttributeValues(sMSEntry, string, set);
        this.saveSMSEntry(sMSEntry);
    }

    public void replaceAttributeValue(String string, String string2, String string3) throws SMSException, SSOException {
        Map map = this.getAttributes();
        HashSet<String> hashSet = new HashSet<String>();
        Set set = (Set)map.get(string);
        if (set != null) {
            hashSet.addAll(set);
            hashSet.remove(string2);
        }
        hashSet.add(string3);
        this.ss.validateAttrValues(string, hashSet, true);
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        SMSUtils.replaceAttributeValue(sMSEntry, string, string2, string3);
        this.saveSMSEntry(sMSEntry);
    }

    public void replaceAttributeValues(String string, Set set, Set set2) throws SMSException, SSOException {
        Map map = this.getAttributes();
        HashSet hashSet = new HashSet();
        Set set3 = (Set)map.get(string);
        if (set3 != null) {
            hashSet.addAll(set3);
            hashSet.removeAll(set);
        }
        hashSet.addAll(set2);
        this.ss.validateAttrValues(string, hashSet, true);
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        SMSUtils.replaceAttributeValues(sMSEntry, string, set, set2);
        this.saveSMSEntry(sMSEntry);
    }

    public String getDN() {
        return this.sc.getDN();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Service Component name: " + this.getComponentName());
        stringBuffer.append("\n\tAttributes: " + this.getAttributes()).append("\n");
        try {
            Iterator iterator = this.getSubConfigNames().iterator();
            while (iterator.hasNext()) {
                ServiceConfig serviceConfig = this.getSubConfig((String)iterator.next());
                stringBuffer.append(serviceConfig);
            }
        }
        catch (Exception exception) {
            stringBuffer.append(exception.getMessage());
        }
        return stringBuffer.toString();
    }

    void saveSMSEntry(SMSEntry sMSEntry) throws SMSException, SSOException {
        if (sMSEntry.newEntry) {
            CreateServiceConfig.checkBaseNodesForOrg(this.token.getPrincipal(), DNMapper.orgNameToDN(this.sc.getOrganizationName()), this.getServiceName(), this.getVersion());
            sMSEntry.addAttribute("objectclass", "top");
            sMSEntry.addAttribute("objectclass", "sunServiceComponent");
        }
        sMSEntry.save(this.token.getPrincipal());
        this.sc.refresh(sMSEntry);
    }
}

