/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import netscape.ldap.util.DN;

class CachedSubEntries {
    private static final String cachedSubEntriesMutex = "CachedSubEntriesMutex";
    protected static HashMap smsEntries = new HashMap(100);
    protected Set subEntries;
    protected SMSEntry entry;
    protected DN dn;
    protected String notificationID;
    private static Debug debug = SMSEntry.debug;

    private CachedSubEntries(String string) throws SMSException {
        this.entry = CachedSMSEntry.getInstance(SMSEventListenerManager.principal, string, null).getSMSEntry();
        this.dn = new DN(string);
        this.update();
        try {
            Class<?> clazz = Class.forName("com.sun.identity.sm.CachedSubEntries");
            this.notificationID = SMSEventListenerManager.notifyChangesToSubNodes(string, clazz.getDeclaredMethod("update", null), this, null);
        }
        catch (Exception exception) {
            debug.error("CachedSubEntries: unable to register for notifications: ", (Throwable)exception);
        }
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::init: " + string);
        }
    }

    protected Set getSubEntries() throws SMSException {
        if (!SMSEntry.cacheSMSEntries) {
            return this.subEntries("*");
        }
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(this.subEntries);
        return treeSet;
    }

    protected Set getSubEntries(String string) throws SMSException {
        return this.subEntries(string);
    }

    protected void add(String string) {
        this.subEntries.add(string);
    }

    protected void remove(String string) {
        this.subEntries.remove(string);
    }

    protected boolean isEmpty() {
        return this.subEntries.isEmpty();
    }

    protected boolean contains(String string) {
        return this.subEntries.contains(string);
    }

    protected SMSEntry getSMSEntry() {
        return this.entry;
    }

    protected void update() {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::update called for dn: " + this.dn);
        }
        try {
            this.subEntries = this.subEntries("*");
        }
        catch (Exception exception) {
            debug.error("CachedSubEntries:update: ERROR DN: " + this.dn, (Throwable)exception);
        }
    }

    private Set subEntries(String string) throws SMSException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading sub-entries DN: " + this.dn + " pattern: " + string);
        }
        OrderedSet orderedSet = new OrderedSet();
        Iterator iterator = this.entry.subEntries(string, 0, true, true).iterator();
        while (iterator.hasNext()) {
            SMSEntry sMSEntry = (SMSEntry)iterator.next();
            orderedSet.add(new DN(sMSEntry.getDN()).explodeDN(true)[0]);
            if (!sMSEntry.containsAttrValue("objectclass", "sunService") && !sMSEntry.containsAttrValue("objectclass", "sunServiceComponent")) continue;
            CachedSMSEntry.addInstance(sMSEntry);
        }
        return orderedSet;
    }

    protected void finalize() throws Throwable {
        SMSEventListenerManager.removeNotification(this.notificationID);
    }

    static CachedSubEntries getInstance(String string) throws SMSException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::getInstance DN: " + string);
        }
        String string2 = new DN(string).toRFCString().toLowerCase();
        CachedSubEntries cachedSubEntries = null;
        String string3 = cachedSubEntriesMutex;
        synchronized (string3) {
            cachedSubEntries = (CachedSubEntries)smsEntries.get(string2);
            if (cachedSubEntries == null) {
                cachedSubEntries = new CachedSubEntries(string);
                HashMap<String, CachedSubEntries> hashMap = new HashMap<String, CachedSubEntries>(smsEntries);
                hashMap.put(string2, cachedSubEntries);
                smsEntries = hashMap;
            }
        }
        return cachedSubEntries;
    }
}

