/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.plugins;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeDesignator;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.XMLUtils;
import com.sun.identity.saml.plugins.AttributeMapper;
import com.sun.identity.saml.protocol.AttributeQuery;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultAttributeMapper
implements AttributeMapper {
    public String getSSOTokenID(AttributeQuery attributeQuery) {
        if (attributeQuery == null) {
            return null;
        }
        SubjectConfirmation subjectConfirmation = attributeQuery.getSubject().getSubjectConfirmation();
        if (subjectConfirmation == null) {
            return null;
        }
        if (!SAMLUtils.isCorrectConfirmationMethod(subjectConfirmation)) {
            return null;
        }
        Element element = subjectConfirmation.getSubjectConfirmationData();
        return XMLUtils.getElementString(element);
    }

    public Assertion getSSOAssertion(AttributeQuery attributeQuery) {
        if (attributeQuery == null) {
            return null;
        }
        SubjectConfirmation subjectConfirmation = attributeQuery.getSubject().getSubjectConfirmation();
        if (subjectConfirmation == null) {
            return null;
        }
        Element element = subjectConfirmation.getSubjectConfirmationData();
        if (element == null) {
            return null;
        }
        Assertion assertion = null;
        try {
            NodeList nodeList = element.getChildNodes();
            Node node = null;
            int n = 0;
            int n2 = nodeList.getLength();
            while (n < n2) {
                block10: {
                    node = nodeList.item(n);
                    if (node.getNodeType() == 1) {
                        try {
                            assertion = new Assertion((Element)node);
                            if (SAMLUtils.isAuthNAssertion(assertion)) {
                                return assertion;
                            }
                        }
                        catch (SAMLException sAMLException) {
                            if (!SAMLUtils.debug.messageEnabled()) break block10;
                            SAMLUtils.debug.message("DefaultAttributeMapper: SAMLException when trying to obtain Assertion:" + sAMLException);
                        }
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("DefaultAttributeMapper: Exception when parsing the SubjectConfirmationData:", (Throwable)exception);
        }
        return null;
    }

    public List getAttributes(AttributeQuery attributeQuery, String string, SSOToken sSOToken) throws SAMLException {
        Object object;
        if (attributeQuery == null || string == null || sSOToken == null) {
            SAMLUtils.debug.message("DefaultAttributeMapper: null input.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        SAMLServiceManager.SOAPEntry sOAPEntry = (SAMLServiceManager.SOAPEntry)map.get(string);
        Map map2 = sOAPEntry.getAccountMapper().getUser(attributeQuery.getSubject(), string);
        String string2 = (String)map2.get("name");
        if (string2 == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("DefaultAttributeMapper: couldn't map the subject to a local user.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotMapSubject"));
        }
        AMUser aMUser = null;
        try {
            object = new AMStoreConnection(sSOToken);
            aMUser = ((AMStoreConnection)object).getUser(string2);
        }
        catch (SSOException sSOException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("DefaultAttributeMapper: SSOException", (Throwable)sSOException);
            }
            throw new SAMLException(sSOException.getMessage());
        }
        object = new ArrayList();
        Attribute attribute = null;
        ArrayList<Element> arrayList = null;
        String string3 = null;
        String string4 = null;
        Set set = null;
        Iterator iterator = null;
        List list = attributeQuery.getAttributeDesignator();
        if (list == null || list.isEmpty()) {
            String string5 = null;
            try {
                string5 = SAMLUtils.bundle.getString("userServiceNameList");
            }
            catch (MissingResourceException missingResourceException) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("DefaultAttributeMapper: userServiceNameList is not defined.");
                }
                return object;
            }
            if (string5 == null || string5.length() == 0) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("DefaultAttributeMapper: userServiceNameList is empty.");
                }
                return object;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
            Map map3 = null;
            String string6 = null;
            HashSet hashSet = null;
            ServiceSchemaManager serviceSchemaManager = null;
            ServiceSchema serviceSchema = null;
            while (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken();
                hashSet = new HashSet();
                try {
                    serviceSchemaManager = new ServiceSchemaManager(string6, sSOToken);
                    serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
                    if (serviceSchema != null) {
                        hashSet.addAll(serviceSchema.getAttributeSchemaNames());
                    }
                    if ((serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC)) != null) {
                        hashSet.addAll(serviceSchema.getAttributeSchemaNames());
                    }
                    map3 = aMUser.getAttributes(hashSet);
                }
                catch (AMException aMException) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("DefaultAttributeMapper: AMException:", (Throwable)aMException);
                    }
                    throw new SAMLException(aMException.getMessage());
                }
                catch (SSOException sSOException) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("DefaultAttributeMapper: SSOException:", (Throwable)sSOException);
                    }
                    throw new SAMLException(sSOException.getMessage());
                }
                catch (SMSException sMSException) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("DefaultAttributeMapper: SMSException:", (Throwable)sMSException);
                    }
                    throw new SAMLException(sMSException.getMessage());
                }
                Set set2 = map3.keySet();
                String string7 = null;
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    string7 = (String)iterator2.next();
                    set = (Set)map3.get(string7);
                    iterator = set.iterator();
                    arrayList = new ArrayList();
                    while (iterator.hasNext()) {
                        string3 = SAMLUtils.makeStartElementTagXML("AttributeValue", true, true) + (String)iterator.next() + SAMLUtils.makeEndElementTagXML("AttributeValue", true);
                        arrayList.add(XMLUtils.toDOMDocument(string3).getDocumentElement());
                    }
                    if (arrayList.isEmpty()) continue;
                    attribute = new Attribute(string7, string6, arrayList);
                    object.add(attribute);
                }
            }
        } else {
            Iterator iterator3 = list.iterator();
            AttributeDesignator attributeDesignator = null;
            while (iterator3.hasNext()) {
                attributeDesignator = (AttributeDesignator)iterator3.next();
                string4 = attributeDesignator.getAttributeName();
                try {
                    set = aMUser.getAttribute(string4);
                }
                catch (AMException aMException) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("DefaultAttributeMapper: AMException:", (Throwable)aMException);
                    }
                    throw new SAMLException(aMException.getMessage());
                }
                catch (SSOException sSOException) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("DefaultAttributeMapper: SSOException:", (Throwable)sSOException);
                    }
                    throw new SAMLException(sSOException.getMessage());
                }
                iterator = set.iterator();
                arrayList = new ArrayList<Element>();
                while (iterator.hasNext()) {
                    string3 = SAMLUtils.makeStartElementTagXML("AttributeValue", true, true) + (String)iterator.next() + SAMLUtils.makeEndElementTagXML("AttributeValue", true);
                    arrayList.add(XMLUtils.toDOMDocument(string3).getDocumentElement());
                }
                if (arrayList.isEmpty()) continue;
                attribute = new Attribute(string4, attributeDesignator.getAttributeNamespace(), arrayList);
                object.add(attribute);
            }
        }
        return object;
    }
}

