/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.XMLUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubjectConfirmation {
    static SAMLConstants sc;
    private Set _confirmationMethodList = Collections.synchronizedSet(new HashSet());
    private Element _subjectConfirmationData = null;
    private Element _keyInfo = null;

    public SubjectConfirmation(Element element) throws SAMLException {
        Element element2 = element;
        String string = element2.getLocalName();
        if (string == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SubjectConfirmation: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!string.equals("SubjectConfirmation")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SubjectConfirmation: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement"));
        }
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                String string2 = node.getLocalName();
                if (string2.equals("ConfirmationMethod")) {
                    this._confirmationMethodList.add(XMLUtils.getElementValue((Element)node));
                } else if (string2.equals("SubjectConfirmationData")) {
                    if (this._subjectConfirmationData != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SubjectConfirmation: SubjectConfirmationData already parsed");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                    }
                    this._subjectConfirmationData = (Element)node;
                } else if (string2.equals("KeyInfo")) {
                    if (this._keyInfo != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SubjectConfirmation: KeyInfo already parsed");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                    }
                    this._keyInfo = (Element)node;
                } else {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SubjectConfirmation: unsupported element KeyInfo in SubjectConfirmation");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("unsupportedElement"));
                }
            }
            ++n2;
        }
        if (this._confirmationMethodList.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SubjectConfirmation: Mandatory element confirmation method missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    public SubjectConfirmation(String string) throws SAMLException {
        if (string == null || string.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SubjectConfirmation:  null confirmationMethod specified");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._confirmationMethodList.add(string);
    }

    public SubjectConfirmation(Set set) throws SAMLException {
        if (set.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SubjectConfirmation:  No confirmationMethods  in the Set");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._confirmationMethodList.addAll(set);
    }

    public boolean addConfirmationMethod(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        this._confirmationMethodList.add(string);
        return true;
    }

    public SubjectConfirmation(Set set, Element element, Element element2) throws SAMLException {
        if (set.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SubjectConfirmation:  No confirmationMethods  in the Set");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._confirmationMethodList.addAll(set);
        this._subjectConfirmationData = element;
        this._keyInfo = element2;
    }

    public Set getConfirmationMethod() {
        return this._confirmationMethodList;
    }

    public Element getSubjectConfirmationData() {
        return this._subjectConfirmationData;
    }

    public boolean setSubjectConfirmationData(Element element) {
        if (element == null) {
            return false;
        }
        this._subjectConfirmationData = element;
        return true;
    }

    public boolean setSubjectConfirmationData(String string) {
        if (string == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(SAMLUtils.makeStartElementTagXML("SubjectConfirmationData", true, true)).append(string).append(SAMLUtils.makeEndElementTagXML("SubjectConfirmationData", true));
        try {
            this._subjectConfirmationData = XMLUtils.toDOMDocument(stringBuffer.toString().trim()).getDocumentElement();
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SubjectConfirmation: exception when setting scDataString.", (Throwable)exception);
            }
            return false;
        }
        return true;
    }

    public Element getKeyInfo() {
        return this._keyInfo;
    }

    public boolean setKeyInfo(Element element) {
        if (element != null) {
            this._keyInfo = element;
            return true;
        }
        return false;
    }

    public boolean equals(SubjectConfirmation subjectConfirmation) {
        boolean bl = true;
        boolean bl2 = true;
        if (subjectConfirmation != null) {
            String string;
            Object object;
            Set set = subjectConfirmation.getConfirmationMethod();
            int n = set.size();
            if (n != this._confirmationMethodList.size()) {
                bl = false;
            } else {
                object = set.iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    if (this._confirmationMethodList.contains(string)) continue;
                    bl = false;
                    break;
                }
            }
            object = subjectConfirmation.getSubjectConfirmationData();
            if (this._subjectConfirmationData != null) {
                if (object == null) {
                    bl2 = false;
                } else {
                    string = this.printSCData(this._subjectConfirmationData, true, true);
                    String string2 = this.printSCData((Element)object, true, true);
                    bl2 = string.equals(string2);
                }
            } else if (object != null) {
                bl2 = false;
            }
            return bl && bl2;
        }
        return false;
    }

    private String printSCData(Element element, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(SAMLUtils.makeStartElementTagXML("SubjectConfirmationData", bl, bl2));
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            stringBuffer.append(XMLUtils.print(nodeList.item(n)));
            ++n;
        }
        stringBuffer.append(SAMLUtils.makeEndElementTagXML("SubjectConfirmationData", bl));
        return stringBuffer.toString();
    }

    public String toString() {
        String string = this.toString(true, false);
        return string;
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = SAMLUtils.makeStartElementTagXML("SubjectConfirmation", bl, bl2);
        stringBuffer.append(string).append("\n");
        if (this._confirmationMethodList.size() > 0) {
            Iterator iterator = this._confirmationMethodList.iterator();
            while (iterator.hasNext()) {
                string = SAMLUtils.makeStartElementTagXML("ConfirmationMethod", bl, false);
                stringBuffer.append(string).append((String)iterator.next());
                string = SAMLUtils.makeEndElementTagXML("ConfirmationMethod", bl);
                stringBuffer.append(string);
            }
        }
        if (this._subjectConfirmationData != null) {
            stringBuffer.append(this.printSCData(this._subjectConfirmationData, bl, false));
        }
        if (this._keyInfo != null) {
            stringBuffer.append(XMLUtils.print(this._keyInfo));
        }
        string = SAMLUtils.makeEndElementTagXML("SubjectConfirmation", bl);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

