/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.Action;
import com.sun.identity.saml.assertion.Evidence;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AuthorizationDecisionStatement
extends SubjectStatement {
    private String _resource = null;
    private int _decision = -1;
    private List _action = null;
    private Evidence _evidence = null;

    protected AuthorizationDecisionStatement() {
    }

    public AuthorizationDecisionStatement(Element element) throws SAMLException {
        Object object;
        Object object2;
        if (element == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement: null input.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean bl = SAMLUtils.checkStatement(element, "AuthorizationDecisionStatement");
        if (!bl) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement: Wrong input.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        int n = 0;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        n = 0;
        while (n < n2) {
            object2 = namedNodeMap.item(n);
            if (object2.getNodeType() == 2) {
                String string = object2.getLocalName();
                if (string == null || string.equals("")) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AuthorizationDecisionStatement: Attribute name is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                }
                if (string.equals("Resource")) {
                    this._resource = ((Attr)object2).getValue().trim();
                    if (this._resource == null || this._resource.equals("")) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("AuthorizationDecisionStatement: Resource is null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttributeValue"));
                    }
                } else if (string.equals("Decision")) {
                    object = ((Attr)object2).getValue().trim();
                    if (object == null || ((String)object).equals("")) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("AuthorizationDecisionStatement: Decision is null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttributeValue"));
                    }
                    if (((String)object).equals("Permit")) {
                        this._decision = 1;
                    } else if (((String)object).equals("Deny")) {
                        this._decision = 2;
                    } else if (((String)object).equals("Indeterminate")) {
                        this._decision = 3;
                    } else {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("AuthorizationDecisionStatement: The type of decision is illegal!");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                    }
                }
            }
            ++n;
        }
        if (this._resource == null || this._resource.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement: Resource is required attribute.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        if (this._decision == -1) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement: Decision is required attribute.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        object2 = element.getChildNodes();
        int n3 = object2.getLength();
        if (n3 > 0) {
            n = 0;
            while (n < n3) {
                object = object2.item(n);
                if (object.getNodeType() == 1) {
                    String string = object.getLocalName();
                    String string2 = object.getNamespaceURI();
                    if (string == null || string.equals("") || string2 == null || string2.equals("")) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("AuthorizationDecisionStatement: The tag name or tag namespace of child element is either null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                    }
                    if (string.equals("Subject") && string2.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        if (this._subject != null) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("AuthorizationDecisionStatement: should only contain one subject");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                        }
                        this._subject = new Subject((Element)object);
                    } else if (string.equals("Action") && string2.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        if (this._action == null) {
                            this._action = new ArrayList();
                        }
                        if (!this._action.add(new Action((Element)object))) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("AuthenticationStatment: failed to add to the AuthorityBinding list.");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("addListError"));
                        }
                    } else if (string.equals("Evidence") && string2.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        this._evidence = new Evidence((Element)object);
                    } else {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("AuthorizationDecisionStatement: wrong element:" + string);
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                    }
                }
                ++n;
            }
        }
        if (this._subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement: should contain exactly one subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        if (this._action == null || this._action.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement: should at least contain one Action.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    public AuthorizationDecisionStatement(Subject subject, String string, int n, List list, Evidence evidence) throws SAMLException {
        if (subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement:missing the subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        this._subject = subject;
        if (string == null || string.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement: resource is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        this._resource = string;
        if (n < 1 || n > 3) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement:The type of decision is illegal.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        this._decision = n;
        if (list == null || list.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement: Action is required.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        if (this._action == null) {
            this._action = new ArrayList();
        }
        this._action = list;
        this._evidence = evidence;
    }

    public AuthorizationDecisionStatement(Subject subject, String string, int n, List list) throws SAMLException {
        if (subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement:missing the subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        this._subject = subject;
        if (string == null || string.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement: resource is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        this._resource = string;
        if (n <= 1 || n >= 3) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement:The type of decision is illegal.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        this._decision = n;
        if (list == null || list.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionStatement: Action is required.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        if (this._action == null) {
            this._action = new ArrayList();
        }
        this._action = list;
    }

    public List getAction() {
        return this._action;
    }

    public Evidence getEvidence() {
        return this._evidence;
    }

    public String getResource() {
        return this._resource;
    }

    public int getDecision() {
        return this._decision;
    }

    public int getStatementType() {
        return 2;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "saml:";
        }
        if (bl2) {
            string2 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string).append("AuthorizationDecisionStatement").append(string2).append(" Resource=\"").append(this._resource).append("\" Decision=\"").append(this.decisionTypeConvert(this._decision)).append("\">\n");
        stringBuffer.append(this._subject.toString(bl, false));
        Iterator iterator = this._action.iterator();
        while (iterator.hasNext()) {
            Action action = (Action)iterator.next();
            stringBuffer.append(action.toString(bl, false));
        }
        if (this._evidence != null) {
            stringBuffer.append(this._evidence.toString(bl, false));
        }
        stringBuffer.append("</").append(string).append("AuthorizationDecisionStatement>\n");
        return stringBuffer.toString();
    }

    private String decisionTypeConvert(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "Permit";
                break;
            }
            case 2: {
                string = "Deny";
                break;
            }
            case 3: {
                string = "Indeterminate";
            }
        }
        return string;
    }

    public static class DecisionType {
        public static final int PERMIT = 1;
        public static final int DENY = 2;
        public static final int INDETERMINATE = 3;
        public static final int NOT_SUPPORTED = -1;
    }
}

