/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeDesignator {
    protected String _attributeName = null;
    protected String _attributeNameSpace = null;

    protected AttributeDesignator() {
    }

    public AttributeDesignator(Element element) throws SAMLException {
        Object object;
        if (element == null) {
            SAMLUtils.debug.message("AttributeDesignator: Input is null.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("AttributeDesignator")) {
            SAMLUtils.debug.message("AttributeDesignator: wrong input");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        int n = 0;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        n = 0;
        while (n < n2) {
            object = namedNodeMap.item(n);
            if (object.getNodeType() == 2) {
                String string2 = object.getLocalName();
                if (string2 == null || string2.equals("")) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AttributeDesignator:Attribute Name is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                }
                if (string2.equals("AttributeName")) {
                    this._attributeName = ((Attr)object).getValue().trim();
                } else if (string2.equals("AttributeNamespace")) {
                    this._attributeNameSpace = ((Attr)object).getValue().trim();
                }
            }
            ++n;
        }
        if (this._attributeName == null || this._attributeName.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AttributeDesignator: AttributeName is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        if (this._attributeNameSpace == null || this._attributeNameSpace.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AttributeDesignator: AttributeNamespace is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        object = element.getChildNodes();
        int n3 = object.getLength();
        if (n3 > 0) {
            n = 0;
            while (n < n3) {
                Node node = object.item(n);
                if (node.getNodeType() == 1) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AttributeDesignator: illegalinput!");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                ++n;
            }
        }
    }

    public AttributeDesignator(String string, String string2) throws SAMLException {
        if (string == null || string.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AttributeDesignator:AttributeName is required!");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._attributeName = string;
        if (string2 == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AttributeDesignator: AttributeNamespace is required!");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._attributeNameSpace = string2;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public String getAttributeNamespace() {
        return this._attributeNameSpace;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "saml:";
        }
        if (bl2) {
            string2 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string).append("AttributeDesignator ").append(string2).append(" AttributeName=\"").append(this._attributeName).append("\" AttributeNamespace=\"").append(this._attributeNameSpace).append("\" />\n");
        return stringBuffer.toString();
    }
}

