/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Action {
    private String _action = null;
    private String _namespace = "urn:oasis:names:tc:SAML:1.0:action:rwedc-negation";

    public Action(Element element) throws SAMLException {
        Object object;
        if (element == null) {
            SAMLUtils.debug.message("Action: Input is null.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("Action")) {
            SAMLUtils.debug.message("Action: wrong input");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            object = namedNodeMap.item(n2);
            if (object.getNodeType() == 2) {
                String string2 = object.getLocalName();
                if (string2 == null || string2.equals("")) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Action: Attribute Nameis either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                }
                if (string2.equals("Namespace")) {
                    this._namespace = ((Attr)object).getValue().trim();
                }
                if (this._namespace == null || this._namespace.equals("")) {
                    this._namespace = "urn:oasis:names:tc:SAML:1.0:action:rwedc-negation";
                }
            }
            ++n2;
        }
        object = element.getChildNodes();
        int n3 = object.getLength();
        if (n3 > 0) {
            n2 = 0;
            while (n2 < n3) {
                Node node = object.item(n2);
                if (node.getNodeType() == 1) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Action: Wrong input");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                ++n2;
            }
        }
        this._action = XMLUtils.getElementValue(element);
        if (this._action == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Action is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElementValue"));
        }
        if (!this.isValid(this._action, this._namespace)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Action is invalid");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidAction"));
        }
    }

    public Action(String string, String string2) throws SAMLException {
        if (string == null || string.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Action:Take default Attribute Namespace.");
            }
        } else {
            this._namespace = string;
        }
        if (string2 == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Action:Action is null or empty.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._action = string2;
        if (!this.isValid(this._action, this._namespace)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Action is invalid");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidAction"));
        }
    }

    private boolean isValid(String string, String string2) {
        if (string2.equals("urn:oasis:names:tc:SAML:1.0:action:rwedc")) {
            return string.equals("Read") || string.equals("Write") || string.equals("Execute") || string.equals("Delete") || string.equals("Control");
        }
        if (string2.equals("urn:oasis:names:tc:SAML:1.0:action:rwedc-negation")) {
            return string.equals("Read") || string.equals("~Read") || string.equals("Write") || string.equals("~Write") || string.equals("Execute") || string.equals("~Execute") || string.equals("Delete") || string.equals("~Delete") || string.equals("Control") || string.equals("~Control");
        }
        if (string2.equals("urn:oasis:names:tc:SAML:1.0:ghpp")) {
            return string.equals("GET") || string.equals("HEAD") || string.equals("PUT") || string.equals("POST");
        }
        if (string2.equals("urn:oasis:names:tc:SAML:1.0:action:unix")) {
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Actions: Unix file permissions error:" + numberFormatException.getMessage());
                }
                return false;
            }
            int n2 = n / 1000;
            int n3 = n - 1000 * n2;
            int n4 = 0;
            if (n2 == 0 || n2 == 2 || n2 == 4 || n2 == 6) {
                int n5 = 0;
                while (n5 < 3) {
                    n4 = n3 / 10;
                    n2 = n3 - n4 * 10;
                    if (n2 < 0 || n2 > 7) {
                        return false;
                    }
                    n3 = n4;
                    ++n5;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public String getAction() {
        return this._action;
    }

    public String getNameSpace() {
        return this._namespace;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "saml:";
        }
        if (bl2) {
            string2 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string).append("Action ").append(string2).append(" Namespace=\"").append(this._namespace).append("\">");
        stringBuffer.append(this._action);
        stringBuffer.append("</").append(string).append("Action>\n");
        return stringBuffer.toString();
    }
}

