/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml;

import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.XMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.Request;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.servlet.SAMLSOAPReceiver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.messaging.URLEndpoint;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLClient {
    private static void doSSO(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException, SAMLException {
        Object object;
        Object object2;
        if (httpServletRequest == null || httpServletResponse == null || string == null) {
            SAMLUtils.debug.error("SAMLClient:Input parameter is null.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!(string2.equals("samlawareservlet") || string2.equals("samlpostservlet") || string2.equals("samlsoapreceiver"))) {
            SAMLUtils.debug.error("SAMLClient:illegal naming service name.");
            throw new SAMLException(SAMLUtils.bundle.getString("illegalNamingService"));
        }
        SSOToken sSOToken = null;
        try {
            object2 = SSOTokenManager.getInstance();
            sSOToken = object2.createSSOToken(httpServletRequest);
            if (sSOToken == null) {
                SAMLUtils.debug.error("SAMLClient:SSOToken is null.");
                throw new SAMLException(SAMLUtils.bundle.getString("nullSSOToken"));
            }
            if (!object2.isValidToken(sSOToken)) {
                SAMLUtils.debug.error("SAMLClient:SSOToken is invalid.");
                throw new SAMLException(SAMLUtils.bundle.getString("invalidSSOToken"));
            }
        }
        catch (SSOException sSOException) {
            SAMLUtils.debug.error("SAMLClient", (Throwable)sSOException);
            throw new SAMLException("SAMLClient:doSSO:" + sSOException.getMessage());
        }
        object2 = null;
        try {
            object = new SessionID(sSOToken.getTokenID().toString());
            object2 = WebtopNaming.getServiceURL((String)string2, (String)object.getSessionServerProtocol(), (String)object.getSessionServer(), (String)object.getSessionServerPort());
        }
        catch (URLNotFoundException uRLNotFoundException) {
            SAMLUtils.debug.error("SAMLClient", (Throwable)uRLNotFoundException);
            throw new SAMLException(SAMLUtils.bundle.getString("URLNotFoundException"));
        }
        object = new StringBuffer(200);
        String string3 = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier");
        ((StringBuffer)object).append(object2).append("?").append(string3).append("=").append(string);
        httpServletResponse.sendRedirect(((StringBuffer)object).toString());
    }

    public static void doWebArtifact(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, SAMLException {
        SAMLClient.doSSO(httpServletRequest, httpServletResponse, string, "samlawareservlet");
    }

    public static void doWebPOST(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, SAMLException {
        SAMLClient.doSSO(httpServletRequest, httpServletResponse, string, "samlpostservlet");
    }

    public static Assertion getAssertionByArtifact(AssertionArtifact assertionArtifact) throws IOException, SAMLException {
        return SAMLClient.getAssertionByArtifact(assertionArtifact.getAssertionArtifact());
    }

    public static Assertion getAssertionByArtifact(String string) throws IOException, SAMLException {
        Object object;
        Object object2;
        if (string == null || string.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLClient: input is null.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        AssertionArtifact assertionArtifact = new AssertionArtifact(string);
        String string2 = assertionArtifact.getSourceID();
        String string3 = SAMLClient.getSamlSoapUrl(string2);
        URL uRL = null;
        try {
            if (string3 == null) {
                object2 = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-instance-list");
                if (object2 == null || object2.size() == 0) {
                    throw new SAMLException(SAMLUtils.bundle.getString("instancemapNull"));
                }
                String string4 = (String)object2.get(string2);
                if (string4 == null || string4.equals("")) {
                    throw new SAMLException(SAMLUtils.bundle.getString("instanceNotFound"));
                }
                object = new URL(string4);
                uRL = WebtopNaming.getServiceURL((String)"samlsoapreceiver", (String)((URL)object).getProtocol(), (String)((URL)object).getHost(), (String)Integer.toString(((URL)object).getPort()));
            } else {
                uRL = new URL(string3);
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLClient:SOAPUrl=" + uRL.toString());
            }
        }
        catch (URLNotFoundException uRLNotFoundException) {
            SAMLUtils.debug.error("SAMLClient", (Throwable)uRLNotFoundException);
            throw new SAMLException(SAMLUtils.bundle.getString("URLNotFoundException"));
        }
        if (!SAMLClient.setLocalFlag(uRL)) {
            throw new SAMLException(SAMLUtils.bundle.getString("failSetLocalFlag"));
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAMLClient:getAssertionByArtifact: check localFlag : " + SAMLServiceManager.localFlag);
        }
        object2 = (String)SAMLServiceManager.getAttribute("mysiteid");
        boolean bl = string2.equals(((String)object2).trim());
        if (SAMLServiceManager.localFlag && bl) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLClient:getAssertionByArtifact:call AssertionManager.getAssertion(AssertionArtifact)");
            }
            object = AssertionManager.getInstance();
            Assertion assertion = ((AssertionManager)object).getAssertion(assertionArtifact);
            return assertion;
        }
        object = new String[]{string};
        List list = null;
        list = bl && string3 == null ? SAMLClient.artifactQueryHandler((String[])object, uRL.toString()) : SAMLClient.artifactQueryHandler((String[])object, null);
        if (list == null || list.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLClient:getAssertionByArtifact:returned assertion list is null.");
            }
            return null;
        }
        return (Assertion)list.get(0);
    }

    private static String getSamlSoapUrl(String string) {
        String string2 = null;
        try {
            Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
            if (map == null) {
                SAMLUtils.debug.error("SAMLClient:Partner URL is null.");
                return null;
            }
            SAMLServiceManager.SOAPEntry sOAPEntry = (SAMLServiceManager.SOAPEntry)map.get(string);
            if (sOAPEntry != null) {
                string2 = sOAPEntry.getSOAPUrl();
            } else if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLClient: " + string + " is not on trusted site list.");
            }
            return string2;
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLClient: ", (Throwable)exception);
            return null;
        }
    }

    public static boolean setLocalFlag(URL uRL) {
        if (uRL == null) {
            SAMLUtils.debug.error("SAMLClient:setLocalFlag has null input.");
            return false;
        }
        try {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("in setLocalFlag(), url : " + uRL.toString());
                SAMLUtils.debug.message("SAMLSOAPReceiver.localSAMLServiceID : " + SAMLSOAPReceiver.localSAMLServiceID);
            }
            if (SAMLSOAPReceiver.localSAMLServiceID != null) {
                URL uRL2 = new URL(SAMLSOAPReceiver.localSAMLServiceID);
                if (uRL.getHost().equalsIgnoreCase(uRL2.getHost()) && uRL.getPort() == uRL2.getPort()) {
                    SAMLServiceManager.localFlag = true;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLClient::setLocalFlag:: ", (Throwable)exception);
            return false;
        }
        SAMLServiceManager.localFlag = false;
        return true;
    }

    private static SOAPMessage createSOAPMessage(Request request) throws SAMLException {
        if (request == null) {
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        SOAPMessage sOAPMessage = null;
        try {
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-Type", "text/xml");
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("<").append("soap-env").append(":Envelope").append(" ").append("xmlns:").append("soap-env").append("=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\">").append("\n").append("<").append("soap-env").append(":Body>").append("\n");
            StringBuffer stringBuffer2 = new StringBuffer(100);
            stringBuffer2.append("</").append("soap-env").append(":Body>").append("\n").append("</").append("soap-env").append(":Envelope>").append("\n");
            StringBuffer stringBuffer3 = new StringBuffer(300);
            stringBuffer3.append((Object)stringBuffer).append(request.toString(true, true)).append((Object)stringBuffer2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(stringBuffer3.toString().getBytes("UTF-8"));
            MessageFactory messageFactory = MessageFactory.newInstance();
            sOAPMessage = messageFactory.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            throw new SAMLException(exception.getMessage());
        }
        return sOAPMessage;
    }

    private static URLEndpoint createSOAPReceiverUrl(SAMLServiceManager.SOAPEntry sOAPEntry, String string) throws IOException, SAMLException {
        if (sOAPEntry == null || string == null || string.equals("")) {
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string2 = sOAPEntry.getAuthType();
        URLEndpoint uRLEndpoint = null;
        int n = -1;
        n = string.indexOf("//");
        if (n == -1) {
            SAMLUtils.debug.error("SAMLClient:createSOAPReceiverUrl:Illegal format of input parameter.");
            throw new SAMLException(SAMLUtils.bundle.getString("illegalFormatSOAPUrl"));
        }
        String string3 = string.substring(0, n - 1);
        if (string2.equalsIgnoreCase("BASICAUTH") || string2.equalsIgnoreCase("NOAUTH")) {
            if (!string3.equals("http")) {
                if (SAMLServiceManager.localFlag) {
                    SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("mismatchAuthTypeandProtocol"));
                }
                throw new SAMLException(SAMLUtils.bundle.getString("mismatchAuthTypeandProtocol"));
            }
        } else if (string2.equalsIgnoreCase("SSLWITHBASICAUTH") || string2.equalsIgnoreCase("SSL")) {
            if (!string3.equals("https")) {
                if (SAMLServiceManager.localFlag) {
                    SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("mismatchAuthTypeandProtocol"));
                }
                throw new SAMLException(SAMLUtils.bundle.getString("mismatchAuthTypeandProtocol"));
            }
        } else {
            if (SAMLServiceManager.localFlag) {
                SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("wrongAuthType"));
            }
            throw new SAMLException(SAMLUtils.bundle.getString("wrongAuthType"));
        }
        if (string2.equalsIgnoreCase("BASICAUTH") || string2.equalsIgnoreCase("SSLWITHBASICAUTH")) {
            Map map = SAMLServiceManager.getSAMLUser(sOAPEntry.getUser());
            String string4 = (String)map.get("iplanet-am-saml-user");
            String string5 = (String)map.get("iplanet-am-saml-password");
            if (string4 == null || string5 == null) {
                SAMLUtils.debug.error("SAMLClient:createSOAPReceiverUrl:PartnerSite required basic authentication. But the user name or password used for authentication is null.");
                throw new SAMLException(SAMLUtils.bundle.getString("wrongConfigBasicAuth"));
            }
            String string6 = string.substring(0, n + 2) + string4 + ":" + string5 + "@" + string.substring(n + 2);
            uRLEndpoint = new URLEndpoint(string6);
        } else {
            uRLEndpoint = new URLEndpoint(string);
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Sending message to URL: " + uRLEndpoint.getURL());
        }
        if (SAMLServiceManager.localFlag) {
            SAMLUtils.access(Level.INFO, SAMLUtils.bundle.getString("SOAPReceiverURL") + uRLEndpoint.getURL());
        }
        return uRLEndpoint;
    }

    private static Response getSAMLResponse(String string) throws IOException, SAMLException {
        if (string == null || string.equals("")) {
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        Response response = null;
        Document document = XMLUtils.toDOMDocument(string);
        Element element = document.getDocumentElement();
        String string2 = element.getLocalName();
        if (string2 == null || string2.equals("")) {
            SAMLUtils.debug.error("Missing Envelope tag.");
            throw new SAMLException(SAMLUtils.bundle.getString("missingSOAPEnvTag"));
        }
        if (!string2.equals("Envelope") || !element.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            SAMLUtils.debug.error("Wrong Envelope tag or namespace.");
            throw new SAMLException(SAMLUtils.bundle.getString("wrongSOAPEnvtag"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n <= 0) {
            SAMLUtils.debug.error("Envelope does not contain a SOAP body.");
            throw new SAMLException(SAMLUtils.bundle.getString("missingSOAPBody"));
        }
        String string3 = null;
        String string4 = null;
        Node node = null;
        Node node2 = null;
        int n2 = 0;
        while (n2 < n) {
            node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                string3 = node.getLocalName();
                if (string3 == null || string3.equals("")) {
                    SAMLUtils.debug.error("Missing tag name of child element");
                    throw new SAMLException(SAMLUtils.bundle.getString("missingChildTagName"));
                }
                if (string3.equals("Body")) {
                    NodeList nodeList2 = node.getChildNodes();
                    int n3 = nodeList2.getLength();
                    int n4 = 0;
                    while (n4 < n3) {
                        node2 = nodeList2.item(n4);
                        if (node2.getNodeType() == 1) {
                            string4 = node2.getLocalName();
                            if (string4 == null || string4.equals("")) {
                                SAMLUtils.debug.error("Missing tag name of child element of <SOAP-ENV:Body>");
                                throw new SAMLException(SAMLUtils.bundle.getString("missingChildTagName"));
                            }
                            if (string4.equals("Fault")) {
                                SAMLUtils.debug.error("SOAPFault error.");
                                throw new SAMLException(XMLUtils.print(node2));
                            }
                            if (string4.equals("Response")) {
                                response = new Response((Element)node2);
                                if (SAMLUtils.debug.messageEnabled()) {
                                    SAMLUtils.debug.message("SAML Response:" + response.toString());
                                }
                                break;
                            }
                            SAMLUtils.debug.error("Wrong child element in SOAPBody");
                            throw new SAMLException(SAMLUtils.bundle.getString("wrongSOAPBody"));
                        }
                        ++n4;
                    }
                } else if (string3.equals("Header")) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Inside SOAP Response: SOAP Header");
                    }
                } else {
                    SAMLUtils.debug.error("Wrong child element in Envelope");
                    throw new SAMLException(SAMLUtils.bundle.getString("wrongSOAPElement"));
                }
            }
            ++n2;
        }
        return response;
    }

    private static List getAssertionList(Response response, List list) throws SAMLException {
        if (response == null || list == null) {
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        List list2 = new ArrayList();
        list2 = response.getAssertion();
        if (list2 == null || list2.isEmpty()) {
            if (SAMLServiceManager.localFlag) {
                SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("noAssertioninResponse") + response.getStatus().toString());
            }
            throw new SAMLException(SAMLUtils.displayXML(response.getStatus().toString()));
        }
        if (list2.size() != list.size()) {
            SAMLUtils.debug.error("The SAML response containing assertions <>the number of artifacts in SAML request");
            if (SAMLServiceManager.localFlag) {
                SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("wrongNumberAssertions"));
            }
            throw new SAMLException(SAMLUtils.bundle.getString("wrongNumberAssertions"));
        }
        return list2;
    }

    public static List artifactQueryHandler(String[] stringArray, String string) throws IOException, SAMLException {
        List list;
        Object object;
        if (stringArray == null || stringArray.length == 0) {
            SAMLUtils.debug.message("artifactQueryHandler: null input.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string2 = null;
        SOAPConnection sOAPConnection = null;
        SAMLServiceManager.SOAPEntry sOAPEntry = null;
        Response response = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<AssertionArtifact> arrayList2 = new ArrayList<AssertionArtifact>();
        AssertionArtifact assertionArtifact = new AssertionArtifact(stringArray[0]);
        string2 = assertionArtifact.getSourceID();
        if (SAMLServiceManager.localFlag) {
            SAMLUtils.access(Level.INFO, SAMLUtils.bundle.getString("Artifact") + "0 : " + stringArray[0]);
        }
        arrayList2.add(assertionArtifact);
        arrayList.add(stringArray[0]);
        AssertionArtifact assertionArtifact2 = null;
        String string3 = null;
        int n = 1;
        while (n < stringArray.length) {
            assertionArtifact2 = new AssertionArtifact(stringArray[n]);
            string3 = assertionArtifact2.getSourceID();
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SourceID within the Artifact is " + string3);
            }
            if (!string3.equals(string2)) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Received multiple Artifacts have different source id.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("sourceidDifferent"));
            }
            if (SAMLServiceManager.localFlag) {
                SAMLUtils.access(Level.INFO, SAMLUtils.bundle.getString("Artifact") + n + " : " + stringArray[n]);
            }
            arrayList2.add(assertionArtifact2);
            arrayList.add(stringArray[n]);
            ++n;
        }
        try {
            object = SOAPConnectionFactory.newInstance();
            sOAPConnection = object.createConnection();
        }
        catch (SOAPException sOAPException) {
            SAMLUtils.debug.error("SAMLClient:artifactQueryHandler", (Throwable)sOAPException);
            throw new SAMLException(sOAPException.getMessage());
        }
        object = "<html> <H4>";
        try {
            SOAPMessage sOAPMessage;
            list = new Request(null, arrayList2);
            if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signrequest")).booleanValue()) {
                ((Request)((Object)list)).signXML();
            }
            SOAPMessage sOAPMessage2 = SAMLClient.createSOAPMessage((Request)((Object)list));
            String string4 = null;
            Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
            if (map == null) {
                SAMLUtils.debug.error(SAMLUtils.bundle.getString("nullPartnerUrl"));
                throw new SAMLException(SAMLUtils.bundle.getString("nullPartnerUrl"));
            }
            URLEndpoint uRLEndpoint = null;
            if (map.containsKey(string2)) {
                sOAPEntry = (SAMLServiceManager.SOAPEntry)map.get(string2);
                string4 = sOAPEntry.getSOAPUrl();
                if (string4 == null) {
                    if (string == null || string.equals("")) {
                        if (SAMLServiceManager.localFlag) {
                            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("wrongConfigPartnerUrl"));
                        }
                        throw new SAMLException(SAMLUtils.bundle.getString("wrongConfigPartnerUrl"));
                    }
                    uRLEndpoint = new URLEndpoint(string);
                } else {
                    uRLEndpoint = SAMLClient.createSOAPReceiverUrl(sOAPEntry, string4);
                }
            } else {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("SAMLClient:artifactQueryHandler: Failed to locate SOAP-Receiver-URL using the source id from AssertionArtifact.");
                }
                if (string == null || string.equals("")) {
                    throw new SAMLException(SAMLUtils.bundle.getString("failedLocateSOAPUrl"));
                }
                uRLEndpoint = new URLEndpoint(string);
            }
            if (uRLEndpoint == null) {
                SAMLUtils.debug.error("SAMLClient:artifactQueryHandler:createSOAPReceiverURL Error!");
                if (SAMLServiceManager.localFlag) {
                    SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("failCreateURLEndpoint"));
                }
                throw new SAMLException(SAMLUtils.bundle.getString("failCreateURLEndpoint"));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sOAPMessage2.writeTo((OutputStream)byteArrayOutputStream);
            String string5 = byteArrayOutputStream.toString("UTF-8");
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SENDING message: \n " + string5);
            }
            if (SAMLServiceManager.localFlag) {
                SAMLUtils.access(Level.INFO, SAMLUtils.bundle.getString("sendingSAMLRequest") + string5);
            }
            if ((sOAPMessage = sOAPConnection.call(sOAPMessage2, (Object)uRLEndpoint)) == null) {
                if (SAMLServiceManager.localFlag) {
                    SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("noReplyfromSOAPReceiver"));
                }
                throw new SAMLException(SAMLUtils.bundle.getString("noReplyfromSOAPReceiver"));
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
            string5 = byteArrayOutputStream.toString("UTF-8");
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("REPLIED message: \n " + string5);
            }
            if (SAMLServiceManager.localFlag) {
                SAMLUtils.access(Level.INFO, SAMLUtils.bundle.getString("repliedSOAPMessage") + string5);
            }
            if ((response = SAMLClient.getSAMLResponse(string5)) == null) {
                SAMLUtils.debug.error("SAMLClient:artifactQueryHandler:No SAML Response contained in SOAPMessage.");
                if (SAMLServiceManager.localFlag) {
                    SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("noSAMLResponse"));
                }
                throw new SAMLException(SAMLUtils.bundle.getString("noSAMLResponse"));
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLClient:artifactQueryHandler", (Throwable)exception);
            throw new SAMLException(exception.getMessage());
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Start to process SAML Response...");
        }
        if (!response.isSignatureValid()) {
            if (SAMLServiceManager.localFlag) {
                SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotVerifyResponse"));
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifyResponse"));
        }
        try {
            list = response.getStatus().getStatusCode().getValue();
            int n2 = 0;
            n2 = ((String)((Object)list)).indexOf(":");
            if (n2 == -1) {
                throw new SAMLException(SAMLUtils.bundle.getString("wrongformatStatusCode"));
            }
            if (!((String)((Object)list)).substring(n2).equals(":Success")) {
                SAMLUtils.debug.error("Error:SAML StatusCode is not Success");
                throw new SAMLException(SAMLUtils.displayXML(response.getStatus().toString()));
            }
        }
        catch (Exception exception) {
            if (SAMLServiceManager.localFlag) {
                SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("errorSAMLStatusCode"));
            }
            throw new SAMLException(exception.getMessage());
        }
        list = new ArrayList();
        list = SAMLClient.getAssertionList(response, arrayList);
        return list;
    }
}

