/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml;

import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.AssertionManagerIF;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.XMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AssertionManagerImpl
implements AssertionManagerIF {
    private static AssertionManager assertionManager;
    private static SSOTokenManager tokenManager;
    private static SAMLException initializationException;
    private static Object lock;
    protected static boolean isLocal;

    private static void checkInitialization() throws SAMLException {
        Object object;
        if (assertionManager == null) {
            object = lock;
            synchronized (object) {
                if (assertionManager == null) {
                    try {
                        assertionManager = AssertionManager.getInstance();
                    }
                    catch (SAMLException sAMLException) {
                        SAMLUtils.debug.error("AssertionManagerImpl: Unable to get AssertionManager", (Throwable)sAMLException);
                        throw sAMLException;
                    }
                }
            }
        }
        if (tokenManager == null) {
            object = lock;
            synchronized (object) {
                if (tokenManager == null) {
                    try {
                        tokenManager = SSOTokenManager.getInstance();
                    }
                    catch (SSOException sSOException) {
                        SAMLUtils.debug.error("AssertionManagerImpl: Unable to get SSOTokenManager", (Throwable)sSOException);
                        throw new SAMLException(sSOException.getMessage());
                    }
                }
            }
        }
    }

    public void checkForLocal() {
        isLocal = true;
    }

    public String createAssertion(String string) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        SSOToken sSOToken = null;
        try {
            sSOToken = tokenManager.createSSOToken(string);
        }
        catch (SSOException sSOException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManagerImpl:createAssertion(SSO) " + (Object)((Object)sSOException));
            }
            throw new SAMLException(sSOException.getMessage());
        }
        Assertion assertion = assertionManager.createAssertion(sSOToken);
        return assertion.toString(true, true);
    }

    public String createAssertion(String string, List list) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        SSOToken sSOToken = null;
        try {
            sSOToken = tokenManager.createSSOToken(string);
        }
        catch (SSOException sSOException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManagerImpl:createAssertion(SSO + attrs) " + (Object)((Object)sSOException));
            }
            throw new SAMLException(sSOException.getMessage());
        }
        LinkedList<Attribute> linkedList = new LinkedList<Attribute>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(new Attribute(XMLUtils.toDOMDocument((String)iterator.next()).getDocumentElement()));
        }
        Assertion assertion = assertionManager.createAssertion(sSOToken, linkedList);
        return assertion.toString(true, true);
    }

    public String createAssertionArtifact(String string, String string2) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        Assertion assertion = new Assertion(XMLUtils.toDOMDocument(string).getDocumentElement());
        AssertionArtifact assertionArtifact = assertionManager.createAssertionArtifact(assertion, SAMLUtils.byteArrayToString(Base64.decode((String)string2)));
        return assertionArtifact.getAssertionArtifact();
    }

    public String getAssertion(String string, Set set) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashSet.add(SAMLUtils.byteArrayToString(Base64.decode((String)((String)iterator.next()))));
        }
        Assertion assertion = assertionManager.getAssertion(new AssertionArtifact(string), hashSet);
        return assertion.toString(true, true);
    }

    public String getAssertion(String string, String string2) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        Assertion assertion = assertionManager.getAssertion(new AssertionArtifact(string), SAMLUtils.byteArrayToString(Base64.decode((String)string2)));
        return assertion.toString(true, true);
    }

    public String getAssertionByIdRef(String string, Set set) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashSet.add(SAMLUtils.byteArrayToString(Base64.decode((String)((String)iterator.next()))));
        }
        Assertion assertion = assertionManager.getAssertion(new AssertionIDReference(string), hashSet);
        return assertion.toString(true, true);
    }

    public String getAssertionByIdRef(String string, String string2) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        Assertion assertion = assertionManager.getAssertion(new AssertionIDReference(string), SAMLUtils.byteArrayToString(Base64.decode((String)string2)));
        return assertion.toString(true, true);
    }

    public String getAssertionByIdRefToken(String string, String string2) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        SSOToken sSOToken = null;
        try {
            sSOToken = tokenManager.createSSOToken(string2);
        }
        catch (SSOException sSOException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManagerImpl:getAssertionByIdRefToken: " + (Object)((Object)sSOException));
            }
            throw new SAMLException(sSOException.getMessage());
        }
        Assertion assertion = assertionManager.getAssertion(new AssertionIDReference(string), sSOToken);
        return assertion.toString(true, true);
    }

    public Set getAssertionArtifacts(String string) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        try {
            SSOToken sSOToken = tokenManager.createSSOToken(string);
            return assertionManager.getAssertionArtifacts(sSOToken);
        }
        catch (SSOException sSOException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManagerImpl:getAssertionArtifacts: " + (Object)((Object)sSOException));
            }
            throw new SAMLException(sSOException.getMessage());
        }
    }

    public Set getAssertions(String string) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        try {
            SSOToken sSOToken = tokenManager.createSSOToken(string);
            return assertionManager.getAssertions(sSOToken);
        }
        catch (SSOException sSOException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManagerImpl:getAssertions: " + (Object)((Object)sSOException));
            }
            throw new SAMLException(sSOException.getMessage());
        }
    }

    static {
        lock = new Object();
    }
}

