/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ResBundleUtils;
import com.sun.identity.policy.ResourceResults;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyListenerRequest;
import com.sun.identity.policy.remote.PolicyRequest;
import com.sun.identity.policy.remote.PolicyResponse;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.policy.remote.RemoveListenerRequest;
import com.sun.identity.policy.remote.ResourceResultRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PolicyRequestHandler
implements RequestHandler {
    static final String REQUEST_AUTH_LEVEL = "requestAuthLevel";
    static final String REQUEST_AUTH_SCHEMES = "requestAuthSchemes";
    static final String REQUEST_IP = "requestIp";
    static final String REQUEST_TIME = "requestTime";
    static final String REQUEST_TIME_ZONE = "requestTimeZone";
    static Debug debug = PolicyService.debug;
    static Map policyEvaluators = Collections.synchronizedMap(new HashMap());
    static Map listenerRegistry = Collections.synchronizedMap(new HashMap());

    public ResponseSet process(Vector vector, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResponseSet responseSet = new ResponseSet("policy");
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Request request = (Request)vector.elementAt(n2);
            Response response = null;
            try {
                response = this.processRequest(request);
            }
            catch (PolicyEvaluationException policyEvaluationException) {
                PolicyService policyService = new PolicyService();
                PolicyResponse policyResponse = new PolicyResponse();
                policyResponse.setMethodID(4);
                policyResponse.setRequestId(policyEvaluationException.getRequestId());
                policyResponse.setExceptionMsg(policyEvaluationException.getMessage());
                policyService.setMethodID(2);
                policyService.setPolicyResponse(policyResponse);
                response = new Response(policyService.toXMLString());
            }
            if (response != null) {
                responseSet.addResponse(response);
            }
            ++n2;
        }
        return responseSet;
    }

    private Response processRequest(Request request) throws PolicyEvaluationException {
        String string = request.getContent();
        if (debug.messageEnabled()) {
            debug.message("PolicyRequestHandler.processRequest(): content is " + string);
        }
        PolicyService policyService = PolicyService.parseXML(string);
        if (debug.messageEnabled()) {
            debug.message("PolicyRequestHandler.processRequest(): policy service object:" + policyService.toXMLString());
        }
        PolicyService policyService2 = this.processPolicyServiceRequest(policyService);
        if (debug.messageEnabled()) {
            debug.message("PolicyRequestHandler.processRequest(): get response from policy framework: \n" + policyService2.toXMLString());
        }
        return new Response(policyService2.toXMLString());
    }

    private PolicyService processPolicyServiceRequest(PolicyService policyService) throws PolicyEvaluationException {
        if (policyService.getMethodID() == 1) {
            PolicyRequest policyRequest = policyService.getPolicyRequest();
            PolicyService policyService2 = new PolicyService();
            PolicyResponse policyResponse = this.processPolicyRequest(policyRequest);
            policyService2.setMethodID(2);
            policyService2.setPolicyResponse(policyResponse);
            return policyService2;
        }
        debug.error("PolicyRequestHandler.processPolicyServiceRequest(): invalid policy request type");
        throw new PolicyEvaluationException("amPolicy", "invalid_policy_request_type", null, null);
    }

    private PolicyResponse processPolicyRequest(PolicyRequest policyRequest) throws PolicyEvaluationException {
        if (debug.messageEnabled()) {
            debug.message("PolicyRequestHandler.processPolicyRequest(): req received:\n" + policyRequest.toXMLString());
        }
        PolicyResponse policyResponse = new PolicyResponse();
        String string = policyRequest.getRequestId();
        policyResponse.setRequestId(string);
        String string2 = policyRequest.getAppSSOToken();
        SSOToken sSOToken = null;
        try {
            sSOToken = this.getSSOToken(string2);
        }
        catch (PolicyException policyException) {
            debug.error("PolicyRequestHandler: Invalid app sso token", (Throwable)policyException);
            throw new PolicyEvaluationException("amPolicy", "app_sso_token_invalid", null, null, string);
        }
        if (policyRequest.getMethodID() == 2) {
            PolicyListenerRequest policyListenerRequest = policyRequest.getPolicyListenerRequest();
            boolean bl = this.addPolicyListener(policyListenerRequest);
            if (bl) {
                policyResponse.setMethodID(2);
            } else {
                Object[] objectArray = new String[]{policyListenerRequest.getNotificationURL()};
                String string3 = ResBundleUtils.getString("failed.add.policy.listener", objectArray);
                policyResponse.setExceptionMsg(string3);
                policyResponse.setMethodID(4);
            }
            return policyResponse;
        }
        if (policyRequest.getMethodID() == 3) {
            RemoveListenerRequest removeListenerRequest = policyRequest.getRemoveListenerRequest();
            boolean bl = this.removePolicyListener(removeListenerRequest);
            if (bl) {
                policyResponse.setMethodID(3);
            } else {
                Object[] objectArray = new String[]{removeListenerRequest.getNotificationURL()};
                String string4 = ResBundleUtils.getString("failed.remove.policy.listener", objectArray);
                policyResponse.setExceptionMsg(string4);
                policyResponse.setMethodID(4);
            }
            return policyResponse;
        }
        if (policyRequest.getMethodID() == 1) {
            ResourceResultRequest resourceResultRequest = policyRequest.getResourceResultRequest();
            String string5 = resourceResultRequest.getUserSSOToken();
            SSOToken sSOToken2 = null;
            if (string5 != null && !string5.equals("") && !string5.equals("null")) {
                try {
                    sSOToken2 = this.getSSOToken(string5);
                }
                catch (PolicyException policyException) {
                    debug.error("PolicyRequestHandler: toke id:" + string5);
                    debug.error("PolicyRequestHandler: Invalid user sso token", (Throwable)policyException);
                    throw new PolicyEvaluationException("amPolicy", "user_sso_token_invalid", null, null, string);
                }
            }
            String string6 = resourceResultRequest.getServiceName();
            String string7 = resourceResultRequest.getResourceName();
            String string8 = resourceResultRequest.getResourceScope();
            Map map = resourceResultRequest.getEnvParms();
            try {
                this.convertEnvParams(map);
            }
            catch (PolicyException policyException) {
                debug.error("PolicyRequestHandler: Invalid env parameters", (Throwable)policyException);
                throw new PolicyEvaluationException("amPolicy", "invalid_env_parameters", null, policyException, string);
            }
            PolicyEvaluator policyEvaluator = null;
            HashSet hashSet = new HashSet();
            ResourceResults resourceResults = null;
            try {
                policyEvaluator = this.getPolicyEvaluator(string6);
                resourceResults = new ResourceResults(policyEvaluator.getResourceResults(sSOToken2, string7, string8, map));
                if (debug.messageEnabled()) {
                    debug.message("PolicyRequestHandler.processPolicyRequest(): resource result:\n" + resourceResults.toXML());
                }
            }
            catch (Exception exception) {
                debug.error("PolicyRequestHandler: Evaluation error", (Throwable)exception);
                throw new PolicyEvaluationException("amPolicy", "evaluation_error", null, exception, string);
            }
            Set set = resourceResultRequest.getResponseAttributes();
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler.processPolicyRequest(): respAttrs=\n" + set);
            }
            if (set != null && sSOToken2 != null) {
                Map map2 = this.getResponseDecisions(sSOToken2, set);
                resourceResults.setResponseDecisions(map2);
            }
            if (resourceResults != null) {
                hashSet.addAll(resourceResults.getResourceResults());
            }
            policyResponse.setResourceResults(hashSet);
            policyResponse.setMethodID(1);
            return policyResponse;
        }
        debug.error("PolicyRequestHandler: Invalid policy request format");
        throw new PolicyEvaluationException("amPolicy", "invalid_policy_request_format", null, null);
    }

    private Map getResponseDecisions(SSOToken sSOToken, Set set) throws PolicyEvaluationException {
        if (set == null || set.size() == 0) {
            return null;
        }
        Map map = null;
        try {
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            AMUser aMUser = aMStoreConnection.getUser(sSOToken.getPrincipal().getName());
            map = aMUser.getAttributes(set);
        }
        catch (Exception exception) {
            throw new PolicyEvaluationException(exception);
        }
        return map;
    }

    private boolean addPolicyListener(PolicyListenerRequest policyListenerRequest) {
        if (policyListenerRequest == null) {
            debug.error("PolicyRequestHandler: invalid policy listener request received");
            return false;
        }
        String string = policyListenerRequest.getServiceTypeName();
        String string2 = policyListenerRequest.getNotificationURL();
        if (listenerRegistry.containsKey(string2)) {
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler: policy listener for service " + string + " has already been registered; the notification URL is " + string2);
            }
            return true;
        }
        PolicyEvaluator policyEvaluator = null;
        try {
            policyEvaluator = this.getPolicyEvaluator(string);
            if (policyEvaluator != null) {
                policyEvaluator.addPolicyListener(policyListenerRequest);
                listenerRegistry.put(string2, policyListenerRequest);
                if (debug.messageEnabled()) {
                    debug.message("PolicyRequestHandler: policy listener for service " + string + " added");
                }
            }
        }
        catch (Exception exception) {
            debug.error("PolicyRequestHandler: failed to add policy change listener", (Throwable)exception);
            return false;
        }
        return true;
    }

    private boolean removePolicyListener(RemoveListenerRequest removeListenerRequest) {
        if (removeListenerRequest == null) {
            debug.error("PolicyRequestHandler: invalid remove policy listener request received");
            return false;
        }
        String string = removeListenerRequest.getServiceName();
        String string2 = removeListenerRequest.getNotificationURL();
        if (!listenerRegistry.containsKey(string2)) {
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler: policy listener to be removed for service " + string + " has not been registered yet; the notification URL is " + string2);
            }
            return true;
        }
        PolicyListener policyListener = (PolicyListener)listenerRegistry.get(string2);
        if (policyListener == null) {
            listenerRegistry.remove(string2);
            return true;
        }
        PolicyEvaluator policyEvaluator = null;
        try {
            policyEvaluator = this.getPolicyEvaluator(string);
            if (policyEvaluator != null) {
                policyEvaluator.removePolicyListener(policyListener);
                listenerRegistry.remove(string2);
                if (debug.messageEnabled()) {
                    debug.message("PolicyRequestHandler: policy listener for service " + string + " removed");
                }
            }
        }
        catch (Exception exception) {
            debug.error("PolicyRequestHandler: failed to remove policy change listener", (Throwable)exception);
            return false;
        }
        return true;
    }

    private void convertEnvParams(Map map) throws PolicyException {
        String string;
        Iterator iterator;
        Object object;
        Set set;
        if (map == null || map.size() == 0) {
            return;
        }
        try {
            set = (Set)map.get(REQUEST_AUTH_LEVEL);
            object = null;
            if (set != null) {
                if (set.size() != 0) {
                    iterator = set.iterator();
                    string = (String)iterator.next();
                    object = new Integer(string);
                    map.put(REQUEST_AUTH_LEVEL, object);
                } else {
                    map.put(REQUEST_AUTH_LEVEL, null);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler.convertEnvParams(): requestAuthLevel is " + object);
            }
        }
        catch (Exception exception) {
            throw new PolicyException("amPolicy", "invalid_auth_level_in_request", null, exception);
        }
        try {
            set = (Set)map.get(REQUEST_IP);
            object = null;
            if (set != null) {
                if (set.size() != 0) {
                    iterator = set.iterator();
                    object = (String)iterator.next();
                    map.put(REQUEST_IP, object);
                } else {
                    map.put(REQUEST_IP, null);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler.convertEnvParams(): requestIp is " + (String)object);
            }
        }
        catch (Exception exception) {
            throw new PolicyException("amPolicy", "invalid_ip_in_request", null, exception);
        }
        try {
            set = (Set)map.get(REQUEST_TIME);
            object = null;
            if (set != null) {
                if (set.size() != 0) {
                    iterator = set.iterator();
                    string = (String)iterator.next();
                    object = new Long(string);
                    map.put(REQUEST_TIME, object);
                } else {
                    map.put(REQUEST_TIME, null);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler.convertEnvParams(): requestTime is " + object);
            }
        }
        catch (Exception exception) {
            throw new PolicyException("amPolicy", "invalid_request_time_in_request", null, exception);
        }
        try {
            set = (Set)map.get(REQUEST_TIME_ZONE);
            object = null;
            if (set != null) {
                if (set.size() != 0) {
                    iterator = set.iterator();
                    string = (String)iterator.next();
                    object = TimeZone.getTimeZone(string);
                    map.put(REQUEST_TIME_ZONE, object);
                } else {
                    map.put(REQUEST_TIME_ZONE, null);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler.convertEnvParams(): requestTimeZone is " + object);
            }
        }
        catch (Exception exception) {
            throw new PolicyException("amPolicy", "invalid_request_time_zone_in_request", null, exception);
        }
    }

    private PolicyEvaluator getPolicyEvaluator(String string) throws PolicyException {
        PolicyEvaluator policyEvaluator = (PolicyEvaluator)policyEvaluators.get(string);
        if (policyEvaluator == null) {
            try {
                policyEvaluator = new PolicyEvaluator(string);
            }
            catch (Exception exception) {
                debug.error("PolicyRequestHandler: failed to get a policy evaluator for service " + string, (Throwable)exception);
                throw new PolicyException("amPolicy", "unable_to_get_an_evaluator", null, exception);
            }
            policyEvaluators.put(string, policyEvaluator);
        }
        return policyEvaluator;
    }

    private SSOToken getSSOToken(String string) throws PolicyException {
        SSOToken sSOToken = null;
        SSOTokenManager sSOTokenManager = null;
        try {
            sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(string);
        }
        catch (Exception exception) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
        return sSOToken;
    }
}

