/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SizeLimitExceededException;
import com.iplanet.ums.TimeLimitExceededException;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.plugins.OrgReferral;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SubOrgReferral
extends OrgReferral {
    private static final String SUB_ORG_REFERRAL = "SubOrgReferral";

    public String getReferralTypeName() {
        return SUB_ORG_REFERRAL;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        try {
            Set set = (Set)this._configurationMap.get("OrganizationName");
            if (set == null || set.isEmpty()) {
                OrgReferral.DEBUG.error("PeerOrgReferral.getValidValues():  Organization name not set");
                throw new PolicyException("amPolicy", "org_name_not_set", null, null);
            }
            Iterator iterator = set.iterator();
            String string2 = (String)iterator.next();
            PersistentObject persistentObject = UMSObject.getObject(sSOToken, new Guid(string2));
            String string3 = this.getSearchFilter(persistentObject.getGuid().getDn(), string);
            SearchControl searchControl = new SearchControl();
            int n2 = Integer.parseInt((String)this._configurationMap.get("iplanet-am-policy-config-search-timeout"));
            int n3 = Integer.parseInt((String)this._configurationMap.get("iplanet-am-policy-config-search-limit"));
            searchControl.setMaxResults(n3);
            searchControl.setTimeOut(n2);
            SearchResults searchResults = persistentObject.getChildren(string3, searchControl);
            while (searchResults.hasMoreElements()) {
                PersistentObject persistentObject2 = searchResults.next();
                hashSet.add(persistentObject2.getGuid().getDn());
            }
        }
        catch (TimeLimitExceededException timeLimitExceededException) {
            OrgReferral.DEBUG.warning("SizeLimit exceeded in Sub Org Referral");
            n = 2;
        }
        catch (SizeLimitExceededException sizeLimitExceededException) {
            OrgReferral.DEBUG.warning("SizeLimit exceeded in Sub Org Referral");
            n = 1;
        }
        catch (UMSException uMSException) {
            OrgReferral.DEBUG.error("Can not get valid values for referral " + this.getReferralTypeName() + uMSException);
            Object[] objectArray = new String[]{this.getReferralTypeName()};
            throw new PolicyException("amPolicy", "can_not_get_values_for_referral", objectArray, uMSException);
        }
        catch (NumberFormatException numberFormatException) {
            OrgReferral.DEBUG.error("Can not parse search parameters in " + this.getReferralTypeName(), (Throwable)numberFormatException);
            Object[] objectArray = new String[]{this.getReferralTypeName()};
            throw new PolicyException("amPolicy", "can_not_get_values_for_referral", objectArray, numberFormatException);
        }
        return new ValidValues(n, hashSet);
    }
}

