/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class SessionCondition
implements Condition {
    public static final String REQUEST_SESSION_CREATION_TIME = "requestSessionCreationTime";
    public static final String MAX_SESSION_TIME = "MaxSessionTime";
    public static final String TERMINATE_SESSION = "TerminateSession";
    public static final String SESSION_CONDITION_ADVICE = "SessionConditionAdvice";
    public static final String ADVICE_TERMINATE_SESSION = "terminateSession";
    public static final String ADVICE_DENY = "deny";
    private static final String SSOTOKEN_PROPERTY_AUTHINSTANT = "authInstant";
    private static final String SESSION_CONDITION_TRUE_VALUE = "session_condition_true_value";
    private static final String SESSION_CONDITION_FALSE_VALUE = "session_condition_false_value";
    private Map properties;
    private long maxSessionTime;
    private boolean terminateSession;
    private static Debug debug = Debug.getInstance((String)"amPolicy");
    private static List propertyNames = new ArrayList(2);
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String string) {
        if (string.equals(TERMINATE_SESSION)) {
            return Syntax.SINGLE_CHOICE;
        }
        return Syntax.ANY;
    }

    public String getDisplayName(String string, java.util.Locale locale) throws PolicyException {
        ResourceBundle resourceBundle = amCache.getResBundle("amPolicy", locale);
        return Locale.getString((ResourceBundle)resourceBundle, (String)string);
    }

    public Set getValidValues(String string) throws PolicyException {
        if (string.equals(TERMINATE_SESSION)) {
            OrderedSet orderedSet = new OrderedSet();
            orderedSet.add(SESSION_CONDITION_FALSE_VALUE);
            orderedSet.add(SESSION_CONDITION_TRUE_VALUE);
            return orderedSet;
        }
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map map) throws PolicyException {
        this.properties = map;
        this.validateProperties();
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    public ConditionDecision getConditionDecision(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        long l;
        boolean bl = false;
        Long l2 = null;
        if (sSOToken == null) {
            return new ConditionDecision(true, Long.MAX_VALUE);
        }
        if (map != null) {
            try {
                l2 = (Long)map.get(REQUEST_SESSION_CREATION_TIME);
            }
            catch (ClassCastException classCastException) {
                Object[] objectArray = new String[]{REQUEST_SESSION_CREATION_TIME};
                throw new PolicyException("amPolicy", "property_is_not_a_Long", objectArray, null);
            }
        }
        if (l2 != null) {
            l = l2;
        } else {
            try {
                l = PolicyUtils.stringToDate(sSOToken.getProperty(SSOTOKEN_PROPERTY_AUTHINSTANT)).getTime();
            }
            catch (ParseException parseException) {
                throw new PolicyException("amPolicy", "unable_to_parse_ssotoken_authinstant", null, parseException);
            }
        }
        long l3 = System.currentTimeMillis();
        long l4 = Long.MAX_VALUE;
        long l5 = l + this.maxSessionTime;
        if (debug.messageEnabled()) {
            debug.message("SessionCondition.getConditionDecision():" + "\n  currentTime: " + l3 + "\n  expiredTime: " + l5);
        }
        ConditionDecision conditionDecision = null;
        if (l3 < l5) {
            bl = true;
            l4 = l5;
            conditionDecision = new ConditionDecision(bl, l4);
        } else {
            HashSet<String> hashSet;
            HashMap hashMap;
            block16: {
                hashMap = new HashMap(1);
                hashSet = null;
                if (this.terminateSession) {
                    hashSet = new HashSet<String>(2);
                    hashSet.add(ADVICE_DENY);
                    hashSet.add(ADVICE_TERMINATE_SESSION);
                    try {
                        SSOTokenManager.getInstance().destroyToken(sSOToken);
                        if (debug.messageEnabled()) {
                            debug.message("SessionCondition.getConditionDecision(): successfully terminated user session!");
                        }
                        break block16;
                    }
                    catch (SSOException sSOException) {
                        if (debug.warningEnabled()) {
                            debug.warning("SessionCondition.getConditionDecision(): failed to terminate user session!", (Throwable)sSOException);
                        }
                        break block16;
                    }
                }
                hashSet = new HashSet(1);
                hashSet.add(ADVICE_DENY);
            }
            hashMap.put(SESSION_CONDITION_ADVICE, hashSet);
            conditionDecision = new ConditionDecision(bl, l4, hashMap);
        }
        return conditionDecision;
    }

    public Object clone() {
        SessionCondition sessionCondition = null;
        try {
            sessionCondition = (SessionCondition)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.properties != null) {
            sessionCondition.properties = new HashMap();
            Iterator iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                HashSet hashSet = new HashSet();
                hashSet.addAll((Set)this.properties.get(k));
                sessionCondition.properties.put(k, hashSet);
            }
        }
        return sessionCondition;
    }

    private boolean validateProperties() throws PolicyException {
        if (this.properties == null || this.properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        if (debug.messageEnabled()) {
            debug.message("SessionCondition.validateProperties(): properties: " + this.properties);
        }
        String string = this.getPropertyStringValue(MAX_SESSION_TIME, true);
        try {
            int n = Integer.parseInt(string);
            if (n <= 0) {
                Object[] objectArray = new String[]{MAX_SESSION_TIME, string};
                throw new PolicyException("amPolicy", "invalid_property_value", objectArray, null);
            }
            this.maxSessionTime = n * 60000;
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new String[]{MAX_SESSION_TIME};
            throw new PolicyException("amPolicy", "property_is_not_an_Integer", objectArray, null);
        }
        string = this.getPropertyStringValue(TERMINATE_SESSION, false);
        if (string != null && string.equals(SESSION_CONDITION_TRUE_VALUE)) {
            this.terminateSession = true;
        }
        return true;
    }

    private String getPropertyStringValue(String string, boolean bl) throws PolicyException {
        Set set = (Set)this.properties.get(string);
        if (set == null || set.isEmpty()) {
            if (bl) {
                Object[] objectArray = new String[]{string};
                throw new PolicyException("amPolicy", "property_value_not_defined", objectArray, null);
            }
            return null;
        }
        return (String)set.iterator().next();
    }

    static {
        propertyNames.add(MAX_SESSION_TIME);
        propertyNames.add(TERMINATE_SESSION);
    }
}

