/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SizeLimitExceededException;
import com.iplanet.ums.TimeLimitExceededException;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.plugins.OrgReferral;
import com.sun.identity.sm.ServiceManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PeerOrgReferral
extends OrgReferral {
    private static final String PEER_ORG_REFERRAL = "PeerOrgReferral";

    public String getReferralTypeName() {
        return PEER_ORG_REFERRAL;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        Set<String> set = new HashSet();
        int n = 0;
        try {
            Set set2 = (Set)this._configurationMap.get("OrganizationName");
            if (set2 == null || set2.isEmpty()) {
                OrgReferral.DEBUG.error("PeerOrgReferral.getValidValues():  Organization name not set");
                throw new PolicyException("amPolicy", "org_name_not_set", null, null);
            }
            Iterator iterator = set2.iterator();
            String string2 = (String)iterator.next();
            Guid guid = new Guid(string2);
            if (new Guid(ServiceManager.getBaseDN()).equals(guid)) {
                set = Collections.EMPTY_SET;
            } else {
                PersistentObject persistentObject = UMSObject.getObject(sSOToken, guid);
                PersistentObject persistentObject2 = persistentObject.getParentObject();
                String string3 = this.getSearchFilter(persistentObject2.getGuid().getDn(), string);
                SearchControl searchControl = new SearchControl();
                int n2 = Integer.parseInt((String)this._configurationMap.get("iplanet-am-policy-config-search-timeout"));
                int n3 = Integer.parseInt((String)this._configurationMap.get("iplanet-am-policy-config-search-limit"));
                searchControl.setMaxResults(n3);
                searchControl.setTimeOut(n2);
                SearchResults searchResults = persistentObject2.getChildren(string3, searchControl);
                while (searchResults.hasMoreElements()) {
                    PersistentObject persistentObject3 = searchResults.next();
                    if (persistentObject.getGuid().equals(persistentObject3.getGuid())) continue;
                    set.add(persistentObject3.getGuid().getDn());
                }
            }
        }
        catch (TimeLimitExceededException timeLimitExceededException) {
            OrgReferral.DEBUG.warning("TimeLimit exceeded in Peer Org Referral");
            n = 2;
        }
        catch (SizeLimitExceededException sizeLimitExceededException) {
            OrgReferral.DEBUG.warning("SizeLimit exceeded in Peer Org Referral");
            n = 1;
        }
        catch (UMSException uMSException) {
            OrgReferral.DEBUG.error("Can not get valid values for referral " + this.getReferralTypeName() + uMSException);
            Object[] objectArray = new String[]{this.getReferralTypeName()};
            uMSException.printStackTrace();
            throw new PolicyException("amPolicy", "can_not_get_values_for_referral", objectArray, uMSException);
        }
        catch (NumberFormatException numberFormatException) {
            OrgReferral.DEBUG.error("Can not parse search parameters in " + this.getReferralTypeName(), (Throwable)numberFormatException);
            Object[] objectArray = new String[]{this.getReferralTypeName()};
            throw new PolicyException("amPolicy", "can_not_get_values_for_referral", objectArray, numberFormatException);
        }
        return new ValidValues(n, set);
    }
}

