/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.LDAPConnectionPools;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.ConnectionPool;
import netscape.ldap.util.DN;

public class LDAPGroups
implements Subject {
    static final String STATIC_GROUP_MEMBER_ATTR = "uniqueMember";
    static final String DYNAMIC_GROUP_MEMBER_URL = "memberUrl";
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    private boolean initialized = false;
    private Set selectedGroupDNs = Collections.EMPTY_SET;
    private String authid;
    private String authpw;
    private String baseDN;
    private String groupSearchFilter;
    private int groupSearchScope = 2;
    private String userSearchFilter;
    private int userSearchScope = 2;
    private String groupRDNAttrName;
    private String userRDNAttrName;
    private int timeLimit;
    private int maxResults;
    private boolean sslEnabled = false;
    private int minPoolSize;
    private int maxPoolSize;
    private String orgName;
    private ConnectionPool connPool;
    private boolean localDS;
    private boolean aliasEnabled;
    static Debug debug = Debug.getInstance((String)"amPolicy");

    public void initialize(Map map) throws PolicyException {
        if (map == null) {
            throw new PolicyException("amPolicy", "ldapgroups_initialization_failed", null, null);
        }
        String string = (String)map.get("iplanet-am-policy-config-ldap-server");
        this.localDS = PolicyUtils.isLocalDS(string);
        this.aliasEnabled = Boolean.valueOf((String)map.get("iplanet-am-policy-config-user-alias-enabled"));
        this.authid = (String)map.get("iplanet-am-policy-config-ldap-bind-dn");
        this.authpw = (String)map.get("iplanet-am-policy-config-ldap-bind-password");
        this.baseDN = (String)map.get("iplanet-am-policy-config-ldap-base-dn");
        this.groupSearchFilter = (String)map.get("iplanet-am-policy-config-ldap-groups-search-filter");
        String string2 = (String)map.get("iplanet-am-policy-config-ldap-groups-search-scope");
        this.groupSearchScope = string2.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string2.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.groupRDNAttrName = (String)map.get("iplanet-am-policy-config-ldap-groups-search-attribute");
        this.userSearchFilter = (String)map.get("iplanet-am-policy-config-ldap-users-search-filter");
        string2 = (String)map.get("iplanet-am-policy-config-ldap-users-search-scope");
        this.userSearchScope = string2.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string2.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.userRDNAttrName = (String)map.get("iplanet-am-policy-config-ldap-users-search-attribute");
        try {
            this.timeLimit = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-limit"));
            this.minPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_min_size"));
            this.maxPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_max_size"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PolicyException(numberFormatException);
        }
        String string3 = (String)map.get("iplanet-am-policy-config-ldap-ssl-enabled");
        this.sslEnabled = string3.equalsIgnoreCase("true");
        Set set = (Set)map.get("OrganizationName");
        if (set != null && set.size() != 0) {
            Iterator iterator = set.iterator();
            this.orgName = (String)iterator.next();
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.initialize(): getting params\nhostName: " + string + "\nauthid: " + this.authid + "\nbaseDN: " + this.baseDN + "\ngroupSearchFilter: " + this.groupSearchFilter + "\ngroupRDNAttrName: " + this.groupRDNAttrName + "\nuserSearchFilter: " + this.userSearchFilter + "\nuserRDNAttrName: " + this.userRDNAttrName + "\ntimeLimit: " + this.timeLimit + "\nmaxResults: " + this.maxResults + "\nminPoolSize: " + this.minPoolSize + "\nmaxPoolSize: " + this.maxPoolSize + "\nSSLEnabled: " + this.sslEnabled + "\nOrgName: " + this.orgName);
        }
        LDAPConnectionPools.initConnectionPool(string, this.sslEnabled, this.minPoolSize, this.maxPoolSize);
        this.connPool = LDAPConnectionPools.getConnectionPool(string);
        this.initialized = true;
    }

    public Syntax getValueSyntax(SSOToken sSOToken) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "ldapgroups_subject_not_yet_initialized", null, null);
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = null;
        string2 = string != null && !string.equals("") ? "(&" + this.groupSearchFilter + "(" + this.groupRDNAttrName + "=" + string + "))" : this.groupSearchFilter;
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.getValidValues(): group search filter is: " + string2);
        }
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.maxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        int n = 0;
        try {
            try {
                lDAPConnection.authenticate(this.authid, this.authpw);
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.baseDN, this.groupSearchScope, string2, null, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    try {
                        LDAPEntry lDAPEntry = lDAPSearchResults.next();
                        if (lDAPEntry == null) continue;
                        hashSet.add(lDAPEntry.getDN());
                        if (!debug.messageEnabled()) continue;
                        debug.message("LDAPGroups.getValidValues(): found group name=" + lDAPEntry.getDN());
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{this.orgName};
                        int n2 = lDAPException.getLDAPResultCode();
                        if (n2 == 4) {
                            debug.warning("LDAPGroups.getValidValues(): exceeded the size limit");
                            n = 1;
                            continue;
                        }
                        if (n2 == 3) {
                            debug.warning("LDAPGroups.getValidValues(): exceeded the time limit");
                            n = 2;
                            continue;
                        }
                        throw new PolicyException(lDAPException);
                    }
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 49) {
                    throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                }
                String string3 = lDAPException.getMessage();
                String string4 = lDAPException.getLDAPErrorMessage();
                if (string4 != null) {
                    throw new PolicyException(string3 + ": " + string4);
                }
                throw new PolicyException(string3);
            }
            catch (Exception exception) {
                throw new PolicyException(exception);
            }
            Object var14_18 = null;
            this.connPool.close(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        return new ValidValues(n, hashSet);
    }

    public String getDisplayNameForValue(String string, Locale locale) throws NameNotFoundException {
        return string;
    }

    public Set getValues() {
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.getValues() gets called");
        }
        return this.selectedGroupDNs;
    }

    public void setValues(Set set) throws InvalidNameException {
        if (set == null) {
            debug.error("LDAPGroups.setValues(): Invalid names");
            throw new InvalidNameException("amPolicy", "ldapgroups_subject_invalid_group_names", null, null, 5);
        }
        this.selectedGroupDNs = new HashSet();
        this.selectedGroupDNs.addAll(set);
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.setValues(): selected group names=" + this.selectedGroupDNs);
        }
    }

    public boolean isMember(SSOToken sSOToken) throws SSOException, PolicyException {
        Object object;
        Object object2;
        HashSet<String> hashSet = new HashSet<String>();
        String string = sSOToken.getPrincipal().getName();
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.isMember(): user local DN is " + string);
        }
        int n = string.indexOf("=");
        int n2 = string.indexOf(",");
        if (n <= 0 || n2 <= 0 || n >= n2) {
            throw new PolicyException("amPolicy", "ldapgroups_subject_invalid_local_user_dn", null, null);
        }
        String string2 = string.substring(n + 1, n2);
        String string3 = PolicyUtils.constructUserFilter(sSOToken, this.userRDNAttrName, string2, this.aliasEnabled);
        String string4 = null;
        if (this.localDS) {
            string4 = string;
        } else {
            Object object3;
            object2 = null;
            object2 = this.userSearchFilter != null && !this.userSearchFilter.equals("") ? "(&" + this.userSearchFilter + string3 + ")" : string3;
            if (debug.messageEnabled()) {
                debug.message("LDAPGroups.isMember(): search filter is: " + (String)object2);
            }
            object = this.connPool.getConnection();
            LDAPSearchConstraints lDAPSearchConstraints = ((LDAPConnection)object).getSearchConstraints();
            lDAPSearchConstraints.setMaxResults(this.maxResults);
            lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
            try {
                try {
                    ((LDAPConnection)object).authenticate(this.authid, this.authpw);
                    object3 = ((LDAPConnection)object).search(this.baseDN, this.userSearchScope, (String)object2, null, false, lDAPSearchConstraints);
                    while (((LDAPSearchResults)object3).hasMoreElements()) {
                        try {
                            LDAPEntry lDAPEntry = ((LDAPSearchResults)object3).next();
                            if (lDAPEntry == null) continue;
                            hashSet.add(lDAPEntry.getDN());
                        }
                        catch (LDAPReferralException lDAPReferralException) {
                        }
                        catch (LDAPException lDAPException) {
                            Object[] objectArray = new String[]{this.orgName};
                            int n3 = lDAPException.getLDAPResultCode();
                            if (n3 == 4) {
                                debug.warning("LDAPGroups.isMember(): exceeded the size limit");
                                throw new PolicyException("amPolicy", "ldap_search_exceed_size_limit", objectArray, null);
                            }
                            if (n3 == 3) {
                                debug.warning("LDAPGroups.isMember(): exceeded the time limit");
                                throw new PolicyException("amPolicy", "ldap_search_exceed_time_limit", objectArray, null);
                            }
                            throw new PolicyException(lDAPException);
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 49) {
                        throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                    }
                    String string5 = lDAPException.getMessage();
                    String string6 = lDAPException.getLDAPErrorMessage();
                    if (string6 != null) {
                        throw new PolicyException(string5 + ": " + string6);
                    }
                    throw new PolicyException(string5);
                }
                catch (Exception exception) {
                    throw new PolicyException(exception);
                }
                Object var18_22 = null;
                this.connPool.close((LDAPConnection)object);
            }
            catch (Throwable throwable) {
                Object var18_23 = null;
                this.connPool.close((LDAPConnection)object);
                throw throwable;
            }
            if (hashSet.size() > 0) {
                if (debug.messageEnabled()) {
                    debug.message("LDAPGroups.isMember(): qualified users=" + hashSet);
                }
                object3 = hashSet.iterator();
                string4 = (String)object3.next();
            } else {
                if (debug.messageEnabled()) {
                    debug.message("LDAPGroups.isMember(): User " + string2 + " is not found in the directory");
                }
                return false;
            }
        }
        object2 = this.selectedGroupDNs.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (!this.isMemberOfGroup((String)object, string4, string3)) continue;
            if (debug.messageEnabled()) {
                debug.message("LDAPGroups.isMember(): User " + string4 + " is a member of group " + (String)object);
            }
            return true;
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.isMember(): User " + string4 + " is not a member of this LDAPGroups object");
        }
        return false;
    }

    private boolean isMemberOfGroup(String string, String string2, String string3) throws PolicyException {
        Enumeration enumeration;
        Object object;
        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
            return false;
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups: checking group " + string);
        }
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPEntry lDAPEntry = null;
        try {
            try {
                lDAPConnection.authenticate(this.authid, this.authpw);
                lDAPEntry = lDAPConnection.read(string);
            }
            catch (Exception exception) {
                debug.warning("LDAPGroups: invalid group name " + string + " specified in the policy definition.");
                boolean bl = false;
                Object var9_7 = null;
                this.connPool.close(lDAPConnection);
                return bl;
            }
            object = null;
            this.connPool.close(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        DN dN = new DN(string2);
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(STATIC_GROUP_MEMBER_ATTR);
        if (lDAPAttribute != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration != null && enumeration.hasMoreElements()) {
                object = new DN((String)enumeration.nextElement());
                if (!dN.equals((DN)object)) continue;
                return true;
            }
        }
        if ((lDAPAttribute = lDAPEntry.getAttribute(DYNAMIC_GROUP_MEMBER_URL)) != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration != null && enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                try {
                    LDAPUrl lDAPUrl = new LDAPUrl((String)object);
                    Set set = this.findDynamicGroupMembersByUrl(lDAPUrl, string3);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        DN dN2 = new DN((String)iterator.next());
                        if (!dN.equals(dN2)) continue;
                        return true;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    throw new PolicyException(malformedURLException);
                }
            }
        }
        return false;
    }

    private Set findDynamicGroupMembersByUrl(LDAPUrl lDAPUrl, String string) throws PolicyException {
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.maxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        HashSet<String> hashSet = new HashSet<String>();
        try {
            try {
                lDAPConnection.authenticate(this.authid, this.authpw);
                StringBuffer stringBuffer = new StringBuffer(25);
                stringBuffer.append("(&").append(string);
                String string2 = lDAPUrl.getFilter();
                int n = string2.indexOf("(");
                if (n != 0) {
                    stringBuffer.append("(").append(string2).append("))");
                } else {
                    stringBuffer.append(string2).append(")");
                }
                if (debug.messageEnabled()) {
                    debug.message("search filter in LDAPGroups : " + stringBuffer);
                }
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(lDAPUrl.getDN(), lDAPUrl.getScope(), stringBuffer.toString(), null, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    try {
                        LDAPEntry lDAPEntry = lDAPSearchResults.next();
                        if (lDAPEntry == null) continue;
                        hashSet.add(lDAPEntry.getDN());
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                    }
                    catch (LDAPException lDAPException) {
                        Object[] objectArray = new String[]{this.orgName};
                        int n2 = lDAPException.getLDAPResultCode();
                        if (n2 == 4) {
                            debug.warning("LDAPGroups.findDynamicGroupMembersByUrl(): exceeded the size limit");
                            throw new PolicyException("amPolicy", "ldap_search_exceed_size_limit", objectArray, null);
                        }
                        if (n2 == 3) {
                            debug.warning("LDAPGroups.findDynamicGroupMembersByUrl(): exceeded the time limit");
                            throw new PolicyException("amPolicy", "ldap_search_exceed_time_limit", objectArray, null);
                        }
                        throw new PolicyException(lDAPException);
                    }
                }
            }
            catch (Exception exception) {
                throw new PolicyException(exception);
            }
            Object var15_16 = null;
            this.connPool.close(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        return hashSet;
    }

    public int hashCode() {
        return this.selectedGroupDNs.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof LDAPGroups) {
            LDAPGroups lDAPGroups = (LDAPGroups)object;
            if (this.selectedGroupDNs != null && lDAPGroups.selectedGroupDNs != null && this.selectedGroupDNs.equals(lDAPGroups.selectedGroupDNs)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        LDAPGroups lDAPGroups = null;
        try {
            lDAPGroups = (LDAPGroups)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.selectedGroupDNs != null) {
            lDAPGroups.selectedGroupDNs = new HashSet();
            lDAPGroups.selectedGroupDNs.addAll(this.selectedGroupDNs);
        }
        return lDAPGroups;
    }
}

