/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPException;

public class DSAMERole
implements Subject {
    private boolean initialized;
    private String organizationDN;
    private Set subjectRoles = Collections.EMPTY_SET;
    private int timeLimit;
    private int maxResults;
    private int roleSearchScope;
    private static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    private static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    private static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    static Debug debug = Debug.getInstance((String)"amPolicy");

    public void initialize(Map map) throws PolicyException {
        this.organizationDN = (String)map.get("iplanet-am-policy-config-is-roles-base-dn");
        String string = (String)map.get("iplanet-am-policy-config-is-roles-search-scope");
        this.roleSearchScope = string.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        try {
            this.timeLimit = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-limit"));
        }
        catch (NumberFormatException numberFormatException) {
            debug.error("Can not parse search parameters in DSAMERole", (Throwable)numberFormatException);
            this.timeLimit = 5;
            this.maxResults = 100;
        }
        this.initialized = true;
    }

    public Syntax getValueSyntax(SSOToken sSOToken) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "role_subject_not_yet_initialized", null, null);
        }
        try {
            int n;
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.organizationDN);
            AMSearchControl aMSearchControl = new AMSearchControl();
            aMSearchControl.setMaxResults(this.maxResults);
            aMSearchControl.setTimeOut(this.timeLimit);
            aMSearchControl.setSearchScope(this.roleSearchScope);
            AMSearchResults aMSearchResults = aMOrganization.searchAllRoles(string, aMSearchControl);
            switch (aMSearchResults.getErrorCode()) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return new ValidValues(n, aMSearchResults.getSearchResults());
        }
        catch (AMException aMException) {
            LDAPException lDAPException = aMException.getLDAPException();
            if (lDAPException != null) {
                String string2 = lDAPException.getMessage();
                String string3 = lDAPException.getLDAPErrorMessage();
                if (string3 != null) {
                    throw new PolicyException(string2 + ": " + string3, aMException);
                }
                throw new PolicyException(string2, aMException);
            }
            throw new PolicyException(aMException);
        }
    }

    public String getDisplayNameForValue(String string, Locale locale) throws NameNotFoundException {
        return string;
    }

    public Set getValues() {
        if (this.subjectRoles == null) {
            return Collections.EMPTY_SET;
        }
        return this.subjectRoles;
    }

    public void setValues(Set set) throws InvalidNameException {
        if (set == null) {
            throw new InvalidNameException("amPolicy", "role_subject_invalid_role_names", null, null, 5);
        }
        this.subjectRoles = set;
        if (debug.messageEnabled()) {
            debug.message("Set subjectRoles to: " + this.subjectRoles);
        }
    }

    public boolean isMember(SSOToken sSOToken) throws SSOException, PolicyException {
        try {
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            AMUser aMUser = aMStoreConnection.getUser(sSOToken.getPrincipal().getName());
            if (!aMUser.isActivated()) {
                return false;
            }
            HashSet hashSet = aMUser.getRoleDNs();
            Set set = aMUser.getFilteredRoleDNs();
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            if (set != null) {
                hashSet.addAll(set);
            }
            if (debug.messageEnabled()) {
                debug.message("DSAMERole.isMember():\n  user roles: " + hashSet + "\n  subject roles: " + this.subjectRoles);
            }
            Iterator iterator = hashSet.iterator();
            Iterator iterator2 = null;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                iterator2 = this.subjectRoles.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (debug.messageEnabled()) {
                        debug.message("isMemeber: userRole = " + string + " subjectRole: = " + string2);
                    }
                    if (!LDAPDN.normalize(string).equalsIgnoreCase(LDAPDN.normalize(string2))) continue;
                    if (debug.messageEnabled()) {
                        debug.message("User role " + string + " matched");
                    }
                    return true;
                }
            }
            if (debug.messageEnabled()) {
                debug.message("User Role didn't match");
            }
            return false;
        }
        catch (AMException aMException) {
            throw new PolicyException(aMException);
        }
    }

    public int hashCode() {
        return this.subjectRoles.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DSAMERole) {
            DSAMERole dSAMERole = (DSAMERole)object;
            return this.subjectRoles.equals(dSAMERole.subjectRoles);
        }
        return false;
    }

    public Object clone() {
        DSAMERole dSAMERole = null;
        try {
            dSAMERole = (DSAMERole)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.subjectRoles != null) {
            dSAMERole.subjectRoles = new HashSet();
            dSAMERole.subjectRoles.addAll(this.subjectRoles);
        }
        return dSAMERole;
    }
}

