/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class SubjectTypeManager {
    private static String SUBJECT = "Subject";
    private SSOToken token;
    private PolicyManager pm;
    private ResourceBundle rb;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    static Debug debug = PolicyManager.debug;
    private static ServiceSchemaManager ssm;

    protected SubjectTypeManager() throws SSOException {
        this.token = ServiceTypeManager.getSSOToken();
        String string = this.token.getProperty("Locale");
        java.util.Locale locale = Locale.getLocale((String)string);
        this.rb = amCache.getResBundle("amPolicy", locale);
    }

    protected SubjectTypeManager(PolicyManager policyManager) {
        java.util.Locale locale;
        this.pm = policyManager;
        this.token = policyManager.token;
        try {
            String string = this.token.getProperty("Locale");
            locale = Locale.getLocale((String)string);
        }
        catch (SSOException sSOException) {
            debug.error("SubjectTypeManager:Unable to retreive locale from SSOToken", (Throwable)sSOException);
            locale = Locale.getDefaultLocale();
        }
        if (debug.messageEnabled()) {
            debug.message("SubjectManager locale=" + locale + "\tI18nFileName = " + "amPolicy");
        }
        this.rb = amCache.getResBundle("amPolicy", locale);
    }

    public Set getSubjectTypeNames() throws SSOException, PolicyException {
        return PolicyManager.getPluginSchemaNames(SUBJECT);
    }

    public Set getSelectedSubjectTypeNames() throws SSOException, PolicyException {
        Map map = this.pm.getPolicyConfig();
        Set set = null;
        if (map != null) {
            set = (Set)map.get("iplanet-am-policy-selected-subjects");
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    public String getSubjectTypeName(Subject subject) {
        return SubjectTypeManager.subjectTypeName(subject);
    }

    protected String getI18NPropertiesFileName(String string) {
        PluginSchema pluginSchema = PolicyManager.getPluginSchema(SUBJECT, string);
        return null;
    }

    public String getI18NKey(String string) {
        PluginSchema pluginSchema = PolicyManager.getPluginSchema(SUBJECT, string);
        if (pluginSchema != null) {
            return pluginSchema.getI18NKey();
        }
        return null;
    }

    public String getDisplayName(String string) {
        String string2 = null;
        String string3 = this.getI18NKey(string);
        string2 = string3 == null || string3.length() == 0 ? string : Locale.getString((ResourceBundle)this.rb, (String)string3, (Debug)debug);
        return string2;
    }

    public Subject getSubject(String string) throws NameNotFoundException, PolicyException {
        PluginSchema pluginSchema = PolicyManager.getPluginSchema(SUBJECT, string);
        if (pluginSchema == null) {
            throw new NameNotFoundException("amPolicy", "invalid_subject", null, string, 5);
        }
        Subject subject = null;
        try {
            String string2 = pluginSchema.getClassName();
            subject = (Subject)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            throw new PolicyException(exception);
        }
        subject.initialize(this.pm.getPolicyConfig());
        return subject;
    }

    static String subjectTypeName(Subject subject) {
        if (subject == null) {
            return null;
        }
        String string = null;
        String string2 = subject.getClass().getName();
        Iterator iterator = PolicyManager.getPluginSchemaNames(SUBJECT).iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            PluginSchema pluginSchema = PolicyManager.getPluginSchema(SUBJECT, string3);
            if (!string2.equals(pluginSchema.getClassName())) continue;
            string = string3;
            break;
        }
        return string;
    }

    public String getViewBeanURL(Subject subject) {
        return PolicyManager.getViewBeanURL(SUBJECT, subject.getClass().getName());
    }
}

