/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.services.util.XMLException;
import com.iplanet.services.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.ConditionTypeManager;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyCache;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ReferralTypeManager;
import com.sun.identity.policy.ResBundleUtils;
import com.sun.identity.policy.ResourceIndexManager;
import com.sun.identity.policy.ResourceManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import netscape.ldap.util.DN;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class PolicyManager {
    public static final String POLICY_SERVICE_NAME = "iPlanetAMPolicyService";
    public static final String POLICY_DEBUG_NAME = "amPolicy";
    public static final String ORGANIZATION_NAME = "OrganizationName";
    static final String NAMED_POLICY = "Policies";
    private static final String NAMED_POLICY_ID = "NamedPolicy";
    static final String RESOURCES_POLICY = "Resources";
    static final String RESOURCES_POLICY_ID = "ServiceType";
    private static final String SUBJECTS_POLICY = "Subjects";
    private static final String SUBJECTS_POLICY_ID = "UserCollections";
    static final String SUBJECT_POLICY = "Subject";
    static final String CONDITION_POLICY = "Condition";
    static final String REFERRAL_POLICY = "Referral";
    static final String REFERRALS_POLICY = "Referrals";
    private static final String POLICY_XML = "xmlpolicy";
    static final String POLICY_VERSION = "1.0";
    static final String POLICY_ROOT_NODE = "Policy";
    static final String POLICY_RULE_NODE = "Rule";
    static final String POLICY_SUBJECTS_NODE = "Subjects";
    static final String POLICY_CONDITIONS_NODE = "Conditions";
    static final String POLICY_REFERRALS_NODE = "Referrals";
    static final String POLICY_RULE_SERVICE_NODE = "ServiceName";
    static final String POLICY_RULE_RESOURCE_NODE = "ResourceName";
    static final String ATTR_VALUE_PAIR_NODE = "AttributeValuePair";
    static final String ATTR_NODE = "Attribute";
    static final String ATTR_VALUE_NODE = "Value";
    static final String NAME_ATTRIBUTE = "name";
    static final String TYPE_ATTRIBUTE = "type";
    static final String DESCRIPTION_ATTRIBUTE = "description";
    static final String PRIORITY_ATTRIBUTE = "priority";
    static final String STATUS_ATTRIBUTE = "priority";
    static final String STATUS_ACTIVE = "active";
    static final String STATUS_INACTIVE = "inactive";
    static final String SERVICE_TYPE_NAME_ATTRIBUTE = "serviceName";
    static final String POLICY_INDEX_ROOT_NODE = "PolicyCrossReferences";
    static final String POLICY_INDEX_ROOT_NODE_NAME_ATTR = "name";
    static final String POLICY_INDEX_ROOT_NODE_TYPE_ATTR = "type";
    static final String POLICY_INDEX_ROOT_NODE_TYPE_ATTR_RESOURCES_VALUE = "Resources";
    static final String POLICY_INDEX_REFERENCE_NODE = "Reference";
    static final String POLICY_INDEX_REFERENCE_NODE_NAME_ATTR = "name";
    static final String POLICY_INDEX_POLICYNAME_NODE = "PolicyName";
    static final String POLICY_INDEX_POLICYNAME_NODE_NAME_ATTR = "name";
    static final long DEFAULT_SUBJECTS_RESULT_TTL = 600000L;
    private String org = "/";
    private String givenOrgName = "";
    private ServiceConfigManager scm;
    private ResourceManager rm;
    private ServiceTypeManager svtm;
    private SubjectTypeManager stm;
    private ConditionTypeManager ctm;
    private Cache cachedPolicies = new Cache(200);
    private ReferralTypeManager rtm;
    private PolicyCache policyCache;
    private ResourceIndexManager rim;
    private static ServiceSchemaManager ssm;
    SSOToken token;
    static Debug debug;

    public PolicyManager(SSOToken sSOToken) throws SSOException, PolicyException {
        this(sSOToken, "");
        if (debug.messageEnabled()) {
            debug.message("Policy Manager constructed using SSO token");
        }
    }

    public PolicyManager(SSOToken sSOToken, String string) throws SSOException, NameNotFoundException, PolicyException {
        SSOTokenManager.getInstance().validateToken(sSOToken);
        this.token = sSOToken;
        try {
            this.scm = new ServiceConfigManager(POLICY_SERVICE_NAME, sSOToken);
        }
        catch (SMSException sMSException) {
            debug.error("In constructor for PolicyManager with orgNameUnable to get service config manager", (Throwable)sMSException);
            throw new PolicyException(sMSException);
        }
        this.org = this.verifyOrgName(string);
        this.givenOrgName = string;
        this.rm = new ResourceManager(sSOToken, this.org, this.scm);
        if (debug.messageEnabled()) {
            debug.message("Policy Manager constructed with SSO token  for organization: " + this.org);
        }
        this.policyCache = PolicyCache.getInstance();
        this.svtm = ServiceTypeManager.getServiceTypeManager();
        this.rim = new ResourceIndexManager(this.rm);
    }

    public String getOrganizationName() {
        return this.givenOrgName;
    }

    Map getPolicyConfig() {
        Map map = null;
        try {
            map = PolicyConfig.getPolicyConfig(this.org);
        }
        catch (PolicyException policyException) {
            debug.error("PolicyManager:can not get policy config  for org : " + this.org, (Throwable)policyException);
        }
        if (map != null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(this.org);
            map.put(ORGANIZATION_NAME, hashSet);
        } else {
            debug.error("PolicyManager: policy config is null for org:" + this.org + ". Most likely it has been unregistered." + " It is not recommended to unregister the policy" + " configuration serivce. If you do so, the result" + " is undefined.");
        }
        return map;
    }

    String getOrganizationDN() {
        return this.org;
    }

    public Set getPolicyNames() throws SSOException, NoPermissionException, PolicyException {
        return this.getPolicyNames("*");
    }

    public Set getPolicyNames(String string) throws SSOException, NoPermissionException, PolicyException {
        try {
            ServiceConfig serviceConfig;
            ServiceConfig serviceConfig2 = this.scm.getOrganizationConfig(this.org, null);
            ServiceConfig serviceConfig3 = serviceConfig = serviceConfig2 == null ? null : serviceConfig2.getSubConfig(NAMED_POLICY);
            if (serviceConfig == null) {
                return Collections.EMPTY_SET;
            }
            if (string.equals("*")) {
                return serviceConfig.getSubConfigNames();
            }
            return serviceConfig.getSubConfigNames(string);
        }
        catch (SMSException sMSException) {
            debug.error("Unable to get named policies for organization: " + this.org);
            Object[] objectArray = new String[]{this.org};
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_policies_for_organization", objectArray, sMSException);
        }
    }

    public String getPolicyDN(String string) throws SSOException, NoPermissionException, NameNotFoundException, PolicyException {
        this.getPolicy(string);
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ou=");
        stringBuffer.append(string);
        stringBuffer.append(",ou=");
        stringBuffer.append(NAMED_POLICY);
        stringBuffer.append(",ou=default,ou=organizationConfig,ou=");
        stringBuffer.append(POLICY_VERSION);
        stringBuffer.append(",ou=");
        stringBuffer.append(POLICY_SERVICE_NAME);
        stringBuffer.append(",ou=services,");
        stringBuffer.append(this.org);
        return stringBuffer.toString();
    }

    public Policy getPolicy(String string) throws SSOException, NoPermissionException, InvalidFormatException, NameNotFoundException, InvalidNameException, PolicyException {
        if (string == null) {
            throw new InvalidNameException(POLICY_DEBUG_NAME, "null_name", null, "null", 1);
        }
        if (debug.messageEnabled()) {
            debug.message("searching for named policy: " + string + " in organization: " + this.org);
        }
        Policy policy = null;
        try {
            ServiceConfig serviceConfig = this.scm.getOrganizationConfig(this.org, null);
            ServiceConfig serviceConfig2 = serviceConfig == null ? null : serviceConfig.getSubConfig(NAMED_POLICY);
            ServiceConfig serviceConfig3 = null;
            Map map = null;
            Set set = null;
            if (serviceConfig2 == null || (serviceConfig3 = serviceConfig2.getSubConfig(string)) == null || (map = serviceConfig3.getAttributes()) == null || (set = (Set)map.get(POLICY_XML)) == null || set.size() <= 0) {
                if (debug.warningEnabled()) {
                    debug.warning("Unable to find named policy: " + string + " in organization: " + this.org);
                }
                Object[] objectArray = new String[]{string, this.org};
                throw new NameNotFoundException(POLICY_DEBUG_NAME, "policy_not_found_in_organization", objectArray, string, 1);
            }
            Iterator iterator = set.iterator();
            String string2 = (String)iterator.next();
            Document document = XMLUtils.getXMLDocument((String)string2);
            Node node = XMLUtils.getRootNode((Document)document, (String)POLICY_ROOT_NODE);
            if (node == null) {
                debug.error("invalid xml policy blob for named policy: " + string + " in organization: " + this.org);
                throw new InvalidFormatException(POLICY_DEBUG_NAME, "invalid_xml_policy_root_node", null, string, 1);
            }
            if (debug.messageEnabled()) {
                debug.message("returning named policy: " + string + " for organization: " + this.org);
            }
            policy = new Policy(this, node);
            Map map2 = this.getPolicyConfig();
            if (map2 != null) {
                policy.setSubjectsResultTtl(PolicyConfig.getSubjectsResultTtl(map2));
            }
            return policy;
        }
        catch (XMLException xMLException) {
            debug.error("XML parsing error for policy: " + string + " in organization: " + this.org);
            throw new PolicyException(xMLException);
        }
        catch (SMSException sMSException) {
            debug.error("SMS error in finding named policy: " + string + " in organization: " + this.org);
            Object[] objectArray = new String[]{string, this.org};
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_policy", objectArray, sMSException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            debug.error("Unsuported Encoding in XML  for policy: " + string + "in organization: " + this.org);
            throw new PolicyException(unsupportedEncodingException);
        }
    }

    public void addPolicy(Policy policy) throws SSOException, NameAlreadyExistsException, NoPermissionException, InvalidFormatException, PolicyException {
        this.validateForResourcePrefix(policy);
        this.validateReferrals(policy);
        String string = policy.toXML();
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        hashMap.put(POLICY_XML, hashSet);
        ServiceConfig serviceConfig = PolicyManager.createOrGetPolicyConfig(NAMED_POLICY, NAMED_POLICY, this.scm, this.org);
        try {
            serviceConfig.addSubConfig(policy.getName(), NAMED_POLICY_ID, 0, hashMap);
            this.rim.addPolicyToResourceTree(this.svtm, this.token, policy);
        }
        catch (ServiceAlreadyExistsException serviceAlreadyExistsException) {
            Object[] objectArray = new String[]{policy.getName(), this.org};
            if (PolicyUtils.logStatus) {
                PolicyUtils.logErrorMessage(Level.INFO, ResBundleUtils.getString("policy_already_exists_in_org", objectArray), this.token);
            }
            throw new NameAlreadyExistsException(POLICY_DEBUG_NAME, "policy_already_exists_in_org", objectArray, policy.getName(), 1);
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new String[]{policy.getName(), this.org};
            String string2 = ResBundleUtils.getString("unable_to_add_policy", objectArray);
            if (PolicyUtils.logStatus) {
                PolicyUtils.logErrorMessage(Level.INFO, string2, this.token);
            }
            debug.error("SMS error in add policy: " + policy.getName() + " for org: " + this.org, (Throwable)sMSException);
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_add_policy", objectArray, sMSException);
        }
        if (PolicyUtils.logStatus) {
            Object[] objectArray = new String[]{policy.getName(), this.org};
            PolicyUtils.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_create_success", objectArray), this.token);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replacePolicy(Policy policy) throws SSOException, NameNotFoundException, NoPermissionException, InvalidFormatException, PolicyException {
        Object[] objectArray;
        String string;
        block10: {
            String string2 = policy.toXML();
            HashMap hashMap = new HashMap();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string2);
            hashMap.put(POLICY_XML, hashSet);
            string = null;
            ServiceConfig serviceConfig = PolicyManager.createOrGetPolicyConfig(NAMED_POLICY, NAMED_POLICY, this.scm, this.org);
            try {
                objectArray = policy.getName();
                String string3 = policy.getOriginalName();
                ServiceConfig serviceConfig2 = serviceConfig.getSubConfig((String)objectArray);
                ServiceConfig serviceConfig3 = null;
                if (string3 != null) {
                    serviceConfig3 = serviceConfig.getSubConfig(string3);
                    string = string3;
                } else {
                    string = policy.getName();
                }
                if (serviceConfig2 == null) {
                    if (serviceConfig3 == null) {
                        Object[] objectArray2 = new String[]{policy.getName(), this.org};
                        throw new NameNotFoundException(POLICY_DEBUG_NAME, "policy_not_found_in_organization", objectArray2, policy.getName(), 1);
                    }
                    this.removePolicy(string3);
                    this.addPolicy(policy);
                    policy.resetOriginalName();
                    break block10;
                }
                Policy policy2 = this.getPolicy(policy.getName());
                this.validateForResourcePrefix(policy);
                this.validateReferrals(policy);
                serviceConfig2.setAttributes(hashMap);
                if (policy2 != null) {
                    this.rim.replacePolicyInResourceTree(this.svtm, this.token, policy2, policy);
                }
            }
            catch (SMSException sMSException) {
                Object[] objectArray3 = new String[]{string, this.org};
                String string4 = ResBundleUtils.getString("unable_to_replace_policy", objectArray3);
                if (PolicyUtils.logStatus) {
                    PolicyUtils.logErrorMessage(Level.INFO, string4, this.token);
                }
                debug.error("SMS error in replacing policy: " + policy.getOriginalName() + " for org: " + this.org, (Throwable)sMSException);
                if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                    throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
                }
                throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_replace_policy", objectArray3, sMSException);
            }
        }
        if (PolicyUtils.logStatus) {
            objectArray = new String[]{string, this.org};
            PolicyUtils.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_modify_success", objectArray), this.token);
        }
    }

    public void removePolicy(String string) throws SSOException, NoPermissionException, PolicyException {
        Object[] objectArray;
        if (string == null) {
            if (debug.warningEnabled()) {
                debug.warning("In PolicyManager::removePolicy(), name is null");
            }
            throw new InvalidNameException(POLICY_DEBUG_NAME, "null_name", null, "null", 1);
        }
        try {
            ServiceConfig serviceConfig;
            objectArray = this.scm.getOrganizationConfig(this.org, null);
            ServiceConfig serviceConfig2 = serviceConfig = objectArray == null ? null : objectArray.getSubConfig(NAMED_POLICY);
            if (serviceConfig != null) {
                ServiceConfig serviceConfig3 = serviceConfig.getSubConfig(string);
                Policy policy = this.getPolicy(string);
                serviceConfig.removeSubConfig(string);
                if (policy != null) {
                    this.rim.removePolicyFromResourceTree(this.svtm, this.token, policy);
                }
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            debug.error("Error while removing policy : " + serviceNotFoundException.getMessage());
        }
        catch (SMSException sMSException) {
            Object[] objectArray2 = new String[]{string, this.org};
            String string2 = ResBundleUtils.getString("unable_to_remove_policy", objectArray2);
            if (PolicyUtils.logStatus) {
                PolicyUtils.logErrorMessage(Level.INFO, string2, this.token);
            }
            debug.error("SMS error in deleting policy: " + string + " for org: " + this.org, (Throwable)sMSException);
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_remove_policy", objectArray2, sMSException);
        }
        objectArray = new String[]{string, this.org};
        if (PolicyUtils.logStatus) {
            PolicyUtils.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_remove_success", objectArray), this.token);
        }
    }

    public ResourceManager getResourceManager() {
        return this.rm;
    }

    public SubjectTypeManager getSubjectTypeManager() {
        if (this.stm == null) {
            this.stm = new SubjectTypeManager(this);
        }
        return this.stm;
    }

    public ConditionTypeManager getConditionTypeManager() {
        if (this.ctm == null) {
            this.ctm = new ConditionTypeManager(this);
        }
        return this.ctm;
    }

    static ServiceConfig createOrGetPolicyConfig(String string, String string2, ServiceConfigManager serviceConfigManager, String string3) throws NoPermissionException, PolicyException, SSOException {
        ServiceConfig serviceConfig = null;
        try {
            ServiceConfig serviceConfig2 = serviceConfigManager.getOrganizationConfig(string3, null);
            ServiceConfig serviceConfig3 = serviceConfig = serviceConfig2 == null ? null : serviceConfig2.getSubConfig(string);
            if (serviceConfig == null) {
                if (debug.messageEnabled()) {
                    debug.message("Creating the " + string + " tree for org: " + string3);
                }
                PolicyManager.createPolicyTree(string, string2, serviceConfigManager, string3);
                if (serviceConfig2 == null) {
                    serviceConfig2 = serviceConfigManager.getOrganizationConfig(string3, null);
                }
                if (serviceConfig2 == null || (serviceConfig = serviceConfig2.getSubConfig(string)) == null) {
                    Object[] objectArray = new String[]{string};
                    throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_policy_node", objectArray, null);
                }
            }
        }
        catch (SMSException sMSException) {
            debug.error("SMS error in creating " + string + " node for org: " + string3, (Throwable)sMSException);
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                Object[] objectArray = new String[]{string};
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", objectArray);
            }
            Object[] objectArray = new String[]{string};
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_policy_node", objectArray, sMSException);
        }
        return serviceConfig;
    }

    static void createPolicyTree(String string, String string2, ServiceConfigManager serviceConfigManager, String string3) throws NoPermissionException, PolicyException, SSOException {
        try {
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string3, null);
            if (serviceConfig == null) {
                serviceConfigManager.createOrganizationConfig(string3, null);
                serviceConfig = serviceConfigManager.getOrganizationConfig(string3, null);
            }
            serviceConfig.addSubConfig(string, string2, 0, null);
        }
        catch (ServiceAlreadyExistsException serviceAlreadyExistsException) {
            if (debug.messageEnabled()) {
                debug.message("PolicyManager->createPolicyTree: Name: " + string + " ID: " + string2 + " Policy service already exists under org->" + string3);
            }
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new String[]{string3};
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_create_policy_for_org", objectArray, sMSException);
        }
    }

    String verifyOrgName(String string) throws InvalidNameException, NameNotFoundException, SSOException {
        String string2 = null;
        if (string == null) {
            throw new InvalidNameException(POLICY_DEBUG_NAME, "null_name", null, "null", 4);
        }
        string2 = string.equals("/") || string.equals("") ? ServiceManager.getBaseDN() : (!DN.isDN(string) ? DNMapper.orgNameToDN(string) : string);
        if (!SMSEntry.checkIfEntryExists(string2, this.token.getPrincipal())) {
            if (debug.warningEnabled()) {
                debug.warning("Checking for organization name: " + string2 + " failed since entry does not exist");
            }
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException(POLICY_DEBUG_NAME, "org_not_found", objectArray, string2, 4);
        }
        return string2;
    }

    Set getSubOrganizationNames() throws SSOException, NoPermissionException, PolicyException {
        throw new UnsupportedOperationException();
    }

    Set getSubOrganizationNames(String string) throws SSOException, PolicyException {
        throw new UnsupportedOperationException();
    }

    PolicyManager getSubOrganizationPolicyManager(String string) throws SSOException, PolicyException {
        return new PolicyManager(this.token, this.org + "/" + string);
    }

    ServiceTypeManager getServiceTypeManager() {
        return this.svtm;
    }

    public ReferralTypeManager getReferralTypeManager() {
        if (this.rtm == null) {
            this.rtm = new ReferralTypeManager(this);
        }
        return this.rtm;
    }

    static Set getPluginSchemaNames(String string) {
        if (ssm == null) {
            try {
                ssm = new ServiceSchemaManager(POLICY_SERVICE_NAME, ServiceTypeManager.getSSOToken());
            }
            catch (Exception exception) {
                debug.error("Cannot create service schema manager for policy", (Throwable)exception);
                return Collections.EMPTY_SET;
            }
        }
        Set set = null;
        try {
            set = ssm.getPluginSchemaNames(string, null);
        }
        catch (Exception exception) {
            debug.error("Cannot get plugin schemas: " + string + " for policy", (Throwable)exception);
            return Collections.EMPTY_SET;
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    static PluginSchema getPluginSchema(String string, String string2) {
        Set set = PolicyManager.getPluginSchemaNames(string);
        if (set.contains(string2)) {
            try {
                return ssm.getPluginSchema(string2, string, null);
            }
            catch (Exception exception) {
                debug.error("Cannot get plugin schemas: " + string + " for policy", (Throwable)exception);
            }
        }
        return null;
    }

    static String getViewBeanURL(String string, String string2) {
        String string3 = null;
        if (string != null) {
            Iterator iterator = PolicyManager.getPluginSchemaNames(string).iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                PluginSchema pluginSchema = PolicyManager.getPluginSchema(string, string4);
                if (!string2.equals(pluginSchema.getClassName())) continue;
                string3 = pluginSchema.getPropertiesViewBeanURL();
                break;
            }
        }
        return string3;
    }

    Policy getPolicy(String string, boolean bl) throws SSOException, NoPermissionException, InvalidFormatException, NameNotFoundException, InvalidFormatException, PolicyException {
        Policy policy = null;
        policy = bl ? this.policyCache.getPolicy(this.org, string) : this.getPolicy(string);
        return policy;
    }

    ResourceIndexManager getResourceIndexManager() {
        return this.rim;
    }

    private boolean validateResourceForPrefix(ServiceType serviceType, String string) throws PolicyException {
        boolean bl = false;
        Set set = this.rm.getManagedResourceNames(serviceType.getName());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            String string2 = (String)iterator.next();
            ResourceMatch resourceMatch = serviceType.compare(string, string2, bl2 = true);
            if (!resourceMatch.equals(ResourceMatch.SUPER_RESOURCE_MATCH) && !resourceMatch.equals(ResourceMatch.WILDCARD_MATCH) && !resourceMatch.equals(ResourceMatch.EXACT_MATCH)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void validateForResourcePrefix(Policy policy) throws SSOException, PolicyException {
        DN dN = new DN(this.org);
        DN dN2 = new DN(ServiceManager.getBaseDN());
        Set set = this.rm.getManagedResourceNames();
        if (!dN.equals(dN2) && (set == null || set.isEmpty())) {
            Object[] objectArray = new String[]{this.org};
            throw new PolicyException(POLICY_DEBUG_NAME, "no_referral_can_not_create_policy", objectArray, null);
        }
        Iterator iterator = policy.getRuleNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Rule rule = policy.getRule(string);
            String string2 = rule.getServiceTypeName();
            ServiceType serviceType = this.getServiceTypeManager().getServiceType(string2);
            String string3 = rule.getResourceName();
            boolean bl = true;
            if (!dN.equals(dN2)) {
                bl = this.validateResourceForPrefix(serviceType, string3);
            }
            if (bl) continue;
            Object[] objectArray = new String[]{string3, serviceType.getName()};
            throw new PolicyException(POLICY_DEBUG_NAME, "resource_name_not_permitted_by_prefix_names", objectArray, null);
        }
    }

    private void validateReferrals(Policy policy) throws SSOException, PolicyException {
        Set set = policy.getReferredToOrganizations();
        if (set.contains(this.org.toLowerCase())) {
            Object[] objectArray = new String[]{this.org};
            throw new PolicyException(POLICY_DEBUG_NAME, "invalid_referral_pointing_to_self", objectArray, null);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.verifyOrgName(string);
        }
    }

    static {
        debug = Debug.getInstance((String)POLICY_DEBUG_NAME);
    }
}

