/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyEvent;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.policy.interfaces.ResourceName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PolicyDecisionCacheListener
implements PolicyListener,
SSOTokenListener {
    private static Map resultsCache = PolicyEvaluator.policyResultsCache;
    private static Map ssoListenerRegistry = PolicyEvaluator.ssoListenerRegistry;
    private static Debug debug = PolicyManager.debug;
    private static final String resourceWildcard = "*";
    private static final String resourceDelimiter = "/";
    private static final String resourceCase = "false";
    private ResourceName resourceNameUtil = null;
    private String serviceName = null;

    public PolicyDecisionCacheListener(String string) {
        this.serviceName = string;
        HashMap<String, String> hashMap = null;
        String string2 = null;
        try {
            hashMap = PolicyConfig.getResourceCompareConfig(string);
            if (hashMap != null) {
                string2 = (String)hashMap.get("class");
            } else {
                hashMap = new HashMap<String, String>();
                hashMap.put("delimiter", resourceDelimiter);
                hashMap.put("wildcard", resourceWildcard);
                hashMap.put("caseSensitive", resourceCase);
            }
            if (string2 != null) {
                Class<?> clazz = Class.forName(string2);
                this.resourceNameUtil = (ResourceName)clazz.newInstance();
                this.resourceNameUtil.initialize(hashMap);
            }
        }
        catch (Exception exception) {
            debug.error("PolicyDecisionCacheListener: failed to get a resource comparator", (Throwable)exception);
        }
    }

    public void setServiceTypeName(String string) {
        this.serviceName = string;
    }

    public String getServiceTypeName() {
        return this.serviceName;
    }

    public synchronized void policyChanged(PolicyEvent policyEvent) {
        HashMap hashMap;
        if (debug.messageEnabled()) {
            debug.message("PolicyDecisionCacheListener.policyChanged()");
        }
        if (policyEvent == null) {
            debug.error("PolicyDecisionCacheListener.policyChanged(): invalid policy event");
            return;
        }
        Set set = policyEvent.getResourceNames();
        if (debug.messageEnabled()) {
            debug.message("PolicyDecisionCacheListener.policyChanged(): resource names from the policy event :" + set.toString());
        }
        if (!resultsCache.isEmpty() && !set.isEmpty() && (hashMap = (HashMap)resultsCache.get(this.serviceName)) != null) {
            Set set2 = hashMap.keySet();
            Iterator iterator = set2.iterator();
            block0: while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    ResourceMatch resourceMatch = this.resourceNameUtil.compare(string, string2, true);
                    if (resourceMatch.equals(ResourceMatch.NO_MATCH)) continue;
                    iterator.remove();
                    if (!debug.messageEnabled()) continue block0;
                    debug.message("PolicyDecisionCacheListener.policyChanged(): cache wiped out for " + string);
                    continue block0;
                }
            }
        }
    }

    public void ssoTokenChanged(SSOTokenEvent sSOTokenEvent) {
        try {
            SSOTokenID sSOTokenID = sSOTokenEvent.getToken().getTokenID();
            String string = sSOTokenID.toString();
            if (string == null) {
                debug.error("PolicyDecisionCacheListener.ssoTokenChanged(): token id string is null");
                return;
            }
            Map map = PolicyEvaluator.policyResultsCache;
            synchronized (map) {
                if (!resultsCache.isEmpty()) {
                    Set set = resultsCache.keySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        Map map2 = (Map)resultsCache.get(string2);
                        if (map2 == null || map2.isEmpty()) continue;
                        Set set2 = map2.keySet();
                        Iterator iterator2 = set2.iterator();
                        while (iterator2.hasNext()) {
                            String string3 = (String)iterator2.next();
                            Map map3 = (Map)map2.get(string3);
                            if (map3 == null || map3.isEmpty() || map3.remove(string) == null || !debug.messageEnabled()) continue;
                            debug.message("PolicyDecisionCacheListener.ssoTokenChanged(): wipe out the policy results for an expired token " + string);
                        }
                    }
                }
            }
            ssoListenerRegistry.remove(string);
        }
        catch (Exception exception) {
            debug.error("exception in policy decision cache listener", (Throwable)exception);
        }
    }
}

