/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.services.util.XMLUtils;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.sm.AttributeSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class PolicyDecision {
    static final String POLICY_DECISION = "PolicyDecision";
    static final String RESPONSE_DECISIONS = "ResponseDecisions";
    Map actionDecisions = new HashMap();
    private Map responseDecisions;
    private long timeToLive = Long.MAX_VALUE;
    private boolean advicesAreSet = false;

    public Map getActionDecisions() {
        return this.actionDecisions;
    }

    void addActionDecision(ActionDecision actionDecision, ServiceType serviceType) {
        String string = actionDecision.getActionName();
        ActionDecision actionDecision2 = (ActionDecision)this.actionDecisions.get(string);
        if (actionDecision2 == null) {
            this.actionDecisions.put(string, actionDecision);
        } else {
            ActionSchema actionSchema = null;
            AttributeSchema.Syntax syntax = null;
            try {
                actionSchema = serviceType.getActionSchema(string);
                syntax = actionSchema.getSyntax();
            }
            catch (InvalidNameException invalidNameException) {
                PolicyManager.debug.error("can not find action schmea for action = " + string, (Throwable)invalidNameException);
            }
            if (!AttributeSchema.Syntax.BOOLEAN.equals(syntax)) {
                this.addActionDecision(actionDecision);
            } else {
                long l = actionDecision.getTimeToLive();
                long l2 = actionDecision2.getTimeToLive();
                String string2 = actionSchema.getFalseValue();
                String string3 = actionSchema.getTrueValue();
                Set set = actionDecision2.getValues();
                Set set2 = actionDecision.getValues();
                HashMap hashMap = null;
                Map map = actionDecision2.getAdvices();
                Map map2 = actionDecision.getAdvices();
                hashMap = set != null && !set.isEmpty() || set2 != null && !set2.isEmpty() ? new HashMap() : PolicyUtils.appendMapToMap(map, map2);
                if (set != null && set.contains(string2)) {
                    if (set2 != null && set2.contains(string2)) {
                        actionDecision2.setTimeToLive(Math.max(l, l2));
                    }
                } else if (set != null && set.contains(string3)) {
                    if (set2 != null && set2.contains(string2)) {
                        this.actionDecisions.put(string, actionDecision);
                    } else if (actionDecision.getValues().contains(string3)) {
                        actionDecision2.setTimeToLive(Math.max(l, l2));
                    }
                } else {
                    this.actionDecisions.put(string, actionDecision);
                }
                ActionDecision actionDecision3 = (ActionDecision)this.actionDecisions.get(string);
                actionDecision3.setAdvices(hashMap);
            }
        }
        this.setTimeToLive();
    }

    public void addActionDecision(ActionDecision actionDecision) {
        ActionDecision actionDecision2 = (ActionDecision)this.actionDecisions.get(actionDecision.getActionName());
        if (actionDecision2 == null) {
            this.actionDecisions.put(actionDecision.getActionName(), actionDecision);
        } else {
            Set set = actionDecision2.getValues();
            if (set == Collections.EMPTY_SET || set == null) {
                actionDecision2.setValues(actionDecision.getValues());
            } else {
                set.addAll(actionDecision.getValues());
            }
            if (actionDecision.getTimeToLive() < actionDecision2.getTimeToLive()) {
                actionDecision2.setTimeToLive(actionDecision.getTimeToLive());
            }
            PolicyUtils.appendMapToMap(actionDecision.getAdvices(), actionDecision2.getAdvices());
            this.setTimeToLive();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.actionDecisions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ActionDecision actionDecision = (ActionDecision)this.actionDecisions.get(string);
            Set set = actionDecision.getValues();
            stringBuffer.append(string + "=" + set + "\n");
        }
        return stringBuffer.toString();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<").append(POLICY_DECISION).append(">").append("\r\n");
        Iterator iterator = this.actionDecisions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ActionDecision actionDecision = (ActionDecision)this.actionDecisions.get(string);
            stringBuffer.append(actionDecision.toXML());
        }
        if (this.responseDecisions != null) {
            stringBuffer.append("<").append(RESPONSE_DECISIONS).append(">").append("\r\n");
            stringBuffer.append(PolicyUtils.mapToXMLString(this.responseDecisions));
            stringBuffer.append("</").append(RESPONSE_DECISIONS).append(">").append("\r\n");
        }
        stringBuffer.append("</").append(POLICY_DECISION).append(">").append("\r\n");
        return stringBuffer.toString();
    }

    public static PolicyDecision parsePolicyDecision(Node node) throws PolicyException {
        Object object;
        Node node2;
        PolicyDecision policyDecision = new PolicyDecision();
        Set set = XMLUtils.getChildNodes((Node)node, (String)"ActionDecision");
        if (set == null) {
            PolicyManager.debug.error("parsePolicyDecision: Required element not found in policy decision node:ActionDecision");
            Object[] objectArray = new Object[]{"ActionDecision"};
            throw new PolicyException("amPolicy", "missing_element", objectArray, null);
        }
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            node2 = (Node)object2.next();
            object = ActionDecision.parseActionDecision(node2);
            policyDecision.addActionDecision((ActionDecision)object);
        }
        object2 = XMLUtils.getChildNodes((Node)node, (String)RESPONSE_DECISIONS);
        if (object2 != null && !object2.isEmpty()) {
            node2 = (Node)object2.iterator().next();
            object = PolicyUtils.parseResponseDecisions(node2);
            policyDecision.setResponseDecisions((Map)object);
        }
        return policyDecision;
    }

    public Map getResponseDecisions() {
        return this.responseDecisions;
    }

    public void setResponseDecisions(Map map) {
        this.responseDecisions = map;
    }

    public Object clone() {
        Object object;
        Object object2;
        PolicyDecision policyDecision = new PolicyDecision();
        policyDecision.actionDecisions = new HashMap(this.actionDecisions.size());
        Iterator iterator = this.actionDecisions.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (ActionDecision)this.actionDecisions.get(object2);
            policyDecision.actionDecisions.put(object2, ((ActionDecision)object).clone());
        }
        if (this.responseDecisions != null) {
            policyDecision.responseDecisions = new HashMap(this.responseDecisions.size());
            object2 = this.responseDecisions.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                policyDecision.responseDecisions.put(object, this.responseDecisions.get(object));
            }
        }
        return policyDecision;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    private void setTimeToLive() {
        this.timeToLive = Long.MAX_VALUE;
        this.advicesAreSet = false;
        Iterator iterator = this.actionDecisions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ActionDecision actionDecision = (ActionDecision)this.actionDecisions.get(string);
            long l = actionDecision.getTimeToLive();
            if (l < this.timeToLive) {
                this.timeToLive = l;
            }
            boolean bl = this.advicesAreSet = this.advicesAreSet || actionDecision.getAdvices() != null && !actionDecision.getAdvices().isEmpty();
        }
    }

    void setTimeToLive(long l) {
        this.timeToLive = l;
    }

    public boolean hasAdvices() {
        return this.advicesAreSet;
    }
}

